/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public enum LibFMLMessage {
    NONE(""),
    TICK_ADVANCEMENTS("tickAdvancements"),
    TICK_SCORE_ADVANCEMENTS("tickScorebased"),
    OMIT_FROM_RANDOM_ENCHANTS("omitFromRandomEnchants"),
    OMIT_FROM_RANDOM_POTIONS("omitFromRandomPotions"),
    ENABLE_BARTERING_TOKENS("enableBarterTokens"),
    ENABLE_UNCURABLE_EFFECTS("enableUncurableEffects"),
    SPECIAL_DROPS_LIFESPAN_TICKS("specialDropLifespanTicks"),
    FARMED_DROPS_LIFESPAN_TICKS("farmDropLifespanTicks"),
    ADD_AGE_SYNONYM("addAgeSynonym"),
    ADD_MOISTURE_SYNONYM("addMoistureSynonym"),
    ENABLE_NUTRITION_NOTES("enabledNNotes"),
    BROADCAST_ALMANAC_ROLLOVERS("tickAlmanacs"),
    DISABLE_ATTRIBUTES_HANDLER("disableAttributesHandler"),
    ADD_MILK_BUCKET("addMilkBucket"),
    DISABLE_FIGHTING_FOODS("disableFightingFoods");

    private final String _id;
    static final Map<String, LibFMLMessage> _MAP;

    private LibFMLMessage(String name) {
        this._id = name;
    }

    public final String api() {
        return this._id;
    }

    public String toString() {
        return this._id;
    }

    @Nonnull
    public static final LibFMLMessage findOrNone(String api) {
        return _MAP.getOrDefault(api, NONE);
    }

    static {
        _MAP = new HashMap<String, LibFMLMessage>();
        for (LibFMLMessage msg : LibFMLMessage.values()) {
            _MAP.put(msg.api(), msg);
        }
    }
}

