/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IWorldInfo;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.SharedGlue;

@ParametersAreNonnullByDefault
public final class Locations {
    public static final ResourceLocation BIOME_ID_END = new ResourceLocation("the_end");
    public static final ResourceLocation BIOME_ID_NETHER = new ResourceLocation("nether");
    private static DimensionType _DA_OVERWORLD;
    private static DimensionType _DA_NETHER;
    private static DimensionType _DA_END;

    @Nullable
    public static final RegistryKey<Biome> biomeKeyFor(@Nonnull IBiomeReader aworld, BlockPos at) {
        return aworld.func_242406_i(at).orElse(null);
    }

    @Nullable
    public static final Biome biomeFor(@Nonnull IBiomeReader aworld, RegistryKey<Biome> biome) {
        return (Biome)SharedGlue.getMCDynamicRegistries(aworld).func_243612_b(Registry.field_239720_u_).func_230516_a_(biome);
    }

    public static final boolean isBiomeLike(RegistryKey<Biome> biome, RegistryKey<Biome> baseline, BiomeDictionary.Type ... plus) {
        if (biome == null) {
            return false;
        }
        Set biomeTypes = BiomeDictionary.getTypes(biome);
        for (BiomeDictionary.Type wantedType : BiomeDictionary.getTypes(baseline)) {
            if (biomeTypes.contains(wantedType)) continue;
            return false;
        }
        for (BiomeDictionary.Type wantedType : plus) {
            if (biomeTypes.contains(wantedType)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isBiomeLike(@Nonnull RegistryKey<Biome> biome, BiomeDictionary.Type ... plus) {
        if (biome == null) {
            return false;
        }
        Set biomeTypes = BiomeDictionary.getTypes(biome);
        for (BiomeDictionary.Type wantedType : plus) {
            if (biomeTypes.contains(wantedType)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isBiomeLikeAny(@Nonnull RegistryKey<Biome> biome, BiomeDictionary.Type ... plus) {
        if (biome != null) {
            Set biomeTypes = BiomeDictionary.getTypes(biome);
            for (BiomeDictionary.Type wantedType : plus) {
                if (!biomeTypes.contains(wantedType)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean inBiomeLike(@Nonnull Entity entity, RegistryKey<Biome> target_biome, BiomeDictionary.Type ... plus) {
        RegistryKey<Biome> source_biome = Locations.biomeKeyFor((IBiomeReader)entity.func_130014_f_(), entity.func_233580_cy_());
        return source_biome != null && Locations.isBiomeLike(source_biome, target_biome, plus);
    }

    public static final boolean isaRegularJungle(RegistryKey<Biome> biome) {
        return biome == Biomes.field_76782_w || biome == Biomes.field_76792_x || biome == Biomes.field_150574_L || biome == Biomes.field_185446_X || biome == Biomes.field_185447_Y || biome == Biomes.field_222370_aw || biome == Biomes.field_222371_ax;
    }

    public static final boolean isaRegularSwamp(RegistryKey<Biome> biome) {
        return biome == Biomes.field_76780_h || biome == Biomes.field_150599_m;
    }

    public static final boolean isaRegularTaiga(RegistryKey<Biome> biome) {
        return biome == Biomes.field_76768_g || biome == Biomes.field_76784_u || biome == Biomes.field_150590_f || biome == Biomes.field_150578_U || biome == Biomes.field_150581_V || biome == Biomes.field_185432_ad || biome == Biomes.field_185433_ae || biome == Biomes.field_150584_S || biome == Biomes.field_150579_T || biome == Biomes.field_185431_ac;
    }

    public static final boolean isaRegularColdMountain(RegistryKey<Biome> biome) {
        return biome == Biomes.field_76770_e || biome == Biomes.field_76775_o || biome == Biomes.field_150580_W || biome == Biomes.field_76783_v || biome == Biomes.field_185443_S || biome == Biomes.field_185434_af || biome == Biomes.field_150590_f || biome == Biomes.field_185431_ac;
    }

    public static final boolean inHighHumidity(@Nullable RegistryKey<Biome> biome, IBiomeReader aworld, BlockPos at) {
        Biome biome_obj;
        if (biome == null) {
            biome = Locations.biomeKeyFor(aworld, at);
        }
        if ((biome_obj = Locations.biomeFor(aworld, biome)) != null) {
            return biome_obj.func_76736_e() || biome_obj.func_201856_r() == Biome.Category.JUNGLE || biome_obj.func_201856_r() == Biome.Category.SWAMP;
        }
        return Locations.isaRegularJungle(biome) || Locations.isaRegularSwamp(biome);
    }

    @Nonnull
    public static final ServerWorld getOverworld(MinecraftServer mc) {
        return mc != null ? mc.func_241755_D_() : SharedGlue.getMCServer().func_241755_D_();
    }

    @Nullable
    public static final DimensionType getDimensionType(@Nonnull RegistryKey<DimensionType> dimtype) {
        return (DimensionType)SharedGlue.getMCDynamicRegistries().func_230520_a_().func_230516_a_(dimtype);
    }

    public static final boolean isOverworld(DimensionType dimtype) {
        return dimtype != null && dimtype == _DA_OVERWORLD;
    }

    @Nonnull
    public static final DimensionType readOverworldType() {
        return DimensionType.field_236004_h_;
    }

    @Nonnull
    public static final DimensionType getOverworldDimType() {
        return _DA_OVERWORLD != null ? _DA_OVERWORLD : Locations.readOverworldType();
    }

    @Nonnull
    public static final DimensionType readTheNetherType() {
        return (DimensionType)SharedGlue.getMCDynamicRegistries().func_230520_a_().func_243576_d(DimensionType.field_236000_d_);
    }

    @Nonnull
    public static final DimensionType readTheEndType() {
        return (DimensionType)SharedGlue.getMCDynamicRegistries().func_230520_a_().func_243576_d(DimensionType.field_236001_e_);
    }

    @Nonnull
    public static final DimensionType getDimensionType(@Nullable IWorldReader aworld) {
        return aworld == null || aworld.func_230315_m_() == null ? _DA_OVERWORLD : aworld.func_230315_m_();
    }

    @Deprecated
    public static final int readDimensionId(@Nullable IWorldReader aworld) {
        DimensionType dimtype = Locations.getDimensionType(aworld);
        return SharedGlue.getMCDynamicRegistries().func_243612_b(Registry.field_239698_ad_).func_148757_b((Object)dimtype);
    }

    public static final boolean isOverworld(@Nullable IWorldReader aworld) {
        return aworld != null && aworld.func_230315_m_() == _DA_OVERWORLD;
    }

    public static final boolean isOverworldLike(@Nullable World aworld, BlockPos at) {
        return aworld != null && Locations.isBiomeLike(Locations.biomeKeyFor((IBiomeReader)aworld, at), BiomeDictionary.Type.OVERWORLD);
    }

    public static final boolean inTheOverworld(@Nullable IWorldReader aworld, @Nonnull Entity wrt) {
        return Locations.isOverworld((IWorldReader)(aworld != null ? aworld : wrt.func_130014_f_()));
    }

    public static final boolean inTheNether(@Nullable RegistryKey<Biome> biome, @Nonnull IBiomeReader aworld, @Nonnull BlockPos at) {
        if (aworld.func_230315_m_() == _DA_OVERWORLD) {
            return false;
        }
        if (biome == null) {
            biome = Locations.biomeKeyFor(aworld, at);
        }
        if (BiomeDictionary.hasType(biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return true;
        }
        Biome biome_obj = Locations.biomeFor(aworld, biome);
        return biome_obj != null && biome_obj.func_201856_r() == Biome.Category.NETHER;
    }

    public static final boolean inTheNether(@Nullable IBiomeReader aworld, @Nonnull Entity wrt) {
        if (aworld == null) {
            aworld = wrt.func_130014_f_();
        }
        if (aworld.func_230315_m_() == _DA_NETHER) {
            return true;
        }
        return Locations.inTheNether(null, aworld, wrt.func_233580_cy_());
    }

    public static final boolean inTheEnd(@Nullable RegistryKey<Biome> biome, @Nonnull IBiomeReader aworld, @Nonnull BlockPos at) {
        if (aworld.func_230315_m_() == _DA_OVERWORLD) {
            return false;
        }
        if (biome == null) {
            biome = Locations.biomeKeyFor(aworld, at);
        }
        if (BiomeDictionary.hasType(biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            return true;
        }
        Biome biome_obj = Locations.biomeFor(aworld, biome);
        return biome_obj != null && biome_obj.func_201856_r() == Biome.Category.THEEND;
    }

    public static final boolean inTheEnd(@Nullable IBiomeReader aworld, @Nonnull Entity wrt) {
        if (aworld == null) {
            aworld = wrt.func_130014_f_();
        }
        if (aworld.func_230315_m_() == _DA_END) {
            return true;
        }
        return Locations.inTheEnd(null, aworld, wrt.func_233580_cy_());
    }

    public static final boolean isBlockLoaded(@Nullable IBlockReader aworld, @Nonnull BlockPos blockpos) {
        if (aworld == null) {
            return false;
        }
        if (aworld instanceof World) {
            return ((World)aworld).func_195588_v(blockpos);
        }
        if (aworld instanceof IWorldReader) {
            return ((IWorldReader)aworld).func_175667_e(blockpos);
        }
        return true;
    }

    @Nonnull
    public static final BlockPos getSpawnPoint(@Nonnull World world) {
        IWorldInfo wi = world.func_72912_H();
        BlockPos pos = new BlockPos(wi.func_76079_c(), wi.func_76075_d(), wi.func_76074_e());
        if (!world.func_175723_af().func_177746_a(pos)) {
            pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, new BlockPos(world.func_175723_af().func_230316_a_(), 0.0, world.func_175723_af().func_230317_b_()));
        }
        return pos;
    }

    @Nonnull
    public static final Optional<BlockXyz> getSpawnPoint(ServerPlayerEntity player, boolean load) {
        BlockPos pos = player.func_241140_K_();
        RegistryKey dim = player.func_241141_L_();
        if (pos == null || dim == null) {
            return Optional.empty();
        }
        BlockXyz spawn = new BlockXyz();
        spawn.pos = pos;
        spawn.worldr = player.func_184102_h().func_71218_a(dim);
        spawn.dim = dim;
        if (spawn.worldr == null) {
            return Optional.empty();
        }
        if (load || spawn.worldr.func_175667_e(pos)) {
            spawn.state = spawn.worldr.func_180495_p(pos);
        }
        return Optional.of(spawn);
    }

    public static Optional<Vector3d> getSpawnPointStrictly(ServerPlayerEntity player) {
        ServerWorld server = player.func_184102_h().func_71218_a(player.func_241141_L_());
        BlockPos spawn = player.func_241140_K_();
        float spawnAngle = player.func_242109_L();
        return PlayerEntity.func_242374_a((ServerWorld)server, (BlockPos)spawn, (float)spawnAngle, (boolean)false, (boolean)true);
    }

    private static final boolean isBreathable(World in, BlockPos pos, boolean liquid_check) {
        BlockState at = in.func_180495_p(pos);
        return !at.func_185904_a().func_76220_a() && (!liquid_check || !at.func_185904_a().func_76224_d());
    }

    private static boolean isSafeLanding(World in, BlockPos on) {
        return Locations.isBreathable(in, on.func_177981_b(1), false) && Locations.isBreathable(in, on.func_177981_b(2), true);
    }

    public static boolean findSurface(World in, ServerPlayerEntity player, BlockPos pos, int maxHeight) {
        if (in.func_180495_p(pos).func_200132_m() || !in.func_226660_f_(pos)) {
            for (int dh = 1; dh < maxHeight; ++dh) {
                BlockPos on = player.func_233580_cy_().func_177981_b(dh);
                if (!in.func_226660_f_(on) || !Locations.isSafeLanding(in, on)) continue;
                player.func_70634_a((double)on.func_177958_n(), (double)on.func_177956_o(), (double)on.func_177952_p());
                return true;
            }
        } else {
            for (int dh = 1; dh < maxHeight; ++dh) {
                BlockPos on = player.func_233580_cy_().func_177979_c(dh);
                if (!in.func_180495_p(on).func_200132_m() || !Locations.isSafeLanding(in, on)) continue;
                player.func_70634_a((double)on.func_177958_n(), (double)(on.func_177956_o() + 1), (double)on.func_177952_p());
                return true;
            }
        }
        return false;
    }

    public static Boolean returnHome(ServerPlayerEntity player, int maxSearchHeight) {
        Boolean worked = null;
        World world = player.func_130014_f_();
        if (world.func_234923_W_() == World.field_234918_g_) {
            Optional<Vector3d> spawn = Locations.getSpawnPointStrictly(player);
            if (spawn.isPresent()) {
                player.func_70634_a((double)((int)spawn.get().func_82615_a()), (double)((int)spawn.get().func_82617_b()), (double)((int)spawn.get().func_82616_c()));
                worked = true;
            } else if (maxSearchHeight > 0) {
                player.func_70634_a(0.0, (double)maxSearchHeight, 0.0);
                if (Locations.findSurface(world, player, player.func_233580_cy_(), maxSearchHeight)) {
                    worked = false;
                }
            }
        }
        return worked;
    }

    public static final boolean isLikelyRealPosition(@Nullable IWorldReader aworld, BlockPos blockpos) {
        return !BlockPos.field_177992_a.equals((Object)blockpos) && aworld instanceof World && Locations.isBlockLoaded((IBlockReader)aworld, blockpos);
    }

    public static final boolean isLikelyRealPositionChecked(@Nullable IWorldReader aworld, BlockPos blockpos) {
        if (!Locations.isLikelyRealPosition(aworld, blockpos)) {
            return false;
        }
        return ((World)aworld).func_190525_a((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), 4.0, SharedGlue.IS_BREATHING_PLAYER) != null;
    }

    public static boolean isInStructure(ServerWorld world, BlockPos pos, Structure<?> structure) {
        return world.func_241112_a_().func_235010_a_(pos, true, structure).func_75069_d();
    }

    public static final boolean isGrowableYPos(IBlockReader aworld, BlockPos at) {
        return !World.func_189509_E((BlockPos)at) && at.func_177956_o() >= 15 && at.func_177956_o() < SharedGlue.WORLD_HEIGHT();
    }

    public static final boolean canSeeSky(IWorldReader aworld, BlockPos at, boolean ignore_glass) {
        return aworld.func_175710_j(at);
    }

    private Locations() {
    }

    public static final void cacheDimensionTypes() {
        _DA_OVERWORLD = Objects.requireNonNull(Locations.readOverworldType(), "overworld dimType MUST exist");
        _DA_END = Locations.readTheEndType();
        _DA_NETHER = Locations.readTheNetherType();
    }
}

