/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import com.mojang.datafixers.util.Pair;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityPropertiesPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.MagnifyingPotionEffect;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.NPE;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.StubbornPotionEffect;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.impl.ObjRef;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;

public final class Potions {
    public static final EffectInstance[] EMPTY_EFFECTS = new EffectInstance[0];
    public static final int MAX_AMPLIFY_LEVEL = 4;
    public static Potion PLACEHOLDER = net.minecraft.potion.Potions.field_185229_a;
    public static final Effect NO_EFFECT = new Effect(EffectType.NEUTRAL, 0xFFFFFF){

        protected String func_210758_b() {
            return "effect." + LibInfo.lstring("placeholder");
        }

        public boolean func_76397_a(int d, int a) {
            return false;
        }

        public void func_76394_a(LivingEntity le, int amplifier) {
        }

        public void func_180793_a(@Nullable Entity e, @Nullable Entity es, LivingEntity le, int a, double h) {
        }
    };
    private static final int _FOREVER_THRESHOLD_DURATION = 32000;
    static final String _CUSTOM_ELIXIR_EFFECTS_TAGNAME = "ElixirEffects";
    public static final String _DEFAULT_MINECRAFT_PREFIX = "item.minecraft.potion.effect.";
    private static Method _ON_FINISHED_POTION_EFFECT = null;
    private static Field _FOOD_POTION_EFFECTS = null;

    public static final boolean isEmpty(@Nullable Effect e) {
        return e == null || e == NO_EFFECT;
    }

    public static final boolean isEmpty(@Nullable Potion p) {
        if (p != null && !p.func_185170_a().isEmpty()) {
            for (EffectInstance e : p.func_185170_a()) {
                if (Potions.isEmpty(e.func_188419_a())) continue;
                return false;
            }
        }
        return true;
    }

    public static final boolean isLikelyForever(int duration) {
        return duration < 0 || duration > 32000;
    }

    public static final boolean isLikelyForever(EffectInstance e) {
        return e != null && Potions.isLikelyForever(e.func_76459_b());
    }

    public static final ItemStack newPotionHeldItem(Potion potion) {
        ItemStack potionitem = new ItemStack((IItemProvider)Items.field_151068_bn);
        potionitem = !ForgeRegistries.POTION_TYPES.containsKey(potion.getRegistryName()) ? PotionUtils.func_185184_a((ItemStack)potionitem, (Collection)potion.func_185170_a()) : PotionUtils.func_185188_a((ItemStack)potionitem, (Potion)potion);
        return potionitem;
    }

    public static final void addEffect(ItemStack to, EffectInstance effect) {
        if (to != ItemStack.field_190927_a) {
            PotionUtils.func_185184_a((ItemStack)to, Collections.singleton(effect));
        }
    }

    public static final ItemStack newSoakedPotionPlaceholderItem(@Nonnull ItemStack original) {
        return PotionUtils.func_185188_a((ItemStack)ItemStacks.copy1(original), (Potion)SharedGlue.PotionType_harmless);
    }

    public static final EffectInstance newPotionEffect(Effect effect, int duration, int amplifier, boolean ambient, boolean particles) {
        return new EffectInstance(effect, duration, amplifier, ambient, particles);
    }

    public static final EffectInstance newPotionEffect(Effect effect, int duration, int amplifier) {
        return new EffectInstance(effect, duration, amplifier);
    }

    public static final EffectInstance newHiddenPotionEffect(Effect effect, int duration, int amplifier) {
        return new EffectInstance(effect, duration, amplifier, false, false);
    }

    public static final EffectInstance newPotionTypeEffect(Effect effect, int duration_secs, int amplifier) {
        return new EffectInstance(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, false, true);
    }

    public static final EffectInstance newHiddenPotionTypeEffect(Effect effect, int duration_secs, int amplifier) {
        return new EffectInstance(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, false, false);
    }

    public static final EffectInstance newStubbornPotionEffect(Effect effect, int duration, int amplifier, boolean ambient, boolean particles) {
        return new StubbornPotionEffect(false, effect, duration, amplifier, ambient, particles);
    }

    public static final EffectInstance newFortifiedPotionEffect(Effect effect, int duration, int amplifier, boolean ambient, boolean particles) {
        return new StubbornPotionEffect(true, effect, duration, amplifier, ambient, particles);
    }

    public static final EffectInstance newForeverEffect(Effect effect, int amplifier) {
        return new EffectInstance(effect, Integer.MAX_VALUE, amplifier, false, false);
    }

    public static final EffectInstance newInstantEffect(Effect effect, int amplifier) {
        return new EffectInstance(effect, 1, amplifier, false, false);
    }

    public static final EffectInstance copyPotionEffect(EffectInstance source) {
        if (source instanceof MagnifyingPotionEffect) {
            return new MagnifyingPotionEffect((MagnifyingPotionEffect)source);
        }
        if (source instanceof StubbornPotionEffect) {
            return new StubbornPotionEffect((StubbornPotionEffect)source);
        }
        return new EffectInstance(source);
    }

    public static final boolean removePotionEffectUnconditionally(@Nonnull LivingEntity entity, @Nonnull Effect effect) {
        boolean tried = false;
        EffectInstance effectinstance = entity.func_184596_c(effect);
        if (effectinstance != null) {
            Potions.onFinishedPotionEffect(entity, effectinstance);
            tried = !entity.func_70644_a(effect);
        }
        return tried;
    }

    public static final boolean removePotionEffect(@Nonnull LivingEntity entity, @Nonnull Effect effect) {
        boolean tried = entity.func_70644_a(effect);
        entity.func_195063_d(effect);
        return tried && !entity.func_70644_a(effect);
    }

    static final boolean _removeEffect(LivingEntity entity, Effect effect, boolean unconditional) {
        return unconditional ? Potions.removePotionEffectUnconditionally(entity, effect) : Potions.removePotionEffect(entity, effect);
    }

    public static final void removePotionEffect(@Nonnull LivingEntity entity, @Nonnull Potion potion) {
        for (EffectInstance e : potion.func_185170_a()) {
            entity.func_195063_d(e.func_188419_a());
        }
    }

    public static final void removePotionEffectUnconditionally(@Nonnull LivingEntity entity, @Nonnull Potion potion) {
        for (EffectInstance e : potion.func_185170_a()) {
            Potions._removeEffect(entity, e.func_188419_a(), true);
        }
    }

    public static final void curePotionEffects(LivingEntity player, ItemStack with) {
        player.curePotionEffects(with);
    }

    public static final boolean addPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        return entity.func_195064_c(Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles));
    }

    public static final boolean addPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier) {
        return entity.func_195064_c(Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier));
    }

    public static final boolean addPotionEffect(LivingEntity entity, ModIntegration mod, String effect_name, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        boolean tried = false;
        Effect effect = mod.potion(effect_name);
        if (!Potions.isEmpty(effect)) {
            tried = Potions.addPotionEffect(entity, effect, duration_secs, amplifier, ambient, particles);
        }
        return tried;
    }

    public static final boolean addSecondaryPotionEffect(LivingEntity entity, Effect neweffect, Effect oldeffect, int amplifier) {
        boolean tried = false;
        EffectInstance current = entity.func_70660_b(oldeffect);
        if (current != null) {
            if (amplifier < 0) {
                amplifier = current.func_76458_c();
            }
            tried = entity.func_195064_c(Potions.newPotionEffect(neweffect, current.func_76459_b(), amplifier, false, false));
        }
        return tried;
    }

    public static final boolean addSharedPotionEffect(LivingEntity to, EffectInstance from, Effect shared, int duration_secs, int amplifier, boolean particles) {
        boolean tried = false;
        if (shared == null && from != null) {
            shared = from.func_188419_a();
        }
        if (shared != null && from != null) {
            int duration;
            int n = duration = duration_secs <= 0 ? from.func_76459_b() : SharedGlue.ticksFromSeconds(duration_secs);
            if (amplifier < 0) {
                amplifier = from.func_76458_c();
            }
            tried = to.func_195064_c(Potions.newPotionEffect(shared, duration, amplifier, false, particles));
        }
        return tried;
    }

    public static final boolean addFoodEffect(Item item, EffectInstance to, float chance) {
        Food food;
        if (item.func_219971_r() && (food = item.func_219967_s()) != null) {
            List<Pair<Supplier<EffectInstance>, Float>> itemeffects = Potions.effectsFor(item.func_219967_s());
            if (itemeffects == null) {
                return false;
            }
            itemeffects.add((Pair<Supplier<EffectInstance>, Float>)Pair.of(() -> to, (Object)Float.valueOf(chance)));
        }
        return true;
    }

    public static final void addPotionEffect(Item food, Effect effect, int duration_secs, int amplifier, float chance) {
        Potions.addFoodEffect(food, Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier), chance);
    }

    public static final void addPotionEffect(Item food, ModIntegration mod, String effect_name, int duration_secs, int amplifier, float chance) {
        Effect effect = mod.potion(effect_name);
        if (!Potions.isEmpty(effect)) {
            Potions.addPotionEffect(food, effect, duration_secs, amplifier, chance);
        }
    }

    public static final boolean setFoodEffect(Item item, EffectInstance to, float chance) {
        Food food;
        if (item.func_219971_r() && (food = item.func_219967_s()) != null) {
            List<Pair<Supplier<EffectInstance>, Float>> itemeffects = Potions.effectsFor(item.func_219967_s());
            if (itemeffects == null) {
                return false;
            }
            itemeffects.clear();
            itemeffects.add((Pair<Supplier<EffectInstance>, Float>)Pair.of(() -> to, (Object)Float.valueOf(chance)));
        }
        return true;
    }

    public static final void applyPotionEffect(LivingEntity victim, Effect effect, int duration_secs, int amplifier) {
        if (effect.func_76403_b() && duration_secs <= 0) {
            effect.func_180793_a(null, null, victim, amplifier, 1.0);
        } else {
            Potions.addPotionEffect(victim, effect, duration_secs, amplifier);
        }
    }

    public static final void applyEffect(@Nonnull EffectInstance effect, @Nonnull LivingEntity victim) {
        if (effect.func_188419_a().func_76403_b() && effect.func_188419_a() != SharedGlue.Potion_saturation) {
            effect.func_188419_a().func_180793_a(null, null, victim, effect.func_76458_c(), 1.0);
        } else {
            victim.func_195064_c(Potions.copyPotionEffect(effect));
        }
    }

    public static final void addPotionEffects(@Nonnull LivingEntity victim, @Nonnull Potion potion) {
        for (EffectInstance e : potion.func_185170_a()) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffects(@Nonnull LivingEntity victim, @Nonnull ItemStack potion_source) {
        List<EffectInstance> effects = Potions.getEffects(potion_source, false);
        for (EffectInstance e : effects) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffects(@Nonnull LivingEntity victim, @Nonnull FluidStack potion_source) {
        List<EffectInstance> effects = Potions.getEffects(potion_source);
        for (EffectInstance e : effects) {
            Potions.applyEffect(e, victim);
        }
    }

    public static final void addPotionEffect(LivingEntity victim, Effect effect, int duration_secs, int amplifier, Object ... cures) {
        EffectInstance potioneffect = Potions.newPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier);
        for (Object cure : cures) {
            if (cure == null) continue;
            potioneffect.addCurativeItem(cure instanceof ItemStack ? (ItemStack)cure : ItemStacks.create((Item)cure));
        }
        victim.func_195064_c(potioneffect);
    }

    public static final void addStubbornPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_195064_c(Potions.newStubbornPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles));
    }

    public static final void addStubbornPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, Object ... cures) {
        EffectInstance potioneffect = Potions.newStubbornPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, false, false);
        if (cures != null) {
            for (Object cure : cures) {
                potioneffect.addCurativeItem(cure instanceof ItemStack ? (ItemStack)cure : ItemStacks.create((Item)cure));
            }
        }
        entity.func_195064_c(potioneffect);
    }

    public static final void addStubbornPotionEffects(@Nonnull LivingEntity victim, @Nonnull ItemStack potion_source) {
        List effects = Potions.getEffects(potion_source, false).stream().map(e -> StubbornPotionEffect.from(e)).collect(Collectors.toList());
        for (EffectInstance e2 : effects) {
            Potions.applyEffect(e2, victim);
        }
    }

    public static final void addFortifiedPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        entity.func_195064_c(Potions.newFortifiedPotionEffect(effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles));
    }

    public static final void addMagniferPotionEffect(LivingEntity entity, Effect effect, int duration_secs, int amplifier, boolean ambient, boolean particles) {
        MagnifyingPotionEffect e = new MagnifyingPotionEffect(false, effect, SharedGlue.ticksFromSeconds(duration_secs), amplifier, ambient, particles);
        entity.func_195064_c((EffectInstance)e);
    }

    public static final boolean isMilk(ItemStack stack, boolean modded) {
        Item item;
        Item item2 = item = !ItemStacks.isEmpty(stack) ? stack.func_77973_b() : null;
        if (item != null) {
            UseAction useaction;
            if (item == Items.field_151117_aB) {
                return true;
            }
            FluidStack fluidstack = Fluids.getBucketFluid(stack);
            if (fluidstack.isEmpty()) {
                fluidstack = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
            }
            if (!fluidstack.isEmpty()) {
                String fluidName = Fluids.name(fluidstack.getFluid());
                if (Fluids.isMilkLike(fluidName)) {
                    if (ModIntegration.isUniversalBucket(stack)) {
                        return true;
                    }
                    UseAction useaction2 = stack.func_77975_n();
                    if (useaction2 == UseAction.DRINK || useaction2 == UseAction.EAT) {
                        return true;
                    }
                } else if (modded && (fluidName.startsWith("milk_") || fluidName.endsWith("_milk"))) {
                    return true;
                }
            } else if (modded && ((useaction = stack.func_77975_n()) == UseAction.DRINK || useaction == UseAction.EAT)) {
                return ModIntegration.isCustomMilkBottle(stack);
            }
        }
        return false;
    }

    public static final EffectType getEffectType(Effect effect) {
        return effect != null ? effect.func_220303_e() : EffectType.NEUTRAL;
    }

    static final boolean isReallyNeutral(Effect effect) {
        return effect == NO_EFFECT || effect instanceof IPlacebo;
    }

    public static final boolean isHarmful(@Nonnull Effect effect, boolean neutralIsBad) {
        EffectType et = Potions.getEffectType(effect);
        return et == EffectType.NEUTRAL && !Potions.isReallyNeutral(effect) ? neutralIsBad : et == EffectType.HARMFUL;
    }

    public static final boolean isCurative(@Nonnull LivingEntity entity, ItemStack item) {
        return Potions.isCurative(entity, item, false);
    }

    public static final boolean isCurative(@Nonnull LivingEntity entity, ItemStack item, boolean general) {
        if (!ItemStacks.isEmpty(item)) {
            if (general && item.func_77973_b() instanceof ICurative) {
                return true;
            }
            for (EffectInstance potioneffect : entity.func_70651_bq()) {
                if (!potioneffect.isCurativeItem(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static final void addMilkBasedRegenEffect(Item food, int duration, int amplifier) {
        Potions.addPotionEffect(food, SharedGlue.Potion_regeneration, duration, amplifier, 1.0f);
    }

    public static final void addMilkBasedRegenEffect(Item food) {
        Potions.addMilkBasedRegenEffect(food, 15, 2);
    }

    public static final void addMilkBoostRegenEffect(@Nullable LivingEntity entity) {
        if (entity != null) {
            Potions.addPotionEffect(entity, SharedGlue.Potion_regeneration, 15, 1);
        }
    }

    public static final void scrubAllEffects(@Nullable LivingEntity entity, boolean notify_safe) {
        if (entity != null) {
            ArrayList all = new ArrayList(entity.func_70651_bq());
            for (EffectInstance ei : all) {
                ei.field_76460_b = 0;
                ei.field_76461_c = 0;
                if (notify_safe) {
                    Potions.removePotionEffectUnconditionally(entity, ei.func_188419_a());
                    continue;
                }
                entity.func_184596_c(ei.func_188419_a());
            }
            all.clear();
            all.addAll(entity.func_193076_bZ().values());
            for (EffectInstance ei : all) {
                entity.func_184596_c(ei.func_188419_a());
            }
        }
    }

    public static final void removeAllEffects(@Nullable LivingEntity entity, boolean nicely) {
        if (entity != null) {
            if (nicely && entity.field_70170_p != null && entity.func_70089_S()) {
                entity.func_195061_cb();
            }
            ArrayList sticky = new ArrayList(entity.func_193076_bZ().values());
            for (EffectInstance ei : sticky) {
                ei.field_76460_b = 0;
                ei.field_76461_c = 0;
                Potions.removePotionEffectUnconditionally(entity, ei.func_188419_a());
            }
        }
    }

    public static final void removeAllEffects(@Nullable LivingEntity entity) {
        Potions.removeAllEffects(entity, true);
    }

    public static final boolean isEffectivelyBad(EffectInstance effect, @Nullable LivingEntity entity, Boolean neutralIsBad) {
        Effect potion = effect.func_188419_a();
        boolean is = Potions.isHarmful(potion, neutralIsBad == null ? LibConfig.neutralPotionsEffectivelyBad() : neutralIsBad);
        if (!is) {
            boolean inversed;
            boolean bl = inversed = effect.func_76458_c() < 0;
            if (inversed && (potion == SharedGlue.Potion_healthBoost || potion == SharedGlue.Potion_moveSpeed || potion == SharedGlue.Potion_resistance || potion == SharedGlue.Potion_jump || potion == SharedGlue.Potion_digSpeed || potion == SharedGlue.Potion_slowfall)) {
                is = true;
            }
        }
        if (NPE.isa((Entity)entity) && entity.func_70662_br()) {
            if (potion == net.minecraft.potion.Effects.field_76433_i) {
                is = false;
            } else if (potion == net.minecraft.potion.Effects.field_76432_h) {
                is = true;
            }
        }
        return is;
    }

    public static final boolean isEffectivelyBad(EffectInstance effect) {
        return Potions.isEffectivelyBad(effect, null, null);
    }

    public static final boolean hasAtLeastOneNegativeEffect(@Nullable Stream<EffectInstance> effects) {
        return effects == null ? false : effects.anyMatch(ei -> Potions.isEffectivelyBad(ei));
    }

    public static final boolean hasAtLeastOneNegativeEffect(@Nullable PlayerEntity player) {
        return player == null ? false : Potions.hasAtLeastOneNegativeEffect(player.func_70651_bq().stream());
    }

    public static final boolean cureAllBadEffects(@Nullable LivingEntity entity, boolean neutralIsBad) {
        int affected = 0;
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            ArrayList<Effect> remove = null;
            for (EffectInstance effect : effects) {
                if (!Potions.isEffectivelyBad(effect, entity, neutralIsBad)) continue;
                if (remove == null) {
                    remove = new ArrayList<Effect>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                for (Effect badpotion : remove) {
                    Potions.removePotionEffectUnconditionally(entity, badpotion);
                    if (entity.func_70660_b(badpotion) != null) continue;
                    ++affected;
                }
            }
        }
        return affected > 0;
    }

    public static final boolean removeAllHelpfulEffects(@Nullable LivingEntity entity, boolean neutralIsBad) {
        int affected = 0;
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            ArrayList<Effect> remove = null;
            for (EffectInstance effect : effects) {
                if (Potions.isEffectivelyBad(effect, entity, neutralIsBad)) continue;
                if (remove == null) {
                    remove = new ArrayList<Effect>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                for (Effect goodpotion : remove) {
                    Potions.removePotionEffectUnconditionally(entity, goodpotion);
                    if (entity.func_70660_b(goodpotion) != null) continue;
                    ++affected;
                }
            }
        }
        return affected > 0;
    }

    public static final boolean removeOneHelpfulEffect(@Nullable LivingEntity entity) {
        if (entity != null) {
            Collection effects = entity.func_70651_bq();
            if (effects.isEmpty()) {
                return false;
            }
            ArrayList<Effect> remove = null;
            for (EffectInstance effect : effects) {
                if (Potions.isEffectivelyBad(effect, entity, null)) continue;
                if (remove == null) {
                    remove = new ArrayList<Effect>();
                }
                remove.add(effect.func_188419_a());
            }
            if (remove != null) {
                Effect p;
                int i = 0;
                int M = Math.min(2, remove.size());
                do {
                    p = (Effect)remove.get(entity.func_70681_au().nextInt(remove.size()));
                    Potions.removePotionEffectUnconditionally(entity, p);
                } while (entity.func_70660_b(p) != null && ++i < M);
                return i < M;
            }
        }
        return false;
    }

    public static final boolean has(@Nonnull LivingEntity entity, @Nullable Effect primary, String effects_tag) {
        ITag<Potion> set = RID.getPotionTag(effects_tag);
        return Potions.has(entity, primary, set);
    }

    public static final boolean has(@Nonnull LivingEntity entity, @Nullable Effect primary, @Nullable ITag<Potion> effects_tag) {
        if (primary != null && entity.func_70644_a(primary)) {
            return true;
        }
        if (effects_tag != null && !effects_tag.func_230236_b_().isEmpty()) {
            for (Potion p : effects_tag.func_230236_b_()) {
                for (EffectInstance ei : p.func_185170_a()) {
                    Effect e = ei.func_188419_a();
                    if (!entity.func_70644_a(e)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final int getLevel(@Nonnull LivingEntity entity, @Nullable Effect effect) {
        return entity == null ? -1 : (entity.func_70644_a(effect) ? entity.func_70660_b(effect).func_76458_c() : -1);
    }

    public static final boolean cure(@Nonnull LivingEntity entity, @Nonnull ModIntegration mod, @Nonnull String effect_name) {
        boolean tried = false;
        Effect e = mod.potion(effect_name);
        if (e != null) {
            tried = Potions.removePotionEffectUnconditionally(entity, e);
        }
        return tried;
    }

    public static final boolean cure(@Nonnull LivingEntity entity, @Nonnull String effects_tag, boolean forced) {
        boolean tried = false;
        ITag<Potion> set = RID.getPotionTag(effects_tag);
        if (set != null) {
            tried = Potions.cure(entity, set, forced);
        }
        return tried;
    }

    public static final boolean cure(@Nonnull LivingEntity entity, @Nonnull ITag<Potion> effects_tag, boolean forced) {
        int tried = 0;
        if (effects_tag != null && !effects_tag.func_230236_b_().isEmpty()) {
            ArrayList<Effect> checked = new ArrayList<Effect>(4);
            for (Potion p : effects_tag.func_230236_b_()) {
                for (EffectInstance ei : p.func_185170_a()) {
                    Effect e = ei.func_188419_a();
                    if (checked.contains(e)) continue;
                    checked.add(e);
                    if (!Potions._removeEffect(entity, e, forced)) continue;
                    ++tried;
                }
            }
        }
        return tried > 0;
    }

    public static final boolean cureJumpFailImplEffect(@Nonnull LivingEntity entity, boolean forced) {
        boolean done = false;
        EffectInstance e = entity.func_70660_b(SharedGlue.Potion_jump);
        if (e != null && e.func_76458_c() < 0) {
            Potions._removeEffect(entity, SharedGlue.Potion_jump, forced);
            done = true;
        }
        return done;
    }

    public static final boolean cureSightImpairingEffects(@Nonnull LivingEntity entity, boolean forced) {
        int tried = 0;
        if (entity != null) {
            if (Potions.cure(entity, ModIntegration.FORBIDDEN_ARCANUS, "darkened")) {
                ++tried;
            }
            if (Potions.cure(entity, ModIntegration.CHARCOAL_PIT, "drunk")) {
                ++tried;
            }
            if (Potions._removeEffect(entity, SharedGlue.Potion_blindness, forced)) {
                ++tried;
            }
        }
        return tried > 0;
    }

    public static final void cureBadPotionEffectsWithHoney(@Nullable LivingEntity entity, boolean forced, boolean boosted) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_harm, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_poison, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_badLuck, forced);
            if (boosted) {
                Potions.cureJumpFailImplEffect(entity, forced);
                Potions.cureBadPotionEffectsWithMuscleBoost(entity, forced);
            }
        }
    }

    public static final void cureBadPotionEffectsWithHoneyBucket(@Nullable LivingEntity entity, boolean boosted) {
        Potions.cureBadPotionEffectsWithHoney(entity, true, boosted);
    }

    public static final void cureBadPotionEffectsWithMilk(@Nullable LivingEntity entity, boolean forced, boolean combatant, boolean muscle_boosted) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_harm, forced);
            Potions.cureSightImpairingEffects(entity, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_poison, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_badLuck, false);
            Potions.cureJumpFailImplEffect(entity, forced);
            if (combatant) {
                Potions._removeEffect(entity, SharedGlue.Potion_wither, forced);
                EffectInstance e = entity.func_70660_b(SharedGlue.Potion_resistance);
                if (e != null && e.func_76458_c() < 0) {
                    Potions._removeEffect(entity, SharedGlue.Potion_resistance, forced);
                }
            }
            if (muscle_boosted) {
                Potions.cureBadPotionEffectsWithMuscleBoost(entity, forced);
            }
        }
    }

    public static final void cureBadPotionEffectsWithMilkBucket(@Nullable LivingEntity entity) {
        if (entity != null) {
            Potions.cureAllBadEffects(entity, false);
            Potions.addPotionEffect(entity, SharedGlue.Potion_regeneration, 10, 2, false, false);
        }
    }

    public static final void cureBadPotionEffectsWithMuscleBoost(LivingEntity entity, boolean forced) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_weakness, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_moveSlowdown, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_digSlowdown, forced);
            Potions.cureJumpFailImplEffect(entity, forced);
            Potions.cure(entity, ModIntegration.SURVIVE, "tiredness");
            Potions.cure(entity, ModIntegration.SURVIVAL_OVERHAUL, "exhaustion");
            Potions.cure(entity, ModIntegration.CHARCOAL_PIT, "drunk");
        }
    }

    public static final void addMuscleBoostPotionEffect(LivingEntity entity, int duration_mins, int amplifier) {
        if (entity != null) {
            EffectInstance curr;
            if (duration_mins <= 0) {
                duration_mins = 3;
            }
            int duration = 60 * duration_mins;
            Effect muscle_boost = WellFedEffect.get_muscleboost();
            if (entity.func_70644_a(muscle_boost) && (curr = entity.func_70660_b(muscle_boost)).func_76458_c() >= amplifier) {
                StubbornPotionEffect temp = StubbornPotionEffect.from(curr);
                curr = temp.combineInternal(Potions.newPotionEffect(muscle_boost, SharedGlue.ticksFromSeconds(duration), amplifier, false, false));
                entity.func_195064_c(curr);
                return;
            }
            Potions.addPotionEffect(entity, muscle_boost, duration, amplifier, false, false);
        }
    }

    public static final void onMuscleFoodEaten(LivingEntity entity, int duration_mins, int amplifier) {
        CureProfiles.applyAll(entity, CureProfiles.FORCED, "muscle_boosted");
        Potions.addMuscleBoostPotionEffect(entity, duration_mins, amplifier);
    }

    public static final void cureBadPotionEffectsWithSmellingSalts(@Nullable LivingEntity entity) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions.cureSightImpairingEffects(entity, true);
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, true);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, true);
            Potions.cureJumpFailImplEffect(entity, true);
            Potions.cureBadPotionEffectsWithMuscleBoost(entity, true);
        }
    }

    public static final ItemStack newTippedArrow(Potion type) {
        ItemStack arrow = new ItemStack((IItemProvider)Items.field_185167_i);
        return PotionUtils.func_185188_a((ItemStack)arrow, (Potion)type);
    }

    public static final void cureChokingEffects(LivingEntity entity) {
        Potions.cure(entity, ModIntegration.GRAVESTONE_EXT, "gs_choke_potion");
    }

    public static final void cureThirstEffects(LivingEntity entity) {
        Potions.cure(entity, ModIntegration.SURVIVE, "thirst");
        Potions.cure(entity, ModIntegration.TOUGH_AS_NAILS, "thirst");
        Potions.cure(entity, ModIntegration.CHARCOAL_PIT, "drunk");
    }

    public static final void cureAntiNourishingEffects(LivingEntity entity) {
        Potions._removeEffect(entity, SharedGlue.Potion_hunger, false);
        Potions.cureThirstEffects(entity);
    }

    public static final void cureFatiguingEffects(LivingEntity entity) {
        Potions.cureAntiNourishingEffects(entity);
        Potions.cureBadPotionEffectsWithMuscleBoost(entity, false);
    }

    public static final void cureHyperthermiaEffects(@Nonnull LivingEntity entity) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions.cure(entity, ModIntegration.SURVIVE, "hyperthermia");
            Potions.cure(entity, ModIntegration.SURVIVAL_OVERHAUL, "heat_stroke");
            Potions.cure(entity, ModIntegration.PRIMAL, "sun_burn");
        }
    }

    public static final void cureExternalBurningEffects(@Nonnull LivingEntity entity, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions.cure(entity, ModIntegration.LYCANITES_MOBS, "smouldering");
        }
        if (immediate && entity.func_70027_ad()) {
            entity.func_70066_B();
            if (SharedGlue.isaPlayer((Entity)entity)) {
                Effects.playExtinguishedBurning(entity.func_130014_f_(), (PlayerEntity)entity);
            }
        }
    }

    public static final void cureAllBurningEffects(@Nonnull LivingEntity entity, boolean immediate) {
        Potions.cureHyperthermiaEffects(entity);
        Potions.cureExternalBurningEffects(entity, immediate);
    }

    public static final void cureHypothermiaEffects(@Nonnull LivingEntity entity) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions.cure(entity, ModIntegration.SURVIVE, "hypothermia");
            Potions.cure(entity, ModIntegration.SURVIVAL_OVERHAUL, "frostbite");
            Potions.cure(entity, ModIntegration.PRIMAL, "water_burn");
            Potions.cure(entity, ModIntegration.NETHER_EX, "frostbite");
        }
    }

    public static final void cureExternalFreezingEffects(@Nonnull LivingEntity entity, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions.cure(entity, ModIntegration.ELECTROBLOB_WIZARDRY, "frost");
            Potions.cure(entity, ModIntegration.NETHER_EX, "freeze");
            Potions.cure(entity, ModIntegration.SILENT_GEMS, "freezing");
            Potions.cure(entity, ModIntegration.CHAMPIONS, "paralysis");
            Potions.cure(entity, ModIntegration.LYCANITES_MOBS, "paralysis");
        }
    }

    public static final void cureAllFreezingEffects(@Nonnull LivingEntity entity, boolean immediate) {
        Potions.cureHypothermiaEffects(entity);
        Potions.cureExternalFreezingEffects(entity, immediate);
    }

    public static final void cureBleedingEffects(@Nonnull LivingEntity entity, boolean immediate) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions.cure(entity, ModIntegration.CHAMPIONS, "wound");
            Potions.cure(entity, ModIntegration.LYCANITES_MOBS, "bleed");
            if (ModIntegration.isPresent("bloodarsenal")) {
                // empty if block
            }
        }
    }

    public static final void cureMisfortuneEffects(@Nonnull LivingEntity entity, boolean forced) {
        if (SharedGlue.hasPotionsInEffect(entity)) {
            Potions._removeEffect(entity, SharedGlue.Potion_badLuck, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_badOmen, forced);
        }
    }

    public static final void cureBadPotionEffectsWithBirchsap(@Nullable LivingEntity entity, boolean forced) {
        if (entity != null) {
            Potions._removeEffect(entity, SharedGlue.Potion_nausea, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_poison, forced);
            Potions._removeEffect(entity, SharedGlue.Potion_hunger, forced);
        }
    }

    public static final boolean hasCustomElixirEffects(@Nonnull ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 9);
    }

    static final List<EffectInstance> mergeCustomElixirEffects(@Nonnull CompoundNBT from, @Nullable List<EffectInstance> effects) {
        if (effects == null) {
            effects = new ArrayList<EffectInstance>();
        }
        if (from.func_150297_b(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 9)) {
            ListNBT tagList = from.func_150295_c(_CUSTOM_ELIXIR_EFFECTS_TAGNAME, 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundNBT effectData = tagList.func_150305_b(i);
                ResourceLocation effectName = new ResourceLocation(effectData.func_74779_i("Effect"));
                Effect potion = (Effect)ForgeRegistries.POTIONS.getValue(effectName);
                if (potion == null) continue;
                int duration = effectData.func_74762_e("Duration");
                int amplifier = effectData.func_74762_e("Amplifier");
                if (duration <= 0 && (duration != 0 || !potion.func_76403_b())) continue;
                effects.add(new EffectInstance(potion, duration, amplifier));
            }
        }
        return effects;
    }

    public static final List<EffectInstance> getEffects(@Nonnull ItemStack stack, boolean any) {
        List effects = PotionUtils.func_185189_a((ItemStack)stack);
        if (any && Potions.hasCustomElixirEffects(stack)) {
            Potions.mergeCustomElixirEffects(stack.func_77978_p(), effects);
        }
        return effects;
    }

    public static final List<EffectInstance> getEffects(@Nonnull FluidStack stack) {
        List<Object> effects = Fluids.isPotion(stack.getFluid()) && stack.hasTag() ? PotionUtils.func_185185_a((CompoundNBT)stack.getTag()) : new ArrayList<EffectInstance>();
        return effects;
    }

    public static final boolean matches(@Nonnull ItemStack stack, Potion ingredient, boolean any) {
        if (Potions.isReal(ingredient)) {
            List<EffectInstance> have = Potions.getEffects(stack, any);
            List want = ingredient.func_185170_a();
            if (have.size() == want.size()) {
                if (want.size() == 1) {
                    return ((EffectInstance)want.get(0)).equals((Object)have.get(0));
                }
                for (EffectInstance e : want) {
                    if (have.contains(e)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static final void addCustomEffects(@Nonnull CompoundNBT to, boolean replace, @Nullable Collection<EffectInstance> effects) {
        if (replace) {
            to.func_82580_o(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME());
        }
        if (effects != null && !effects.isEmpty()) {
            ListNBT eList = to.func_150295_c(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), 10);
            for (EffectInstance effect : effects) {
                eList.add((Object)effect.func_82719_a(new CompoundNBT()));
            }
            to.func_218657_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), (INBT)eList);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final void trackAttributeModifiers(EffectInstance effect, List<Tuple<String, AttributeModifier>> local_copies) {
        Effect potion = effect.func_188419_a();
        Map map = potion.func_111186_k();
        if (!map.isEmpty()) {
            for (Map.Entry iattrib : map.entrySet()) {
                AttributeModifier modifier = (AttributeModifier)iattrib.getValue();
                AttributeModifier local_copy = new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), modifier), modifier.func_220375_c());
                local_copies.add((Tuple<String, AttributeModifier>)new Tuple((Object)((Attribute)iattrib.getKey()).func_233754_c_(), (Object)local_copy));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final void addModifierInformation(List<Tuple<String, AttributeModifier>> attribs, List<ITextComponent> tooltip) {
        tooltip.add((ITextComponent)Tooltips.NL());
        tooltip.add((ITextComponent)new TranslationTextComponent("potion.whenDrank").func_240699_a_(TextFormatting.DARK_PURPLE));
        for (Tuple<String, AttributeModifier> tuple : attribs) {
            AttributeModifier modifier = (AttributeModifier)tuple.func_76340_b();
            double amount = modifier.func_111164_d();
            int op = modifier.func_220375_c().func_220371_a();
            double value = op != SharedGlue.OP_MUL_BASE_ATTR && op != SharedGlue.OP_MUL_TOTAL_ATTR ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
            if (amount > 0.0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.plus." + op, new Object[]{ItemStack.field_111284_a.format(value), new TranslationTextComponent("" + (String)tuple.func_76341_a())}).func_240699_a_(TextFormatting.BLUE));
                continue;
            }
            if (!(amount < 0.0)) continue;
            tooltip.add((ITextComponent)new TranslationTextComponent("attribute.modifier.take." + op, new Object[]{ItemStack.field_111284_a.format(value *= -1.0), new TranslationTextComponent("" + (String)tuple.func_76341_a())}).func_240699_a_(TextFormatting.RED));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<EffectInstance> effects, @Nonnull List<ITextComponent> tooltip, int durationOverride, boolean full, boolean indent) {
        String _PS;
        ArrayList<Tuple<String, AttributeModifier>> attribs = null;
        String string = _PS = indent ? " " : "";
        if (full) {
            if (effects.isEmpty()) {
                IFormattableTextComponent displayString = new StringTextComponent(_PS).func_230529_a_((ITextComponent)new TranslationTextComponent("effect.none").func_240699_a_(TextFormatting.GRAY));
                tooltip.add((ITextComponent)displayString);
                return;
            }
            attribs = new ArrayList<Tuple<String, AttributeModifier>>();
        }
        for (EffectInstance effect : effects) {
            if (full) {
                Potions.trackAttributeModifiers(effect, attribs);
            }
            boolean bad = Potions.isEffectivelyBad(effect);
            IFormattableTextComponent displayString = new StringTextComponent(_PS).func_230529_a_((ITextComponent)new TranslationTextComponent(effect.func_76453_d()));
            if (effect.func_76458_c() != 0) {
                displayString = displayString.func_230529_a_((ITextComponent)Tooltips.SP1()).func_230529_a_((ITextComponent)new TranslationTextComponent("potion.potency." + Math.abs(effect.func_76458_c())));
            }
            if (effect.func_76459_b() > SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER()) {
                if (durationOverride > 0) {
                    effect = new EffectInstance(effect.func_188419_a(), durationOverride);
                }
                String durationstring = " (" + EffectUtils.func_188410_a((EffectInstance)effect, (float)1.0f) + ")";
                displayString = displayString.func_230529_a_((ITextComponent)new StringTextComponent(durationstring));
            }
            tooltip.add((ITextComponent)displayString.func_240699_a_(bad ? TextFormatting.RED : TextFormatting.BLUE));
        }
        if (full && attribs != null && !attribs.isEmpty()) {
            Potions.addModifierInformation(attribs, tooltip);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<EffectInstance> effects, @Nonnull List<ITextComponent> tooltip) {
        Potions.addPotionInformation(effects, tooltip, -1, false, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addPotionInformation(@Nonnull Collection<EffectInstance> effects, @Nonnull List<ITextComponent> tooltip, boolean full) {
        Potions.addPotionInformation(effects, tooltip, -1, full, false);
    }

    private static final boolean isdefined(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return false;
        }
        Potion type = PotionUtils.func_185187_c((CompoundNBT)stack.func_77978_p());
        return type != null && type != SharedGlue.PotionType_empty || stack.func_77978_p().func_150297_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), 9) || Potions.hasCustomElixirEffects(stack);
    }

    public static final boolean isa(@Nullable ItemStack stack, boolean any) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item != Items.field_151068_bn && !any) {
                item = null;
            }
            is = item != null && Potions.isdefined(stack);
        }
        return is;
    }

    public static final boolean isap(@Nullable ItemStack stack, boolean any) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (!(item == Items.field_151068_bn || item == Items.field_185155_bH || item == Items.field_185156_bI || any && RID.matches(stack, "carrots:potion_bottles"))) {
                item = null;
            }
            is = item != null && Potions.isdefined(stack);
        }
        return is;
    }

    public static final boolean isad(@Nullable ItemStack stack, @Nullable ObjRef<FluidStack> result) {
        boolean is = false;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item != Items.field_151068_bn && !RID.matches(stack, "carrots:potion_bottles")) {
                FluidStack fstack = Fluids.getGenericFluid(stack);
                boolean bl = is = !fstack.isEmpty() && Fluids.isPotion(fstack.getFluid());
                if (is && result != null) {
                    result.set(fstack);
                }
            } else {
                is = Potions.isdefined(stack);
            }
        }
        return is;
    }

    public static final boolean isIn(@Nonnull Effect source, @Nullable Effect primary, String effects_tag) {
        ITag<Potion> set = RID.getPotionTag(effects_tag);
        return Potions.isIn(source, primary, set);
    }

    public static final boolean isIn(@Nonnull Effect source, @Nullable Effect primary, @Nonnull ITag<Potion> effects_tag) {
        if (primary != null && source == primary) {
            return true;
        }
        if (effects_tag != null) {
            for (Potion p : effects_tag.func_230236_b_()) {
                for (EffectInstance ei : p.func_185170_a()) {
                    if (ei.func_188419_a() != source) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static final void sendRemoveEffectImmediately(@Nonnull LivingEntity carrier, @Nonnull Effect p) {
        if (p != null && SharedGlue.isaServerWorld((Entity)carrier)) {
            Potions.updateSideEffect(carrier, new SRemoveEntityEffectPacket(carrier.func_145782_y(), p));
            Set all_attribs = carrier.func_233645_dx_().func_233778_a_();
            if (!all_attribs.isEmpty()) {
                Potions.updateSideEffect(carrier, new SEntityPropertiesPacket(carrier.func_145782_y(), (Collection)all_attribs));
            }
        }
    }

    public static final void sendUpdateEffectImmediately(@Nonnull LivingEntity carrier, @Nonnull Effect p) {
        if (p != null && SharedGlue.isaServerWorld((Entity)carrier)) {
            Potions.updateSideEffect(carrier, new SPlayEntityEffectPacket(carrier.func_145782_y(), carrier.func_70660_b(p)));
            Set all_attribs = carrier.func_233645_dx_().func_233778_a_();
            if (!all_attribs.isEmpty()) {
                Potions.updateSideEffect(carrier, new SEntityPropertiesPacket(carrier.func_145782_y(), (Collection)all_attribs));
            }
        }
    }

    private static final void updateSideEffect(LivingEntity carrier, IPacket<?> packet) {
        ((ServerWorld)carrier.func_130014_f_()).func_72863_F().func_217218_b((Entity)carrier, packet);
    }

    public static final void eraseDefinition(CompoundNBT from) {
        if (from != null) {
            from.func_82580_o("Potion");
            from.func_82580_o(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME());
            from.func_82580_o(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME());
        }
    }

    public static final void eraseDefinition(ItemStack stack) {
        if (!ItemStacks.isEmpty(stack) && stack.func_77942_o()) {
            Potions.eraseDefinition(stack.func_77978_p());
        }
    }

    public static final boolean copyDefinition(CompoundNBT from, @Nonnull CompoundNBT to) {
        boolean copied = false;
        if (from != null && to != null) {
            int tagcount = 0;
            Potions.eraseDefinition(to);
            CompoundNBT data = from;
            if (data.func_74764_b("Potion")) {
                to.func_218657_a("Potion", data.func_74781_a("Potion").func_74737_b());
                ++tagcount;
            }
            if (data.func_74764_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME())) {
                to.func_218657_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME()).func_74737_b());
                ++tagcount;
            }
            boolean bl = copied = tagcount > 0;
            if (copied && data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
                to.func_218657_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME()).func_74737_b());
            }
        }
        return copied;
    }

    public static final boolean copyDefinition(ItemStack from, @Nonnull ItemStack to) {
        boolean copied = false;
        if (Potions.isa(from, true)) {
            int color;
            Potions.eraseDefinition(to);
            CompoundNBT data = from.func_77978_p();
            boolean is_registered = data.func_74764_b("Potion");
            if (is_registered) {
                to.func_77983_a("Potion", data.func_74781_a("Potion").func_74737_b());
            }
            if (data.func_74764_b(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME())) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_EFFECTS_TAGNAME()).func_74737_b());
            }
            if (data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), data.func_74781_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME()).func_74737_b());
            } else if (!is_registered && to.func_77973_b() instanceof TippedArrowItem && (color = PotionUtils.func_185181_a(Potions.getEffects(from, false))) != 3694022) {
                to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (INBT)IntNBT.func_229692_a_((int)color));
            }
            copied = true;
        }
        return copied;
    }

    public static final void copyDefinition(@Nonnull ItemStack to, @Nonnull Collection<EffectInstance> effects, @Nullable Integer customColor) {
        Potions.eraseDefinition(to);
        Potions.addCustomEffects(ItemStacks.getOrCreateData(to), false, effects);
        if (customColor != null) {
            to.func_77983_a(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), (INBT)IntNBT.func_229692_a_((int)customColor));
        }
    }

    public static final boolean isReal(@Nullable Potion type) {
        return type == null ? false : type != SharedGlue.PotionType_empty && type != SharedGlue.PotionType_water && type != SharedGlue.PotionType_harmless && !type.func_185170_a().isEmpty();
    }

    @Nullable
    private static final String getCustomUnlocalizedName(ItemStack stack) {
        String name = null;
        if (ItemStacks.hasData(stack, SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME(), 8)) {
            name = ItemStacks.getString(stack, SharedGlue.CUSTOM_POTION_UNLOCALIZED_TAGNAME());
        }
        return name;
    }

    @Nullable
    public static final ITextComponent getTypeDisplayNameOrNull(@Nonnull ItemStack stack) {
        IFormattableTextComponent displayName = null;
        String name = Potions.getCustomUnlocalizedName(stack);
        if (name != null) {
            displayName = new TranslationTextComponent(name).func_230529_a_((ITextComponent)new StringTextComponent("*"));
        } else {
            Potion type = PotionUtils.func_185191_c((ItemStack)stack);
            if (Potions.isReal(type)) {
                displayName = new TranslationTextComponent(type.func_185174_b(_DEFAULT_MINECRAFT_PREFIX));
            }
        }
        return displayName;
    }

    @Nullable
    public static final String getTypeTranslationKeyOrNull(@Nonnull ItemStack stack, String prefix) {
        String lookup = null;
        Potion type = PotionUtils.func_185191_c((ItemStack)stack);
        if (type == SharedGlue.PotionType_empty) {
            lookup = Potions.getCustomUnlocalizedName(stack);
        } else if (Potions.isReal(type)) {
            if (prefix == null) {
                prefix = "";
            }
            if (!Strings.hasTranslation(lookup = type.func_185174_b(prefix))) {
                lookup = null;
            }
        }
        return lookup;
    }

    @Nullable
    public static final Integer getColorOrNull(ItemStack stack, @Nonnull Collection<EffectInstance> effects) {
        CompoundNBT data;
        Integer color_num = null;
        if (ItemStacks.hasData(stack) && (data = stack.func_77978_p()).func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99)) {
            color_num = data.func_74762_e(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME());
        }
        if (color_num == null && !effects.isEmpty()) {
            color_num = PotionUtils.func_185181_a(effects);
        }
        return color_num;
    }

    @Nullable
    public static final Integer getColorOrNull(ItemStack stack) {
        Integer color_num = null;
        if (ItemStacks.hasData(stack)) {
            CompoundNBT data = stack.func_77978_p();
            color_num = data.func_150297_b(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME(), 99) ? Integer.valueOf(data.func_74762_e(SharedGlue.CUSTOM_POTION_COLOR_TAGNAME())) : Integer.valueOf(PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)stack)));
        }
        return color_num;
    }

    public static final int getColor(@Nullable Potion potion) {
        return PotionUtils.func_185183_a((Potion)(potion == null ? SharedGlue.PotionType_harmless : potion));
    }

    static final void initAmendmentSupport() {
        int successes = 0;
        try {
            Method m = LivingEntity.class.getDeclaredMethod(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_70688_c"), EffectInstance.class);
            m.setAccessible(true);
            _ON_FINISHED_POTION_EFFECT = m;
            ++successes;
            LibInfo.LOG.info("Potion effect neutralizer hook initialized successfully!");
        }
        catch (Throwable igX) {
            LibInfo.LOG.warn("Unable to initialize potion effect neutralizer hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
        try {
            _FOOD_POTION_EFFECTS = ObfuscationReflectionHelper.findField(Food.class, (String)"field_221475_f");
            ++successes;
        }
        catch (Throwable igX) {
            LibInfo.LOG.warn("Unable to obtain potion effects list hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
        }
        LibInfo.LOG.debug("carrots/lib Potion tweaks completed [{},{}]", (Object)(successes == 2 ? "P" : "F"), (Object)successes);
    }

    static final void initFinalize() {
        if (LibConfig.allowUncurablePotionEffects()) {
            MinecraftForge.EVENT_BUS.register((Object)new EventsListener());
        }
    }

    static final void onFinishedPotionEffect(@Nonnull LivingEntity entity, EffectInstance effect) {
        if (_ON_FINISHED_POTION_EFFECT != null && entity.field_70170_p != null) {
            try {
                _ON_FINISHED_POTION_EFFECT.invoke((Object)entity, effect);
            }
            catch (Throwable igX) {
                LibInfo.LOG.warn("Unable to notify potion effect {} finished for entity {}", (Object)effect.func_76453_d(), (Object)entity.func_189512_bd());
            }
        }
    }

    @Nullable
    private static final List<Pair<Supplier<EffectInstance>, Float>> effectsFor(Food food) {
        if (_FOOD_POTION_EFFECTS != null) {
            try {
                return (List)List.class.cast(_FOOD_POTION_EFFECTS.get(food));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    protected Potions() {
    }

    public static interface IPlacebo {
    }

    @ParametersAreNonnullByDefault
    public static final class CureProfiles {
        private static final CureProfile _DO_NUTHIN = (e, c) -> {};
        private static final Map<String, CureProfile> _profiles = new ConcurrentHashMap<String, CureProfile>(23);
        private static final List<String> _milk_like = new Vector<String>();
        public static final Map<String, Boolean> FORCED;
        public static final Map<String, Boolean> DATA_DRIVEN;
        public static final Map<String, Boolean> CURATIVE;
        public static final Map<String, Boolean> UNCONDITIONALLY;
        public static final Map<String, Boolean> BY_BUCKET;

        private static final boolean bool(Map<String, Boolean> c, String k, boolean dB) {
            return c.getOrDefault(k, dB);
        }

        private static final boolean bool(Map<String, Boolean> c, String k) {
            return c.getOrDefault(k, false);
        }

        public static final boolean immediate(Map<String, Boolean> c) {
            return CureProfiles.bool(c, "immediate", true);
        }

        public static final boolean forced(Map<String, Boolean> c) {
            return CureProfiles.bool(c, "forced", false);
        }

        public static final boolean check_tag(Map<String, Boolean> c) {
            return CureProfiles.bool(c, "tag", false);
        }

        public static final boolean neutral_bad(Map<String, Boolean> c) {
            return CureProfiles.bool(c, "neutral_bad", LibConfig.neutralPotionsEffectivelyBad());
        }

        public static final boolean __cure(LivingEntity e, Map<String, Boolean> args, String tag) {
            return CureProfiles.check_tag(args) && Potions.cure(e, tag, CureProfiles.forced(args));
        }

        public static final boolean has(String profile_id) {
            return profile_id != null && _profiles.containsKey(profile_id);
        }

        @Nonnull
        public static final CureProfile noOp() {
            return _DO_NUTHIN;
        }

        @Nonnull
        public static final CureProfile get(String profile_id) {
            return _profiles.getOrDefault(profile_id, CureProfiles.noOp());
        }

        public static final void applyAll(LivingEntity to, Map<String, Boolean> args, String ... profile_ids) {
            for (String profile_id : profile_ids) {
                CureProfiles.get(profile_id).accept(to, args);
            }
        }

        public static final void applyForAll(LivingEntity to, String ... profile_ids) {
            CureProfiles.applyAll(to, Collections.EMPTY_MAP, profile_ids);
        }

        public static final void applyFor(String profile_id, LivingEntity to) {
            CureProfiles.applyAll(to, Collections.EMPTY_MAP, profile_id);
        }

        public static final boolean applyForAllIn(LivingEntity to, Map<String, Boolean> args, ITag<Potion> tag) {
            return tag != null && Potions.cure(to, tag, CureProfiles.forced(args));
        }

        public static final void applyForBurning(LivingEntity to) {
            CureProfiles.applyFor("burning", to);
        }

        public static final void applyForMilk(LivingEntity to) {
            CureProfiles.applyFor("milk", to);
        }

        public static final void applyForMilk(LivingEntity to, Map<String, Boolean> args) {
            CureProfiles.applyAll(to, args, "milk+");
        }

        public static final void applyForHoney(LivingEntity to) {
            CureProfiles.applyFor("honey", to);
        }

        public static final void applyForHoney(LivingEntity to, Map<String, Boolean> args) {
            CureProfiles.applyAll(to, args, "honey");
        }

        public static final void applyForPoison(LivingEntity to) {
            CureProfiles.applyAll(to, CURATIVE, "poison");
        }

        private static final boolean isImmutable(String profile_id) {
            return "".equals(profile_id) || "NONE".equals(profile_id) || "minecraft_milk".equals(profile_id) || "void_milk".equals(profile_id) || "all_bad".equals(profile_id);
        }

        public static final void register(String profile_id, CureProfile impl, boolean andIfFound, boolean milk_like) {
            CureProfile inserted;
            if (!CureProfiles.isImmutable(profile_id) && (inserted = _profiles.merge(profile_id, impl, (old_profile, incoming_profile) -> andIfFound ? (CureProfile)old_profile.andThen(incoming_profile) : old_profile)) == impl && milk_like) {
                _milk_like.add(profile_id);
            }
        }

        public static final void register(String profile_id, CureProfile impl) {
            CureProfiles.register(profile_id, impl, false, false);
        }

        public static final boolean isLikeMilk(String profile_id) {
            return profile_id != null && _milk_like.contains(profile_id);
        }

        public static final Map<String, Boolean> newopts(Consumer<Map<String, Boolean>> initializer) {
            HashMap opts = new HashMap(11);
            initializer.accept(opts);
            return Collections.unmodifiableMap(opts);
        }

        static {
            _profiles.put("", (e, c) -> {});
            _profiles.put("NONE", _profiles.get(""));
            _profiles.put("minecraft_milk", (e, c) -> Potions.removeAllEffects(e));
            _profiles.put("cursed_minecraft_milk", (e, c) -> Potions.removeAllHelpfulEffects(e, true));
            _profiles.put("void_milk", (e, c) -> Potions.scrubAllEffects(e, SharedGlue.isaServerWorld((Entity)e)));
            _profiles.put("all_bad", (e, c) -> Potions.cureAllBadEffects(e, CureProfiles.neutral_bad(c)));
            _profiles.put("hunger", (e, c) -> {
                Potions.removePotionEffectUnconditionally(e, SharedGlue.Potion_hunger);
                CureProfiles.__cure(e, c, "hunger");
            });
            _profiles.put("poison", (e, c) -> {
                Potions.removePotionEffectUnconditionally(e, SharedGlue.Potion_poison);
                CureProfiles.__cure(e, c, "poisons");
            });
            _profiles.put("blindness", (e, c) -> {
                Potions.cureSightImpairingEffects(e, true);
                CureProfiles.__cure(e, c, "blindness");
            });
            _profiles.put("fatigue", (e, c) -> {
                Potions.cureFatiguingEffects(e);
                CureProfiles.__cure(e, c, "fatigue");
            });
            _profiles.put("thirst", (e, c) -> {
                Potions.cureThirstEffects(e);
                CureProfiles.__cure(e, c, "dehydration");
            });
            _profiles.put("dehydration", (e, c) -> CureProfiles.__cure(e, c, "dehydration"));
            _profiles.put("smelling_salts", (e, c) -> Potions.cureBadPotionEffectsWithSmellingSalts(e));
            _profiles.put("milk", (e, c) -> Potions.cureBadPotionEffectsWithMilk(e, false, false, false));
            _profiles.put("milk+", (e, c) -> {
                boolean boosted = CureProfiles.bool(c, "boosted");
                Potions.cureBadPotionEffectsWithMilk(e, CureProfiles.forced(c), CureProfiles.bool(c, "combatant"), boosted);
                if (boosted) {
                    CureProfiles.__cure(e, c, "fatigue");
                }
            });
            _profiles.put("milk_bucket", (e, c) -> Potions.cureBadPotionEffectsWithMilkBucket(e));
            _profiles.put("birchsap_bucket", (e, c) -> {
                boolean boosted = CureProfiles.bool(c, "boosted");
                Potions.cureBadPotionEffectsWithBirchsap(e, CureProfiles.forced(c));
                CureProfiles.__cure(e, c, "hunger");
                if (boosted) {
                    CureProfiles.__cure(e, c, "poisons");
                }
            });
            _profiles.put("honey", (e, c) -> Potions.cureBadPotionEffectsWithHoney(e, CureProfiles.forced(c), CureProfiles.bool(c, "boosted")));
            _profiles.put("honey_bucket", (e, c) -> Potions.cureBadPotionEffectsWithHoneyBucket(e, CureProfiles.bool(c, "boosted")));
            _profiles.put("muscle_boosted", (e, c) -> {
                Potions.cureBadPotionEffectsWithMuscleBoost(e, CureProfiles.forced(c));
                CureProfiles.__cure(e, c, "fatigue");
            });
            _profiles.put("choking", (e, c) -> {
                Potions.cureChokingEffects(e);
                CureProfiles.__cure(e, c, "choking");
            });
            _profiles.put("hyperthermia", (e, c) -> Potions.cureHyperthermiaEffects(e));
            _profiles.put("hypothermia", (e, c) -> Potions.cureHypothermiaEffects(e));
            _profiles.put("burning", (e, c) -> {
                Potions.cureExternalBurningEffects(e, CureProfiles.immediate(c));
                CureProfiles.__cure(e, c, "burning");
            });
            _profiles.put("all_burning", (e, c) -> {
                Potions.cureAllBurningEffects(e, CureProfiles.immediate(c));
                CureProfiles.__cure(e, c, "burning");
            });
            _profiles.put("freezing", (e, c) -> {
                Potions.cureExternalFreezingEffects(e, CureProfiles.immediate(c));
                CureProfiles.__cure(e, c, "freezing");
            });
            _profiles.put("all_freezing", (e, c) -> {
                Potions.cureAllFreezingEffects(e, CureProfiles.immediate(c));
                CureProfiles.__cure(e, c, "freezing");
            });
            _profiles.put("bleeding", (e, c) -> {
                Potions.cureBleedingEffects(e, CureProfiles.immediate(c));
                CureProfiles.__cure(e, c, "bleeding");
            });
            _profiles.put("misfortune", (e, c) -> {
                Potions.cureMisfortuneEffects(e, CureProfiles.forced(c));
                CureProfiles.__cure(e, c, "misfortune");
            });
            _milk_like.add("minecraft_milk");
            _milk_like.add("void_milk");
            _milk_like.add("milk");
            _milk_like.add("milk+");
            _milk_like.add("milk_bucket");
            _milk_like.add("moilk");
            FORCED = Collections.singletonMap("forced", true);
            DATA_DRIVEN = Collections.singletonMap("tag", true);
            CURATIVE = Collections.unmodifiableMap((Map)Util.func_200696_a(new HashMap(), m -> {
                m.put("forced", true);
                m.put("tag", true);
            }));
            UNCONDITIONALLY = Collections.unmodifiableMap((Map)Util.func_200696_a(new HashMap(), m -> {
                m.put("forced", true);
                m.put("tag", true);
                m.put("neutral_bad", true);
            }));
            BY_BUCKET = Collections.unmodifiableMap((Map)Util.func_200696_a(new HashMap(), m -> {
                m.put("forced", true);
                m.put("boosted", true);
            }));
        }
    }

    public static final class EventsListener {
        EventsListener() {
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public final void onTryRemoveStubbornPotion(PotionEvent.PotionRemoveEvent event) {
            StubbornPotionEffect.onTryRemove(event);
        }
    }

    @FunctionalInterface
    public static interface CureProfile
    extends BiConsumer<LivingEntity, Map<String, Boolean>> {
    }
}

