/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.item.minecart.TNTMinecartEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.player.PlayerAbilities;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.OpEntry;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.GriefingType;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.NPE;
import org.jwaresoftware.mcmods.lib.OldNames;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.Villagers;
import org.jwaresoftware.mcmods.lib.api.IBlockItem;
import org.jwaresoftware.mcmods.lib.integration.BaublesHelper;

public final class SharedGlue
extends OldNames {
    public static final int MAX_STRING_BUFLEN = Short.MAX_VALUE;
    public static final String MINECRAFT_DOMAIN = "minecraft";
    public static final String MINECRAFT_DOMAIN_PREFIX = "minecraft:";
    public static final String FORGE_DOMAIN = "forge";
    public static final String FORGE_DOMAIN_PREFIX = "forge:";
    public static final String DATASET_DOMAIN = "dataset";
    public static final String ALL_DOMAINS = "_all_";
    public static final BlockPos NOWHERE = new BlockPos(-1, -1, -1);
    public static final int DIMENSION_SURFACE = 0;
    public static final int DIMENSION_NETHER = -1;
    public static final int DIMENSION_END = 1;
    public static final ToolType PICKAXE = ToolType.PICKAXE;
    public static final ToolType AXE = ToolType.AXE;
    public static final ToolType SHOVEL = ToolType.SHOVEL;
    public static final ToolType HOE = ToolType.HOE;
    public static final ToolType SHEARS = ToolType.get((String)SharedGlue.SHEARS_TOOLNAME());
    public static final ToolType SICKLE = ToolType.get((String)SharedGlue.SICKLE_TOOLNAME());
    public static final ToolType HAMMER = ToolType.get((String)SharedGlue.HAMMER_TOOLNAME());
    public static final ToolType CRACKHAMMER = ToolType.get((String)SharedGlue.CRACKHAMMER_TOOLNAME());
    public static final ToolType CLUB = ToolType.get((String)SharedGlue.CLUB_TOOLNAME());
    public static final ToolType MACHETE = ToolType.get((String)SharedGlue.MACHETE_TOOLNAME());
    public static final ToolType PAXEL = ToolType.get((String)SharedGlue.PAXEL_TOOLNAME());
    public static final ToolType KNIFE = ToolType.get((String)SharedGlue.KNIFE_TOOLNAME());
    private static final VoxelShape __SOUL_SAND_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    public static final String NBT_INSTRUCTIONS = "carrots:root";
    public static final String NBT_LEGACY_INSTRUCTIONS = "_Hord_Instructions";
    public static final String NBT_VERSION = "Version";
    public static final String NBT_MOD_ID = "ModId";
    public static final String NBT_GENERIC_UITIP = "UiTip";
    public static final String NBT_ADVANCED_UITIP = "AdvancedUiTip";
    public static final String NBT_X_ENCHANT = "PrizeEnchant";
    public static final String NBT_X_ENCHANT_MAX = "MaxPrizeEnchant";
    public static final String NBT_X_GEAR_FLAG = "XGear";
    public static final String NBT_ORIGIN = "Origin";
    public static final String NBT_X_FOOD_FLAG = "XFood";
    public static final String NBT_USED = "Used";
    public static final String NBT_CAPACITY = "Capacity";
    public static final String NBT_COLOR_RGB = "ColorRGB";
    public static final String NBT_OWNERID = "OwnerUUID";
    public static final String NBT_OWNERNAME = "OwnerName";
    public static final String NBT_SEALED = "Sealed";
    public static final String NBT_UNBREAKABLE = "Unbreakable";
    public static final String NBT_UNREPAIRABLE = "Unrepairable";
    public static final String NBT_LOOTED_FLAG = "Looted";
    public static final String NBT_CRAFTED_FLAG = "Crafted";
    public static final String NBT_UNVANISHING_FLAG = "Unvanishing";
    public static final String NBT_VANISHING_FLAG = "Vanishing";
    public static final String NBT_CHAOS = "CHAOS";
    public static final String NBT_SAMPLE_FLAG = "SAMPLE";
    public static final String NBT_STATS_PROFILE_NAME = "StatsProfile";
    public static final String NBT_SKIN = "Skin";
    public static final String NBT_TOGGLE_STATE = "Toggled";
    public static final String NBT_BARTERTOKEN_MOD_ID = "barter:modid";
    public static final String NBT_JSON_LOOTTABLE = "withLoot";
    public static final String NBT_JSON_COLOR_RGB = "withColor";
    public static final String NBT_JSON_SKIN = "withSkin";
    public static final String NBT_JSON_QGRADE = "withQuality";
    public static final int OP_ADD_ATTR = AttributeModifier.Operation.ADDITION.func_220371_a();
    public static final int OP_MUL_BASE_ATTR = AttributeModifier.Operation.MULTIPLY_BASE.func_220371_a();
    public static final int OP_MUL_TOTAL_ATTR = AttributeModifier.Operation.MULTIPLY_TOTAL.func_220371_a();
    public static final Predicate<Entity> NON_SPECTATING_LIVING = EntityPredicates.field_180132_d.and(e -> e instanceof LivingEntity);
    public static final com.google.common.base.Predicate<Entity> IS_BREATHING_PLAYER = new com.google.common.base.Predicate<Entity>(){

        public boolean apply(Entity e) {
            return SharedGlue.isaRealNonSpectatingPlayer(e) && e.func_70089_S();
        }
    };

    public static final boolean isDefined(Item item) {
        return item != null && item != Items.field_190931_a;
    }

    public static final boolean isDefined(ItemStack stack) {
        return !ItemStacks.isEmpty(stack);
    }

    public static final boolean isDefined(Block blok) {
        return blok != null && blok != Blocks.field_150350_a;
    }

    public static final boolean isDefined(BlockState blok) {
        return blok != null && SharedGlue.isDefined(blok.func_177230_c());
    }

    public static final boolean isDefined(BlockXyz context) {
        return context != null && context.isDefined();
    }

    public static final boolean isDefinedPlaceable(Block blok) {
        return blok != null && blok != Blocks.field_150350_a && blok != Blocks.field_201941_jj && blok != Blocks.field_201940_ji;
    }

    public static final BlockState AIR() {
        return Blocks.field_150350_a.func_176223_P();
    }

    public static final boolean isSame(Block test, Block original) {
        return test == original || test == original.delegate.get();
    }

    public static final int CHUNK_DIM() {
        return 16;
    }

    public static final int WORLD_HEIGHT() {
        return 256;
    }

    public static final int DEFAULT_TICKS_PER_FULL_DAYNIGHT_CYCLE() {
        return 24000;
    }

    public static final int DEFAULT_TICKS_TWILIGHT_TIME() {
        return 1000;
    }

    public static final int DEFAULT_TICKS_DAY_TIME() {
        return 14000;
    }

    public static final int DEFAULT_TICKS_NIGHT_TIME() {
        return SharedGlue.DEFAULT_TICKS_PER_FULL_DAYNIGHT_CYCLE() - SharedGlue.DEFAULT_TICKS_DAY_TIME();
    }

    public static final int SECS_TO_TICKS_DURATION_MULTIPLIER() {
        return 20;
    }

    public static final int SECS_TO_TICKS_MULTIPLIER() {
        return SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    }

    public static final int HALF_SECS_TO_TICKS_DURATION_MULTIPLIER() {
        return 10;
    }

    public static final int ticksFromMinutes(int mins) {
        return mins * 60 * SharedGlue.SECS_TO_TICKS_MULTIPLIER();
    }

    public static final int ticksFromSeconds(int secs) {
        return secs * SharedGlue.SECS_TO_TICKS_MULTIPLIER();
    }

    public static final int ticksToSeconds(int ticks) {
        return ticks / SharedGlue.SECS_TO_TICKS_MULTIPLIER();
    }

    public static final boolean isDayNightCycleEnabled(World w) {
        return w != null && w.func_82736_K().func_223586_b(SharedGlue.GAMERULE_DAYLIGHT_CYCLE());
    }

    public static final long tickingTime(World w) {
        return SharedGlue.isDayNightCycleEnabled(w) ? w.func_72820_D() : (w == null ? 0L : w.func_82737_E());
    }

    public static final int PLAYER_CRAFT_GRID_SIZE() {
        return 4;
    }

    public static final int PLAYER_CRAFT_GRID_SIDE() {
        return 2;
    }

    public static final int PLAYER_HOTBAR_SIZE() {
        return 9;
    }

    public static final int TABLE_CRAFT_GRID_SIZE() {
        return 9;
    }

    public static final int TABLE_CRAFT_GRID_SIDE() {
        return 3;
    }

    public static final int VANILLA_MAX_STACK_SIZE() {
        return 64;
    }

    public static final int MAX_STACK_SIZE(int default_max) {
        int n = SharedGlue.VANILLA_MAX_STACK_SIZE();
        if (default_max > n) {
            n = default_max;
        }
        return n;
    }

    public static final int MAX_STACK_SIZE() {
        return SharedGlue.MAX_STACK_SIZE(-1);
    }

    public static final int PINNED_MAX_STACK_SIZE(int default_max, float max_minecraft_stacks) {
        int limit;
        int count = SharedGlue.MAX_STACK_SIZE(default_max);
        if (count > (limit = (int)(64.0f * max_minecraft_stacks))) {
            count = limit;
        }
        return count;
    }

    public static final int OVERMAX_STACK_SIZE() {
        return SharedGlue.PINNED_MAX_STACK_SIZE(96, 1.5f);
    }

    public static final int AMMO_STANDARD_MAX_STACK_SIZE() {
        return SharedGlue.PINNED_MAX_STACK_SIZE(-1, 16.0f);
    }

    public static final int AMMO_OVER_MAX_STACK_SIZE() {
        return SharedGlue.PINNED_MAX_STACK_SIZE(96, 16.0f);
    }

    public static final int REDUCED_STACK_SIZE() {
        int n = SharedGlue.MAX_STACK_SIZE(-1);
        return n >= 256 ? 64 : 16;
    }

    public static final int SINGLE_CHEST_SIZE() {
        return 27;
    }

    public static final int DOUBLE_CHEST_SIZE() {
        return 54;
    }

    public static final int VILLAGER_INVENTORY_SIZE() {
        return 8;
    }

    public static final int MAX_LEVEL_CAULDRON() {
        return 3;
    }

    public static final int MAX_LIGHT_LEVEL() {
        return 15;
    }

    public static final int MIN_CROPS_SPAWN_LIGHT() {
        return 9;
    }

    public static final int MAX_MOB_SPAWN_LIGHT_LEVEL() {
        return 7;
    }

    public static final int DEFAULT_CROPS_MATURE_AGE() {
        return 7;
    }

    public static final int DEFAULT_FAST_CROPS_MATURE_AGE() {
        return 3;
    }

    public static final int DEFAULT_MULTISECTION_CROPS_MATURE_AGE() {
        return 15;
    }

    public static final int MAX_WATER_FLOW_RANGE() {
        return 7;
    }

    public static final int DEFAULT_FARMLAND_HYDRATE_RANGE() {
        return 4;
    }

    public static final int DEFAULT_BLOCK_TICKRATE() {
        return 10;
    }

    public static final int REDSTONE_LAMP_ONOFF_DELAY_TICKS() {
        return 4;
    }

    public static final int MAX_REDSTONE_DISTANCE() {
        return 14;
    }

    public static final int MAX_REDSTONE_POWER_OUT() {
        return SharedGlue.MAX_REDSTONE_DISTANCE() + 1;
    }

    public static final int HOPPER_COOLDOWN_TICKS() {
        return 8;
    }

    public static final int PLAYER_XP_CONSUME_COOLDOWN_TICKS() {
        return 2;
    }

    public static final int MAX_MATERIAL_ENCHANTIBILITY() {
        return ItemTier.GOLD.func_200927_e();
    }

    public static final int UNREPAIRABLE_TOOL_COST() {
        return 150;
    }

    public static final int HIGH_ANVIL_REPAIR_XP_LEVEL_COST() {
        return 39;
    }

    public static final int MAX_ANVIL_REPAIR_XP_LEVEL_COST() {
        return 50;
    }

    public static final int THRESHOLD_TOO_EXPENSIVE_REPAIR_XP_LEVEL_COST() {
        return 35;
    }

    public static final String I18N_ITEM_KEY_PREFIX() {
        return "item.";
    }

    public static final String I18N_BLOCK_KEY_PREFIX() {
        return "tile.";
    }

    public static final String I81N_KEY_SUFFIX() {
        return ".name";
    }

    public static final int WHITE_BUNNY_TYPE_META() {
        return 1;
    }

    public static final int GOLD_BUNNY_TYPE_META() {
        return 4;
    }

    public static final int EVIL_BUNNY_TYPE_META() {
        return 99;
    }

    public static final String DISCO_SHEEP_NAME() {
        return "jeb_";
    }

    public static final float LIVING_ENTITY_ONE_HEALTH_LEVEL() {
        return 2.0f;
    }

    public static final float DEFAULT_MAX_PLAYER_HEALTH() {
        return Math.max(20.0f, (float)Attributes.field_233818_a_.func_111110_b());
    }

    public static final float LIVING_ENTITY_ABSORPTION_PER_TICK() {
        return 4.0f;
    }

    public static final float DEFAULT_PLAYER_MAX_HEALTH_LEVEL() {
        return SharedGlue.DEFAULT_MAX_PLAYER_HEALTH() / SharedGlue.LIVING_ENTITY_ONE_HEALTH_LEVEL();
    }

    public static final int DEFAULT_LIQUID_USE_DURATION() {
        return 32;
    }

    public static final int DEFAULT_FOOD_CONSUME_DURATION() {
        return 32;
    }

    public static final int SHORT_FOOD_CONSUME_DURATION() {
        return 14;
    }

    public static final int HEARTY_FOOD_CONSUME_DURATION() {
        return 42;
    }

    public static final int HEARTY_FOOD_POINTS_THRESHOLD() {
        return 11;
    }

    public static final int WELL_FED_FOOD_POINTS_THRESHOLD() {
        return (int)(0.7f * SharedGlue.DEFAULT_PLAYER_MAX_HEALTH_LEVEL());
    }

    public static final int PLAYER_ONE_FOOD_LEVEL() {
        return 2;
    }

    public static final int DEFAULT_MAX_PLAYER_FOOD_LEVEL() {
        return 10 * SharedGlue.PLAYER_ONE_FOOD_LEVEL();
    }

    public static final float DEFAULT_MAX_PLAYER_SATURATION_LEVEL() {
        return 20.0f;
    }

    public static final int PLAYER_ONE_AIR_LEVEL() {
        return 30;
    }

    public static final int PLAYER_MAX_AIR_LEVEL() {
        return 10 * SharedGlue.PLAYER_ONE_AIR_LEVEL();
    }

    public static final float LIGHT_TO_LEVEL_MULTIPLIER() {
        return 0.06666667f;
    }

    public static final float LEVEL_TO_LIGHT_MULTIPLIER() {
        return 15.0f;
    }

    public static final float HARDNESS_TO_RESISTENCE_MULTIPLIER() {
        return 5.0f;
    }

    public static final float RESISTENCE_TO_RESISTENCE_SETTER_MULTIPLIER() {
        return 0.33333334f;
    }

    public static final float BLAST_RESISTENCE_TO_RESISTENCE_MULTIPLIER() {
        return SharedGlue.HARDNESS_TO_RESISTENCE_MULTIPLIER();
    }

    public static final float ENDERCHEST_HARDNESS() {
        return 23.0f;
    }

    public static final float OBSIDIAN_HARDNESS() {
        return 50.0f;
    }

    public static final float OBSIDIAN_EXPLOSION_RESISTANCE() {
        return 1200.0f;
    }

    public static final boolean isUnbreakable(@Nullable World world, @Nonnull BlockState state, @Nullable BlockPos pos) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150357_h || block == Blocks.field_180401_cv || block == Blocks.field_150384_bq || block == Blocks.field_150378_br || block == Blocks.field_185775_db || block == Blocks.field_185779_df || block == Blocks.field_189881_dj || block == Blocks.field_226904_lY_) {
            return true;
        }
        if (world != null && pos != null) {
            if (state.func_235714_a_((ITag)BlockTags.field_219755_X)) {
                return true;
            }
            float hardness = state.func_185887_b((IBlockReader)world, pos);
            return hardness < 0.0f;
        }
        return false;
    }

    public static final boolean isUnbreakableToAttackByExploders(Entity e) {
        boolean allowed = true;
        if (e instanceof TNTEntity || e instanceof AbstractFireballEntity || e instanceof FireworkRocketEntity || e instanceof LightningBoltEntity || e instanceof TNTMinecartEntity || NPE.isaDragon(e, true) || NPE.isaWither(e, true) || e instanceof GhastEntity || NPE.isaCreeper(e, true) || NPE.isaBlaze(e, true)) {
            allowed = false;
        }
        return allowed;
    }

    public static final String PICKAXE_TOOLNAME() {
        return ToolType.PICKAXE.getName();
    }

    public static final String AXE_TOOLNAME() {
        return ToolType.AXE.getName();
    }

    public static final String SHOVEL_TOOLNAME() {
        return ToolType.SHOVEL.getName();
    }

    public static final String HOE_TOOLNAME() {
        return "hoe";
    }

    public static final String SHEARS_TOOLNAME() {
        return "shears";
    }

    public static final String SICKLE_TOOLNAME() {
        return "sickle";
    }

    public static final String HAMMER_TOOLNAME() {
        return "hammer";
    }

    public static final String CRACKHAMMER_TOOLNAME() {
        return "crackhammer";
    }

    public static final String CLUB_TOOLNAME() {
        return "club";
    }

    public static final String SWORD_TOOLNAME() {
        return "sword";
    }

    public static final String MACHETE_TOOLNAME() {
        return "machete";
    }

    public static final String PAXEL_TOOLNAME() {
        return "paxel";
    }

    public static final String SLINGSHOT_TOOLNAME() {
        return "slingshot";
    }

    public static final String KNIFE_TOOLNAME() {
        return "knife";
    }

    public static final boolean isAxeOrShovelOrHoe(ToolType type) {
        return PAXEL.equals(type) || AXE.equals(type) || SHOVEL.equals(type) || HOE.equals(type);
    }

    public static final boolean isBluntTool(ToolType type) {
        return PAXEL.equals(type) || AXE.equals(type) || CLUB.equals(type) || HAMMER.equals(type);
    }

    public static final int STONE_TOOL_LEVEL() {
        return 1;
    }

    public static final int IRON_TOOL_LEVEL() {
        return 2;
    }

    public static final int DIAMOND_TOOL_LEVEL() {
        return 3;
    }

    public static final int OBSIDIAN_TOOL_LEVEL() {
        return 4;
    }

    public static final float MAX_TOOL_EFFICIENCY() {
        return 15.0f;
    }

    public static final boolean isMainHand(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND;
    }

    public static final boolean isOffHand(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.OFFHAND;
    }

    public static final boolean isEitherHand(EquipmentSlotType slot) {
        return slot == EquipmentSlotType.MAINHAND || slot == EquipmentSlotType.OFFHAND;
    }

    public static final int BASE_TOOL_LEVEL() {
        return 0;
    }

    public static final int JUNK_WEIGHT() {
        return 10;
    }

    public static final int UNCOMMON_WEIGHT() {
        return 3;
    }

    public static final int UNCOMMON_WEIGHT_CHESTS() {
        return 5;
    }

    public static final int TREASURE_WEIGHT() {
        return 1;
    }

    public static final VoxelShape SOUL_SAND_AABB() {
        return __SOUL_SAND_AABB;
    }

    public static final SoundEvent SPARKLE_SOUND() {
        return SoundEvents.field_187682_dG;
    }

    public static final SoundEvent EGG_THROWN_SOUND() {
        return SoundEvents.field_187511_aA;
    }

    public static final SoundEvent PEARL_THROWN_SOUND() {
        return SoundEvents.field_187595_bc;
    }

    public static final SoundEvent SQUISHY_THROWN_SOUND() {
        return SoundEvents.field_187886_fs;
    }

    public static final SoundEvent SNOWBALL_THROWN_SOUND() {
        return SoundEvents.field_187797_fA;
    }

    public static final SoundEvent RANDOM_CLICK_SOUND() {
        return SoundEvents.field_187576_at;
    }

    public static final SoundEvent RANDOM_FIZZ_SOUND() {
        return SoundEvents.field_187541_bC;
    }

    public static final SoundEvent PLAYER_BURP_SOUND() {
        return SoundEvents.field_187739_dZ;
    }

    public static final SoundEvent XP_INTERACT_SOUND() {
        return SoundEvents.field_187604_bf;
    }

    public static final SoundEvent LOCKABLE_UNLOCKED_SOUND() {
        return SoundEvents.field_187879_gP;
    }

    public static final SoundEvent LOCKABLE_LOCKED_SOUND() {
        return SoundEvents.field_187877_gO;
    }

    public static final SoundEvent LIQUID_SCOOPED_SOUND(Material material) {
        return material == Material.field_151587_i ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
    }

    public static final SoundEvent LIQUID_PUTDOWN_SOUND(Material material) {
        return material == Material.field_151587_i ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
    }

    public static final int BONEMEAL_SPARKLE_SFX() {
        return 2005;
    }

    public static final int POTION_SFX() {
        return 2002;
    }

    public static final int FIRE_EXTINGUISH_SFX() {
        return 1009;
    }

    public static final int DISPENSER_FAILED_SFX() {
        return 1001;
    }

    public static final int DISPENSER_SUCCEEDED_SFX() {
        return 1000;
    }

    public static final int DISPENSER_LAUNCHED_SFX() {
        return 1002;
    }

    public static final int BLOCK_BREAK_SFX() {
        return 2001;
    }

    public static final int ANVIL_LANDED_SFX() {
        return 1031;
    }

    public static final int PORTAL_TRAVEL_SFX() {
        return 1032;
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_DAYLIGHT_CYCLE() {
        return GameRules.field_223607_j;
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_MOB_SPAWNING() {
        return GameRules.field_223601_d;
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_MOB_LOOT() {
        return GameRules.field_223602_e;
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_NATURAL_REGEN() {
        return GameRules.field_223606_i;
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_TILE_DROPS() {
        return GameRules.field_223603_f;
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_SILVERFISH() {
        return SharedGlue.GAMERULE_TILE_DROPS();
    }

    public static final boolean isBlockDropGameRuleEnabled(World in) {
        return in != null && in.func_82736_K().func_223586_b(SharedGlue.GAMERULE_TILE_DROPS());
    }

    public static final GameRules.RuleKey<GameRules.BooleanValue> GAMERULE_MOB_GRIEFING() {
        return GameRules.field_223599_b;
    }

    public static final boolean allowGriefing(@Nonnull World world, @Nullable Entity from, GriefingType type) {
        boolean is;
        if (type == GriefingType.THEFT || type == GriefingType.CONTAMINATION) {
            return true;
        }
        try {
            is = ForgeEventFactory.getMobGriefingEvent((World)world, (Entity)from);
        }
        catch (Exception nulX) {
            is = world.func_82736_K().func_223586_b(SharedGlue.GAMERULE_MOB_GRIEFING());
        }
        return is;
    }

    public static final int FULL_100PERCENT_FLAMMABILITY() {
        return 300;
    }

    public static final int CREEPER_NO_BOOM_STATE() {
        return -1;
    }

    public static final int SLURRY_HIT_DAMAGE() {
        return 50;
    }

    public static final int MAX_HIT_DAMAGE() {
        return 200;
    }

    public static final int CHILD_SPAWN_AGE() {
        return -24000;
    }

    public static final int DEFAULT_XP_PICKUP_COOLDOWN_TICKS() {
        return 2;
    }

    public static final int DEFAULT_DROPPED_ITEM_LIFESPAN_TICKS() {
        return 300 * SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    }

    public static final String DEFAULT_NONBOOK_ENCHANTS_TAGNAME() {
        return "Enchantments";
    }

    public static final String DEFAULT_BOOK_ENCHANTS_TAGNAME() {
        return "StoredEnchantments";
    }

    public static final String DEFAULT_LOCKCODE_TAGNAME() {
        return "Lock";
    }

    public static final String DEFAULT_ITEMLIST_TAGNAME() {
        return "Items";
    }

    public static final String DEFAULT_CUSTOM_NAME_TAGNAME() {
        return "CustomName";
    }

    public static final String DEFAULT_LOOT_TABLE_TAGNAME() {
        return "LootTable";
    }

    public static final String DEFAULT_LOOT_TABLE_SEED_TAGNAME() {
        return "LootTableSeed";
    }

    public static String ITEM_INFO_HIDDEN_TAGNAME() {
        return "HideFlags";
    }

    public static final String CUSTOM_POTION_EFFECTS_TAGNAME() {
        return "CustomPotionEffects";
    }

    public static final String CUSTOM_POTION_COLOR_TAGNAME() {
        return "CustomPotionColor";
    }

    public static final String CUSTOM_POTION_UNLOCALIZED_TAGNAME() {
        return "CustomPotionLocName";
    }

    public static final String BLOCK_TILEENTITY_NBT_TAGNAME() {
        return "BlockEntityTag";
    }

    public static final String BLOCK_STATE_NBT_TAGNAME() {
        return "BlockStateTag";
    }

    public static final String CUSTOM_COLOR_TAGNAME() {
        return "CustomColorRgb";
    }

    public static final String CUSTOM_ATTRIBUTE_MODIFIERS_TAGNAME() {
        return "AttributeModifiers";
    }

    public static final String WEAPON_MODIFIER_ATTRNAME() {
        return "Weapon modifier";
    }

    public static final String TOOL_MODIFIER_ATTRNAME() {
        return "Tool modifier";
    }

    public static final String ARMOR_MODIFIER_ATTRNAME() {
        return "Armor modifier";
    }

    public static final String ARMOR_TOUGHNESS_MODIFIER_ATTRNAME() {
        return "Armor toughness";
    }

    public static final boolean ingredientDefined(@Nullable String name) {
        return name != null && RID.isIngredientDefined(name);
    }

    public static final boolean isLightweightDifficulty(@Nonnull IWorld world) {
        return world.func_175659_aa() == Difficulty.PEACEFUL || world.func_175659_aa() == Difficulty.EASY;
    }

    public static final boolean isZeroishAbsolute(float f) {
        return Math.abs(f) < 1.0E-4f;
    }

    @Nonnull
    public static final MinecraftServer getMCServer() {
        return Objects.requireNonNull(ServerLifecycleHooks.getCurrentServer(), "Server[side] MUST be started or current context");
    }

    @Nonnull
    public static final DynamicRegistries getMCDynamicRegistries() {
        return SharedGlue.getMCServer().func_244267_aX();
    }

    @Nonnull
    public static final DynamicRegistries getMCDynamicRegistries(@Nonnull IBiomeReader world_br) {
        return world_br.func_241828_r();
    }

    @Nonnull
    public static final DynamicRegistries getMCDynamicRegistries(@Nonnull Entity entity) {
        return entity.func_184102_h().func_244267_aX();
    }

    public static final boolean isaWorld(@Nullable IBlockReader blockr) {
        return blockr instanceof World;
    }

    public static final boolean isaWorld(@Nullable IWorldReader worldr) {
        return worldr instanceof World;
    }

    public static final boolean isaServerWorld(@Nullable IWorldReader worldr) {
        return worldr instanceof ServerWorld && !worldr.func_201670_d();
    }

    public static final boolean isaClientWorld(@Nullable IWorldReader worldr) {
        return worldr instanceof World && worldr.func_201670_d();
    }

    public static final boolean isaServerWorld(@Nullable Entity entity) {
        return entity != null && SharedGlue.isaServerWorld((IWorldReader)entity.func_130014_f_());
    }

    public static final boolean isaClientWorld(@Nullable Entity entity) {
        return entity != null && SharedGlue.isaClientWorld((IWorldReader)entity.func_130014_f_());
    }

    public static final ServerWorld getServerWorldOrFail(@Nonnull Entity entity) {
        if (SharedGlue.isaServerWorld(entity)) {
            return (ServerWorld)entity.func_130014_f_();
        }
        throw new IllegalStateException("Not on server-side");
    }

    public static final boolean isaServerWorld(@Nullable TileEntity te) {
        return te != null && te.func_145830_o() && SharedGlue.isaServerWorld((IWorldReader)te.func_145831_w());
    }

    public static final boolean isaPlayer(@Nullable Entity entity) {
        return entity instanceof PlayerEntity;
    }

    public static final boolean isaFakePlayer(@Nullable Entity entity, boolean nullIsFake) {
        return entity == null ? nullIsFake : entity instanceof FakePlayer;
    }

    public static final boolean isaOpPlayer(@Nullable PlayerEntity player) {
        if (player == null || !player.func_70089_S() || SharedGlue.isaFakePlayer((Entity)player, true)) {
            return false;
        }
        MinecraftServer server = player.func_184102_h();
        OpEntry uloe = (OpEntry)server.func_184103_al().func_152603_m().func_152683_b((Object)player.func_146103_bH());
        return uloe != null ? uloe.func_152644_a() >= server.func_110455_j() : false;
    }

    @Nullable
    static final ResourceLocation getEntityKey(@Nullable Entity entity) {
        return entity != null && ForgeRegistries.ENTITIES.containsValue((IForgeRegistryEntry)entity.func_200600_R()) ? EntityType.func_200718_a((EntityType)entity.func_200600_R()) : null;
    }

    @Nullable
    public static final MobEntity toMob(@Nullable Entity entity, boolean includeBoss) {
        if (entity instanceof MobEntity) {
            MobEntity livingEntity = null;
            if (entity.func_200600_R().func_220339_d() == EntityClassification.MONSTER || entity.func_184176_by() == SoundCategory.HOSTILE) {
                livingEntity = (MobEntity)entity;
            } else {
                ResourceLocation eId = SharedGlue.getEntityKey(entity);
                if (NPE.isModdedBadGuy(eId)) {
                    livingEntity = (MobEntity)entity;
                }
            }
            return livingEntity != null ? (includeBoss ? livingEntity : (entity.func_184222_aU() ? livingEntity : null)) : null;
        }
        return null;
    }

    public static final boolean isLivingBeing(@Nullable Entity entity) {
        return entity == null ? false : entity instanceof MobEntity || entity instanceof PlayerEntity;
    }

    public static final boolean isMonster(@Nullable Entity entity) {
        return SharedGlue.toMob(entity, false) != null;
    }

    private static final boolean isAngry(IAngerable piOoed, @Nullable LivingEntity wrt) {
        boolean is;
        boolean bl = piOoed.func_230256_F__() > 0 && (wrt == null ? piOoed.func_230257_G__() != null : wrt.func_110124_au().equals(piOoed.func_230257_G__())) ? true : (is = false);
        if (!is && piOoed instanceof MobEntity) {
            is = wrt == null && ((MobEntity)piOoed).func_213398_dR() || wrt != null && ((MobEntity)piOoed).func_70638_az() == wrt;
        }
        return is;
    }

    public static final boolean isUnfriendly(@Nullable Entity entity, @Nullable LivingEntity wrt) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof PufferfishEntity) {
            return ((PufferfishEntity)entity).func_213398_dR();
        }
        if (entity instanceof RabbitEntity) {
            return ((RabbitEntity)entity).func_175531_cl() == SharedGlue.EVIL_BUNNY_TYPE_META();
        }
        if (entity instanceof IAngerable) {
            return SharedGlue.isAngry((IAngerable)entity, wrt);
        }
        if (entity instanceof MobEntity) {
            return ((MobEntity)entity).func_213398_dR() && (wrt == null || ((MobEntity)entity).func_70638_az() == wrt);
        }
        return false;
    }

    public static final boolean isDefaultPassiveRelationship(@Nullable Entity entity) {
        if (entity == null || entity instanceof IMob) {
            return false;
        }
        if (entity instanceof AnimalEntity) {
            return true;
        }
        if (entity instanceof GolemEntity) {
            return true;
        }
        if (Villagers.isaFriendly(entity, true)) {
            return true;
        }
        if (entity instanceof WaterMobEntity) {
            return true;
        }
        return entity.getClass() == BatEntity.class;
    }

    public static final boolean isMonsterOrPiOoed(@Nullable Entity entity) {
        return SharedGlue.isMonster(entity) || SharedGlue.isUnfriendly(entity, null);
    }

    public static final boolean isMonsterOrPiOoed(@Nullable Entity entity, @Nullable LivingEntity wrt) {
        return SharedGlue.isMonster(entity) || SharedGlue.isUnfriendly(entity, wrt);
    }

    public static final boolean isAnyMonster(@Nullable Entity entity) {
        return SharedGlue.toMob(entity, true) != null;
    }

    public static final boolean isAnyMonsterOrPiOoed(@Nullable Entity entity) {
        return SharedGlue.isAnyMonster(entity) || SharedGlue.isUnfriendly(entity, null);
    }

    public static final boolean isAnyMonsterOrPiOoed(@Nullable Entity entity, @Nullable LivingEntity wrt) {
        return SharedGlue.isAnyMonster(entity) || SharedGlue.isUnfriendly(entity, wrt);
    }

    public static final boolean isBoss(@Nullable Entity entity) {
        return entity != null && !entity.func_184222_aU();
    }

    public static final boolean isBossLike(@Nullable Entity entity) {
        return entity != null && (!entity.func_184222_aU() || entity instanceof GiantEntity || entity instanceof MobEntity && ((MobEntity)entity).func_110138_aP() > 199.0f);
    }

    public static final MobEntity toCreature(@Nullable Entity entity) {
        if (entity instanceof MobEntity && !(entity instanceof IMob)) {
            EntityClassification clsf = entity.func_200600_R().func_220339_d();
            if (clsf != EntityClassification.MONSTER && clsf != EntityClassification.MISC) {
                return (MobEntity)entity;
            }
            if (clsf == EntityClassification.MISC && entity instanceof GolemEntity) {
                return (MobEntity)entity;
            }
        }
        return null;
    }

    public static final boolean isaFriendlyNPE(@Nullable Entity entity) {
        return SharedGlue.toCreature(entity) != null || Villagers.isaFriendly(entity, true);
    }

    public static final boolean isaPlayerOrFriendly(@Nullable Entity entity) {
        return SharedGlue.isaPlayer(entity) || SharedGlue.isaFriendlyNPE(entity);
    }

    public static final boolean isaRealPlayerOrFriendly(@Nullable Entity entity) {
        return SharedGlue.isaRealPlayer(entity) || SharedGlue.isaFriendlyNPE(entity);
    }

    public static final boolean isaAnimal(@Nullable Entity entity) {
        return entity instanceof AnimalEntity;
    }

    public static final boolean isaBabyAnimal(@Nullable Entity entity) {
        return entity instanceof AnimalEntity && ((AgeableEntity)entity).func_70631_g_();
    }

    public static final boolean isaPassiveEntity(@Nullable Entity entity) {
        return SharedGlue.isaAnimal(entity) || entity.getClass() == BatEntity.class;
    }

    public static final boolean isLivingHorseOrPackAnimal(@Nullable Entity entity) {
        return entity instanceof HorseEntity || entity instanceof AbstractChestedHorseEntity;
    }

    public static final boolean isPackAnimalCarrying(Entity entity) {
        return entity instanceof AbstractChestedHorseEntity && ((AbstractChestedHorseEntity)entity).func_190695_dh();
    }

    public static final boolean isaRealPlayer(@Nullable Entity entity) {
        return entity instanceof PlayerEntity && entity.func_130014_f_() != null && !(entity instanceof FakePlayer) && !((PlayerEntity)entity).func_180431_b(DamageSource_void);
    }

    public static final boolean isaProgressAffectedPlayer(@Nullable Entity entity) {
        return entity instanceof ServerPlayerEntity && !(entity instanceof FakePlayer) && SharedGlue.isaServerWorld((IWorldReader)((ServerPlayerEntity)entity).func_130014_f_());
    }

    public static final boolean isaRealNonSpectatingPlayer(@Nullable Entity entity) {
        return SharedGlue.isaRealPlayer(entity) && !((PlayerEntity)entity).func_175149_v();
    }

    public static final boolean isEntityAlive(@Nonnull LivingEntity entity, boolean checkHealth) {
        return !entity.field_70128_L && (!checkHealth || entity.func_110143_aJ() > 0.0f);
    }

    @Nullable
    public static final LivingEntity findEntityByUUID(@Nonnull ServerWorld world, @Nonnull UUID uuid) {
        if (uuid == null || world == null) {
            return null;
        }
        Entity hit = world.func_217461_a(uuid);
        return hit instanceof LivingEntity ? (LivingEntity)hit : null;
    }

    public static final void spawnEntityInto(World world, Entity entity) {
        world.func_217376_c(entity);
    }

    public static final boolean setBlockToAir(IWorld world, BlockPos blockpos) {
        return world.func_217377_a(blockpos, false);
    }

    @Nullable
    public static final Block blockFrom(ItemStack stack) {
        Item item;
        Object block = null;
        if (!ItemStacks.isEmpty(stack) && !SharedGlue.isDefined(block = Block.func_149634_a((Item)(item = stack.func_77973_b())))) {
            block = item instanceof IBlockItem ? ((IBlockItem)item).getBlock() : null;
        }
        return block;
    }

    @Nullable
    public static final <T> T typedBlock(@Nonnull BlockState state, Class<T> klass) {
        Block block = state.func_177230_c();
        return klass.isInstance(block) ? (T)klass.cast(block) : null;
    }

    @Nullable
    public static final <T> T typedBlock(@Nonnull ItemStack stack, Class<T> klass) {
        Block block = SharedGlue.blockFrom(stack);
        return klass.isInstance(block) ? (T)klass.cast(block) : null;
    }

    public static final boolean isaBlock(ItemStack stack) {
        Block block = SharedGlue.blockFrom(stack);
        return SharedGlue.isDefined(block) && block.getRegistryName() != null;
    }

    public static final boolean getPlayerInCreative(@Nonnull PlayerEntity player) {
        return player.func_184812_l_();
    }

    public static final boolean getPlayerInSurvival(@Nonnull PlayerEntity player) {
        return !SharedGlue.getPlayerInCreative(player);
    }

    public static final boolean isEntitySneaking(@Nonnull Entity entity) {
        return entity.func_225608_bj_();
    }

    public static final boolean isEntitySteppingCarefully(@Nonnull Entity entity) {
        return entity.func_226271_bk_();
    }

    public static final boolean isEntityForceLanding(@Nonnull Entity entity) {
        return entity.func_226272_bl_();
    }

    public static final boolean getPlayerCanFly(@Nonnull PlayerEntity player, boolean elytra) {
        ItemStack chestpiece;
        if (player.field_71075_bZ.field_75101_c || elytra && player.func_184613_cA()) {
            return true;
        }
        return elytra && (chestpiece = player.func_184582_a(EquipmentSlotType.CHEST)).func_77973_b() == Items.field_185160_cR && ElytraItem.func_185069_d((ItemStack)chestpiece);
    }

    public static final boolean isEntityOffGround(@Nonnull LivingEntity entity) {
        if (!entity.func_233570_aj_()) {
            return true;
        }
        PlayerEntity player = SharedGlue.getRealPlayerOrNull((Entity)entity);
        return player != null && player.field_71075_bZ.field_75100_b;
    }

    public static final boolean doEntityFall(@Nonnull Entity entity, float fallDistance, float damageMultiplier) {
        return entity.func_225503_b_(fallDistance, damageMultiplier);
    }

    public static final void setSurvivalModeFlightSpeed(@Nonnull PlayerEntity player, float value) {
        if (!player.field_71075_bZ.field_75098_d && !player.func_175149_v()) {
            CompoundNBT c0 = new CompoundNBT();
            player.field_71075_bZ.func_75091_a(c0);
            if (c0.func_150297_b("abilities", 10)) {
                CompoundNBT c1 = c0.func_74775_l("abilities");
                if (value <= 0.0f) {
                    value = new PlayerAbilities().func_75093_a();
                }
                c1.func_74776_a("flySpeed", value);
                player.field_71075_bZ.func_75095_b(c0);
            }
        }
    }

    public static final boolean canPlayerPickupXp(@Nonnull PlayerEntity player) {
        return player.field_71090_bL <= 0;
    }

    public static final void setPlayerXpPickupCooldownPeriod(@Nonnull PlayerEntity player, int multiplier) {
        if (multiplier <= 0) {
            multiplier = 1;
        }
        player.field_71090_bL = multiplier * SharedGlue.DEFAULT_XP_PICKUP_COOLDOWN_TICKS();
    }

    public static final Hand getActiveHandOrMain(@Nonnull PlayerEntity player) {
        Hand hand;
        Hand hand2 = hand = SharedGlue.isaClientWorld((IWorldReader)player.func_130014_f_()) ? null : player.func_184600_cs();
        if (hand == null) {
            hand = Hand.MAIN_HAND;
        }
        return hand;
    }

    @Nullable
    public static final ItemStack getPlayerHeldItem(@Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack helditem = player.func_184586_b(hand);
        return ItemStacks.isEmpty(helditem) ? null : helditem;
    }

    @Nullable
    public static final ItemStack getPlayerUsingItem(@Nonnull PlayerEntity player) {
        return SharedGlue.getPlayerHeldItem(player, SharedGlue.getActiveHandOrMain(player));
    }

    @Nullable
    public static final Item getPlayerUsingItemItem(@Nonnull PlayerEntity player) {
        ItemStack helditem = SharedGlue.getPlayerHeldItem(player, SharedGlue.getActiveHandOrMain(player));
        return helditem != null ? helditem.func_77973_b() : null;
    }

    public static final int getPlayerUsingItemSlotIndex(@Nonnull PlayerEntity player, @Nullable Hand hand) {
        if (hand == null) {
            hand = SharedGlue.getActiveHandOrMain(player);
        }
        int i = player.field_71071_by.field_70461_c;
        if (hand != Hand.MAIN_HAND) {
            i = player.field_71071_by.func_70302_i_() - 1;
        }
        return i;
    }

    @Nullable
    public static final PlayerEntity getPlayerOrNull(@Nullable Entity entity) {
        return entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
    }

    @Nullable
    public static final ServerPlayerEntity getPlayerMPOrNull(@Nullable Entity entity) {
        return entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null;
    }

    @Nullable
    public static final PlayerEntity getRealPlayerOrNull(@Nullable Entity entity) {
        return SharedGlue.isaRealNonSpectatingPlayer(entity) ? (PlayerEntity)entity : null;
    }

    public static final boolean hasPotionsInEffect(@Nonnull LivingEntity entity) {
        return entity != null && !entity.func_193076_bZ().isEmpty();
    }

    public static final boolean isAffectingPlayer(ItemStack stack, PlayerEntity player, int slotindex) {
        return PlayerInventory.func_184435_e((int)slotindex) || player.func_184592_cb() == stack || player.func_184614_ca() == stack;
    }

    public static final boolean inHotbarOrOffhand(Predicate<ItemStack> test, @Nonnull PlayerEntity player) {
        ItemStack stack = player.func_184592_cb();
        if (test.test(stack)) {
            return true;
        }
        int N = SharedGlue.PLAYER_HOTBAR_SIZE();
        for (int i = 0; i < N; ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (!test.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static final ItemStack isAffectingPlayer(Predicate<ItemStack> test, @Nonnull PlayerEntity player, boolean includeArmor, boolean includeBaubles) {
        ItemStack stack;
        Object bauble;
        if (test == null) {
            return ItemStack.field_190927_a;
        }
        if (includeBaubles && !(bauble = BaublesHelper.findBauble(test, (LivingEntity)player)).func_190926_b()) {
            return bauble;
        }
        if (includeArmor) {
            for (ItemStack armorpiece : player.func_184193_aE()) {
                if (!test.test(armorpiece)) continue;
                return armorpiece;
            }
        }
        if (test.test(stack = player.func_184592_cb())) {
            return stack;
        }
        stack = player.func_184614_ca();
        if (test.test(stack)) {
            return stack;
        }
        int N = SharedGlue.PLAYER_HOTBAR_SIZE();
        for (int i = 0; i < N; ++i) {
            stack = player.field_71071_by.func_70301_a(i);
            if (!test.test(stack)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static final ItemStack getAffectingPlayer(Item item, PlayerEntity player, boolean includeArmor, boolean includeBaubles) {
        ItemStack hit = SharedGlue.isAffectingPlayer((ItemStack stack) -> !stack.func_190926_b() && stack.func_77973_b() == item, player, includeArmor, includeBaubles);
        return hit;
    }

    public static final boolean isAffectingPlayer(Item item, PlayerEntity player, boolean includeArmor, boolean includeBaubles) {
        return !SharedGlue.getAffectingPlayer(item, player, includeArmor, includeBaubles).func_190926_b();
    }

    @Nonnull
    public static final List<ItemStack> getAffectingEntity(Predicate<ItemStack> test, @Nonnull LivingEntity entity, boolean includeArmor, boolean includeBaubles) {
        ItemStack stack;
        NonNullList out = NonNullList.func_191196_a();
        if (test == null) {
            return out;
        }
        PlayerEntity player = SharedGlue.getRealPlayerOrNull((Entity)entity);
        if (player != null && includeBaubles) {
            BaublesHelper.iterateBaubles(input -> {
                List l = (List)List.class.cast(input.ticket);
                if (test.test(input.bauble)) {
                    l.add(input.bauble);
                }
                return l;
            }, (LivingEntity)player, out);
        }
        if (includeArmor) {
            for (ItemStack armorpiece : entity.func_184193_aE()) {
                if (!test.test(armorpiece)) continue;
                out.add((Object)armorpiece);
            }
        }
        if (test.test(stack = entity.func_184592_cb())) {
            out.add((Object)stack);
        }
        if (test.test(stack = entity.func_184614_ca())) {
            out.add((Object)stack);
        }
        int N = SharedGlue.PLAYER_HOTBAR_SIZE();
        if (player != null) {
            for (int i = 0; i < N; ++i) {
                if (i == player.field_71071_by.field_70461_c || !test.test(stack = player.field_71071_by.func_70301_a(i))) continue;
                out.add((Object)stack);
            }
        }
        return out;
    }

    @Nonnull
    public static final List<ItemStack> getAffectingEntity(LivingEntity entity, boolean includeArmor, boolean includeBaubles) {
        return SharedGlue.getAffectingEntity(stack -> !stack.func_190926_b(), entity, includeArmor, includeBaubles);
    }

    @Nullable
    public static final <T> T getCapability(@Nullable ICapabilityProvider provider, Capability<T> capability, @Nullable Direction facing) {
        return (T)(provider != null ? provider.getCapability(capability, facing).orElse(null) : null);
    }

    @Nullable
    public static final IItemHandler getItemHandlerCapability(@Nullable ICapabilityProvider provider, @Nullable Direction facing) {
        return (IItemHandler)SharedGlue.getCapability(provider, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing);
    }

    @Nullable
    public static final IItemHandler getPlayerInventoryHandler(@Nonnull PlayerEntity player) {
        return SharedGlue.getItemHandlerCapability((ICapabilityProvider)player, Direction.DOWN);
    }

    public static final void consumeItemFromStack(PlayerEntity player, ItemStack stack, Hand hand, boolean updateHUD) {
        if (SharedGlue.getPlayerInSurvival(player)) {
            if (ItemStacks.decrBy(stack, 1)) {
                int i = player.field_71071_by.field_70461_c;
                if (hand != Hand.MAIN_HAND) {
                    i = player.field_71071_by.func_70302_i_() - 1;
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
            if (updateHUD) {
                SharedGlue.refreshPlayerHUD(player);
            }
        }
    }

    public static void consumeItemFromMainHand(PlayerEntity player, ItemStack stack) {
        SharedGlue.consumeItemFromStack(player, stack, Hand.MAIN_HAND, false);
    }

    public static final ItemStack usedItem(LivingEntity user, ItemStack held, @Nullable Hand hand, boolean forced) {
        if (!ItemStacks.isEmpty(held)) {
            if (hand != null && held.func_77984_f()) {
                boolean placeholder = !forced && held != user.func_184586_b(hand);
                held.func_222118_a(1, user, u -> {
                    if (!placeholder && SharedGlue.isaRealPlayer((Entity)u)) {
                        u.func_213334_d(hand);
                    }
                });
            } else {
                boolean placeholder = hand != null && !forced && held != user.func_184586_b(hand);
                ItemStack leftover = held.getContainerItem();
                held.func_190918_g(1);
                if (held.func_190926_b()) {
                    held = ItemStack.field_190927_a;
                }
                if (!placeholder && SharedGlue.isaRealPlayer((Entity)user)) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)user), (ItemStack)leftover, (int)((PlayerEntity)user).field_71071_by.field_70461_c);
                }
            }
        }
        return held;
    }

    public static final ItemStack usedItem(LivingEntity user, ItemStack held, @Nullable Hand hand) {
        return SharedGlue.usedItem(user, held, hand, false);
    }

    public static final void refreshPlayerHUD(@Nonnull PlayerEntity player) {
        player.field_71071_by.func_70296_d();
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
        }
    }

    public static final ItemStack insertStrictItemStacked(IItemHandler inventory, @Nonnull ItemStack stack, boolean simulate) {
        ItemStack slot;
        int i;
        if (inventory == null || ItemStacks.isEmpty(stack)) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return ItemHandlerHelper.insertItem((IItemHandler)inventory, (ItemStack)stack, (boolean)simulate);
        }
        int sizeInventory = inventory.getSlots();
        for (i = 0; !(i >= sizeInventory || ItemHandlerHelper.canItemStacksStack((ItemStack)(slot = inventory.getStackInSlot(i)), (ItemStack)stack) && (stack = inventory.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
        }
        if (!stack.func_190926_b()) {
            for (i = 0; !(i >= sizeInventory || inventory.getStackInSlot(i).func_190926_b() && (stack = inventory.insertItem(i, stack, simulate)).func_190926_b()); ++i) {
            }
        }
        return stack;
    }

    public static final void giveStrictItemToPlayer(PlayerEntity player, @Nonnull ItemStack stack, int preferredSlot) {
        if (stack.func_190926_b()) {
            return;
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.field_71071_by);
        World world = player.func_130014_f_();
        ItemStack remainder = stack;
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        if (!remainder.func_190926_b()) {
            remainder = SharedGlue.insertStrictItemStacked((IItemHandler)inventory, remainder, false);
        }
        if (remainder.func_190926_b() || remainder.func_190916_E() != stack.func_190916_E()) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
        if (!remainder.func_190926_b() && SharedGlue.isaServerWorld((IWorldReader)world)) {
            ItemEntity drop = new ItemEntity(world, player.func_226277_ct_(), player.func_226278_cu_() + 0.5, player.func_226281_cx_(), remainder);
            drop.func_174867_a(40);
            drop.func_213317_d(drop.func_213322_ci().func_216372_d(0.0, 1.0, 0.0));
            world.func_217376_c((Entity)drop);
        }
    }

    public static final void giveStrictItemToPlayer(PlayerEntity player, @Nonnull ItemStack stack) {
        SharedGlue.giveStrictItemToPlayer(player, stack, -1);
    }

    public static final <E> NonNullList<E> emptyNonNullList() {
        return NonNullList.func_191196_a();
    }

    public static final NonNullList<ItemStack> emptyNonNullItemStackList(int size) {
        return NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    @Nullable
    public static final <T extends IStringSerializable> T fromLString(@Nullable String s, T[] _VALUES) {
        if ((s = StringUtils.trimToNull((String)s)) != null && _VALUES != null) {
            s = s.toLowerCase(Locale.ROOT);
            for (T next : _VALUES) {
                if (!s.equals(next.func_176610_l())) continue;
                return next;
            }
        }
        return null;
    }

    protected SharedGlue() {
    }

    public static final void init0() {
    }

    public static final class IsSameStack
    implements com.google.common.base.Predicate<ItemStack> {
        @Nonnull
        private final ItemStack _match;

        public IsSameStack(@Nonnull ItemStack check) {
            this._match = check;
        }

        public boolean apply(ItemStack stack) {
            return stack != null && stack == this._match;
        }
    }
}

