/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.event.entity.living.PotionEvent;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IStubbornEffect;

public class StubbornPotionEffect
extends EffectInstance
implements IStubbornEffect {
    public static final int _MAX_EXTENDED_DURATION = 10 * SharedGlue.DEFAULT_TICKS_PER_FULL_DAYNIGHT_CYCLE();
    protected final boolean _permanent;
    protected final int _original_duration;

    static final boolean isFortified(@Nullable Object o) {
        if (o instanceof IStubbornEffect) {
            return ((IStubbornEffect)o).isPermanentEffect();
        }
        if (o != null && o.getClass() == EffectInstance.class) {
            return StubbornPotionEffect.isFortified(((EffectInstance)o).func_188419_a());
        }
        return false;
    }

    public static final StubbornPotionEffect from(@Nonnull EffectInstance e) {
        return new StubbornPotionEffect(StubbornPotionEffect.isFortified(e), e.func_188419_a(), e.func_76459_b(), e.func_76458_c(), e.func_82720_e(), e.func_188418_e());
    }

    public StubbornPotionEffect(boolean fortified, Effect potion, int duration, int amplifier, boolean ambient, boolean particles) {
        super(potion, duration, amplifier, ambient, particles);
        this._permanent = fortified;
        this._original_duration = duration;
    }

    public StubbornPotionEffect(Effect potion, int duration, int amplifier) {
        this(StubbornPotionEffect.isFortified(potion), potion, duration, amplifier);
    }

    public StubbornPotionEffect(boolean fortified, Effect potion, int duration, int amplifier) {
        this(fortified, potion, duration, amplifier, false, true);
    }

    public StubbornPotionEffect(StubbornPotionEffect from) {
        super((EffectInstance)from);
        this._permanent = from._permanent;
        this._original_duration = from._original_duration;
    }

    public String getType() {
        return "stubborn";
    }

    @Override
    public boolean isPermanentEffect(ItemStack unused) {
        return this._permanent;
    }

    public List<ItemStack> getCurativeItems() {
        List l = super.getCurativeItems();
        ListIterator litr = l.listIterator();
        while (litr.hasNext()) {
            ItemStack curative = (ItemStack)litr.next();
            if (!this.isPermanentEffect(curative) && !Potions.isMilk(curative, true)) continue;
            litr.remove();
        }
        return l;
    }

    protected EffectInstance combineInternal(EffectInstance other) {
        if (other.func_188419_a() == this.func_188419_a()) {
            int new_amplifier = other.func_76458_c();
            int cur_amplifier = this.func_76458_c();
            if (new_amplifier < 0 || cur_amplifier < 0 || new_amplifier > cur_amplifier) {
                return other;
            }
            int cur_duration = this.func_76459_b();
            boolean check_duration = cur_duration < _MAX_EXTENDED_DURATION;
            int new_duration = cur_duration;
            if (new_amplifier == cur_amplifier) {
                new_duration += other.func_76459_b();
            } else {
                float percent = ((float)new_amplifier + 1.0f) / ((float)cur_amplifier + 1.0f) + 0.2f;
                new_duration += (int)(percent * (float)other.func_76459_b());
            }
            if (check_duration && new_duration > _MAX_EXTENDED_DURATION) {
                new_duration = _MAX_EXTENDED_DURATION;
            }
            if (new_duration > cur_duration) {
                other = new EffectInstance(this.func_188419_a(), new_duration, cur_amplifier, other.func_82720_e(), other.func_188418_e());
            }
        }
        return other;
    }

    public final boolean func_199308_a(EffectInstance other) {
        if (!Potions.isLikelyForever(other)) {
            other = this.combineInternal(other);
        }
        return super.func_199308_a(other);
    }

    public final int getOriginalDuration() {
        return this._original_duration;
    }

    public static final void onTryRemove(@Nonnull PotionEvent.PotionRemoveEvent event) {
        LivingEntity carrier = event.getEntityLiving();
        if (SharedGlue.isaServerWorld((Entity)carrier)) {
            EffectInstance whot = event.getPotionEffect();
            if (whot instanceof IStubbornEffect) {
                if (whot.func_76459_b() > 0 && ((IStubbornEffect)whot).isPermanentEffect(carrier)) {
                    event.setCanceled(true);
                }
            } else {
                Effect whotp = event.getPotion();
                if (whotp instanceof IStubbornEffect && ((IStubbornEffect)whotp).isPermanentEffect(carrier)) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

