/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractSkullBlock;
import net.minecraft.block.AttachedStemBlock;
import net.minecraft.block.BambooSaplingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.CocoaBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.FungusBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.KelpBlock;
import net.minecraft.block.MushroomBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.FlintAndSteelItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.Tags;
import org.jwaresoftware.mcmods.lib.Armory;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.PropertyDefinition;

@ParametersAreNonnullByDefault
public final class Whatis {
    public static final boolean isCobblestone(BlockState what) {
        return SharedGlue.isSame(what.func_177230_c(), Blocks.field_150347_e) || SharedGlue.isSame(what.func_177230_c(), Blocks.field_150341_Y);
    }

    public static final boolean isRawstone(BlockState what) {
        return SharedGlue.isSame(what.func_177230_c(), Blocks.field_150348_b);
    }

    public static final boolean isCobblestoneLike(BlockState what) {
        return Whatis.isCobblestone(what) || Tags.Blocks.COBBLESTONE.func_230235_a_((Object)what.func_177230_c());
    }

    public static final boolean isCobweb(BlockState what) {
        return what.func_203425_a(Blocks.field_196553_aF) || what.func_235714_a_(RID.Tags.COBWEB_BLOCKS);
    }

    public static final boolean isLargeFungusStemBlock(BlockState what) {
        Block block = what.func_177230_c();
        return SharedGlue.isSame(block, Blocks.field_150420_aW) || SharedGlue.isSame(block, Blocks.field_150419_aX) || SharedGlue.isSame(block, Blocks.field_235377_mq_) || SharedGlue.isSame(block, Blocks.field_235368_mh_) || what.func_235714_a_(RID.Tags.LARGE_FUNGUS_STEMS);
    }

    public static final boolean isMushroom(BlockState what) {
        Block block = what.func_177230_c();
        return SharedGlue.isDefined(block) && (SharedGlue.isSame(block, Blocks.field_150337_Q) || SharedGlue.isSame(block, Blocks.field_150338_P) || block instanceof MushroomBlock || block instanceof FungusBlock);
    }

    public static final boolean isCake(BlockState what) {
        return SharedGlue.isSame(what.func_177230_c(), Blocks.field_150414_aQ) || what.func_177230_c() instanceof CakeBlock;
    }

    public static final boolean isBlankBook(Item what) {
        return what == Items.field_151122_aG || what == Items.field_151099_bA;
    }

    public static final boolean isLavaBucket(ItemStack what) {
        if (!ItemStacks.isEmpty(what) && what.func_77973_b() == Items.field_151129_at) {
            return true;
        }
        return Fluids.isLavaBucket(what);
    }

    public static final boolean isLikelyNotShownAsItem(@Nonnull Object o) {
        return o == null || o == Blocks.field_150350_a || o == Items.field_190931_a || o instanceof StemBlock || o instanceof AttachedStemBlock || o instanceof CropsBlock || o instanceof CocoaBlock || o instanceof KelpBlock;
    }

    public static final boolean isBirchLog(@Nonnull BlockState what) {
        return what.func_203425_a(Blocks.field_196619_M);
    }

    public static final boolean isDarkOakLog(@Nonnull BlockState what) {
        return what.func_203425_a(Blocks.field_196623_P);
    }

    public static final boolean isLikelyTree(World world, BlockPos blockpos, @Nonnull BlockState what) {
        Block block = what.func_177230_c();
        if (!block.func_203417_a((ITag)BlockTags.field_200031_h)) {
            return false;
        }
        if (!Locations.isOverworld((IWorldReader)world)) {
            return false;
        }
        int radius = 3;
        int i = radius + 1;
        int leaf_block_count = 0;
        if (world.func_175707_a(blockpos.func_177982_a(-i, -i, -i), blockpos.func_177982_a(i, i, i))) {
            for (BlockPos test_blockpos : BlockPos.func_218278_a((BlockPos)blockpos.func_177982_a(-radius, -radius, -radius), (BlockPos)blockpos.func_177982_a(radius, radius, radius))) {
                BlockState test_blockstate = world.func_180495_p(test_blockpos);
                if (!test_blockstate.func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E)) continue;
                ++leaf_block_count;
            }
        }
        return leaf_block_count > 6;
    }

    public static final boolean isLikelySapling(BlockState what) {
        boolean likely;
        Block block = what.func_177230_c();
        if (block instanceof SaplingBlock || block.func_203417_a((ITag)BlockTags.field_200030_g) || block instanceof BambooSaplingBlock) {
            return true;
        }
        String klassname = block.getClass().getSimpleName();
        boolean bl = likely = klassname.endsWith("Sapling") || klassname.startsWith("Sapling");
        likely = likely && block instanceof IGrowable ? !(block instanceof BushBlock) && PropertyDefinition.getAgeReading(what) >= 0 : false;
        return likely;
    }

    public static boolean isLikelySpawner(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return SharedGlue.isSame(block, Blocks.field_150474_ac) || block instanceof SilverfishBlock || block instanceof SpawnerBlock;
    }

    public static boolean isLikelyDetonateable(BlockState blockstate) {
        Block block = blockstate.func_177230_c();
        return blockstate.func_235714_a_(RID.Tags.TNT_LIKE) || SharedGlue.isSame(block, Blocks.field_150335_W) || ModIntegration.isDetonateable(block);
    }

    public static final boolean isBoat(@Nullable Entity what) {
        if (what instanceof BoatEntity) {
            return true;
        }
        return what != null && what.func_200600_R().func_220341_a(RID.Tags.BOAT_ENTITIES);
    }

    public static final boolean isNaturalFlightGear(Item what) {
        if (what == Items.field_185160_cR || what instanceof ElytraItem) {
            return true;
        }
        if (SharedGlue.isDefined(what) && what.func_206844_a(Armory.Tags.NATURAL_WINGS)) {
            return true;
        }
        return ModIntegration.isNaturalFlightGear(what);
    }

    public static final boolean isSimpleShield(Item what) {
        if (what == Items.field_185159_cQ || what instanceof ShieldItem) {
            return true;
        }
        if (SharedGlue.isDefined(what) && what.func_206844_a(Armory.Tags.SHIELDS)) {
            return true;
        }
        return ModIntegration.isSimpleShield(what);
    }

    public static final boolean isSimpleShears(Item what) {
        if (what == Items.field_151097_aZ || what instanceof ShearsItem) {
            return true;
        }
        return SharedGlue.isDefined(what) && what.func_206844_a(RID.Tags.SHEARS);
    }

    public static final boolean isFlintAndSteel(Item what) {
        if (what == Items.field_151033_d || what instanceof FlintAndSteelItem) {
            return true;
        }
        return SharedGlue.isDefined(what) && what.func_206844_a(RID.Tags.FLINT_STEELS);
    }

    public static final boolean isAnimalArmor(Item what) {
        if (what == Items.field_222110_op || what == Items.field_151125_bZ || what == Items.field_151138_bX || what == Items.field_151136_bY) {
            return true;
        }
        return what.func_206844_a(Armory.Tags.ANIMAL_ARMOR) || ModIntegration.isAnimalArmor(what);
    }

    public static final boolean isLikenessTrophy(ItemStack what) {
        Block block;
        if (ItemStacks.isEmpty(what)) {
            return false;
        }
        Item whatwhat = what.func_77973_b();
        if (RID.matches(what, "carrots:heads")) {
            return true;
        }
        if (whatwhat instanceof BlockItem && (block = ((BlockItem)whatwhat).func_179223_d()) instanceof AbstractSkullBlock) {
            return true;
        }
        return ModIntegration.isLikenessTrophy(what);
    }

    private Whatis() {
    }

    public static final void initLoad0() {
    }
}

