/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class XpCalculations {
    public static final int LEVEL_ONE_XP = 17;
    public static final int LEVEL_ONE_XP_MENDABILITY = 34;
    public static final float XP_TO_MILLIBUCKET_MULTIPLIER = 31.25f;
    public static final float MIN_XP_FOR_MILLIBUCKET = 0.032f;

    public static final int getExperienceForLevel(int level) {
        if (level <= 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * 17;
        }
        if (level > 15 && level < 31) {
            return (int)(1.5 * Math.pow(level, 2.0) - 29.5 * (double)level + 360.0);
        }
        return (int)(3.5 * Math.pow(level, 2.0) - 151.5 * (double)level + 2220.0);
    }

    public static final int getLevelForExperience(int experience) {
        int i = 0;
        while (XpCalculations.getExperienceForLevel(i) <= experience) {
            ++i;
        }
        return i - 1;
    }

    public static final int getXpToNextLevel(int level) {
        return XpCalculations.getExperienceForLevel(level + 1) - XpCalculations.getLevelForExperience(level);
    }

    public static final int getPlayerXP(@Nullable PlayerEntity player) {
        return player == null ? 0 : (int)((float)XpCalculations.getExperienceForLevel(player.field_71068_ca) + player.field_71106_cc * (float)player.func_71050_bK());
    }

    public static final int getXpToNextLevel(@Nonnull PlayerEntity player) {
        int playerXp = XpCalculations.getPlayerXP(player);
        int curLevel = XpCalculations.getLevelForExperience(playerXp);
        return 1 + (XpCalculations.getExperienceForLevel(curLevel + 1) - playerXp);
    }

    public static final int getXpToThisLevel(@Nonnull PlayerEntity player, int wantLevel) {
        int playerXp = XpCalculations.getPlayerXP(player);
        return XpCalculations.getExperienceForLevel(wantLevel) - playerXp;
    }

    public static final boolean addXpToPlayer(PlayerEntity player, int amount) {
        int current_experience = XpCalculations.getPlayerXP(player);
        if (current_experience <= 0 && amount <= 0) {
            return false;
        }
        player.func_195068_e(amount);
        return true;
    }

    public static final void spawnXP(@Nonnull World world, double x, double y, double z, int amount, @Nullable Random rand) {
        float dx = rand != null ? rand.nextFloat() * 0.8f + 0.1f : 0.0f;
        float dy = rand != null ? rand.nextFloat() * 0.8f + 0.1f : 0.0f;
        float dz = rand != null ? rand.nextFloat() * 0.8f + 0.1f : 0.0f;
        ExperienceOrbEntity orb = new ExperienceOrbEntity(world, x + (double)dx, y + (double)dy, z + (double)dz, amount);
        SharedGlue.spawnEntityInto(world, (Entity)orb);
    }

    public static final void spawnXPBurst(@Nonnull World world, double x, double y, double z, int amount, @Nullable Random rand) {
        while (amount > 0) {
            int subamount = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= subamount;
            XpCalculations.spawnXP(world, x, y, z, subamount, rand);
        }
    }

    public static final void spawnXPReward(@Nonnull PlayerEntity player, int amount) {
        double x = player.func_226277_ct_() + 0.5;
        double y = player.func_226278_cu_() + 0.5;
        double z = player.func_226281_cx_() + 0.5;
        while (amount > 0) {
            int subamount = ExperienceOrbEntity.func_70527_a((int)amount);
            amount -= subamount;
            XpCalculations.spawnXP(player.func_130014_f_(), x, y, z, subamount, null);
        }
    }

    public static final int durabilityToXp(int durability) {
        return durability / 2;
    }

    public static final int xpToDurability(int xp) {
        return xp * 2;
    }

    public static final int xpToMillibuckets(float xp) {
        return (int)(Math.abs(xp) * 31.25f);
    }

    public static final int clampRepairCost(int cost, int max) {
        if (max <= 0) {
            max = SharedGlue.HIGH_ANVIL_REPAIR_XP_LEVEL_COST();
        }
        if (cost > max) {
            cost = max;
        }
        if (cost < 0) {
            cost = 0;
        }
        return cost;
    }

    public static final int clampRepairCost(int cost) {
        return XpCalculations.clampRepairCost(cost, -1);
    }

    private XpCalculations() {
    }
}

