/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;

public class CraftedItemTrigger
extends AbstractCriterionTrigger<Instance> {
    @Nonnull
    public static final ResourceLocation NAME = LibInfo.r("player_crafted");
    @Nonnull
    public static final CraftedItemTrigger INSTANCE = new CraftedItemTrigger();

    public ResourceLocation func_192163_a() {
        return NAME;
    }

    protected CraftedItemTrigger() {
    }

    protected Instance deserializeTrigger(@Nonnull JsonObject json, @Nonnull EntityPredicate.AndPredicate pp, @Nonnull ConditionArrayParser ca) {
        return Instance.deserialize(pp, json);
    }

    public void trigger(ServerPlayerEntity player, ItemStack with) {
        this.func_235959_a_(player, instance -> instance.test(with));
    }

    public static final void doApply(ServerPlayerEntity player, ItemStack with) {
        INSTANCE.trigger(player, with);
    }

    public static final class Instance
    extends CriterionInstance {
        @Nonnull
        private final ItemPredicate _match;
        @Nonnull
        private final ITemperatureChangeable.UsedEffect _e;

        public Instance(EntityPredicate.AndPredicate pp, ItemPredicate item, ITemperatureChangeable.UsedEffect e) {
            super(NAME, pp);
            this._match = Objects.requireNonNull(item);
            this._e = e != null ? e : ITemperatureChangeable.UsedEffect.UNCHANGED;
        }

        private boolean atTemperature(ItemStack item) {
            if (this._e == ITemperatureChangeable.UsedEffect.UNCHANGED || !(item.func_77973_b() instanceof ITemperatureChangeable)) {
                return true;
            }
            if (!item.func_77942_o()) {
                return false;
            }
            ITemperatureChangeable cap = (ITemperatureChangeable)item.func_77973_b();
            return this._e == ITemperatureChangeable.UsedEffect.HEATED ? cap.isHeated(item) || cap.shouldBeHeated(item) : cap.isCooled(item) || cap.shouldBeCooled(item);
        }

        public boolean test(ItemStack item) {
            return this._match.func_192493_a(item) && this.atTemperature(item);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer ca) {
            JsonObject json = super.func_230240_a_(ca);
            json.add("item", this._match.func_200319_a());
            if (this._e != ITemperatureChangeable.UsedEffect.UNCHANGED) {
                json.addProperty("state", this._e.name());
            }
            return json;
        }

        public static final Instance deserialize(EntityPredicate.AndPredicate pp, JsonObject json) {
            String estring = JSONUtils.func_151219_a((JsonObject)json, (String)"state", null);
            ITemperatureChangeable.UsedEffect e = ITemperatureChangeable.UsedEffect.fromString(estring);
            JsonElement item = json.get("item");
            if (item == null) {
                throw new JsonParseException("Missing required top-level 'item' element");
            }
            return new Instance(pp, ItemPredicate.func_192492_a((JsonElement)item), e);
        }
    }
}

