/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;

public final class HarvestedPredicate
implements BiPredicate<PlayerEntity, BlockXyz> {
    public static final HarvestedPredicate ANY = new HarvestedPredicate(false, null, null, StatePropertiesPredicate.field_227178_a_, NBTPredicate.field_193479_a);
    public static final String MEMBER = "block";
    private final boolean _strict;
    @Nullable
    private final ITag.INamedTag<Block> _in;
    @Nullable
    private final Block _the_block;
    private final StatePropertiesPredicate _state_criteria;
    private final NBTPredicate _TE_criteria;

    public HarvestedPredicate(boolean strict, @Nullable ITag<Block> in, @Nullable Block match, StatePropertiesPredicate placed_state, NBTPredicate TE_state) {
        Validate.isTrue((in == null || in instanceof ITag.INamedTag ? 1 : 0) != 0, (String)"A normal block-by-name tag group is required", (Object[])new Object[0]);
        this._strict = strict;
        this._in = (ITag.INamedTag)in;
        this._the_block = match;
        this._state_criteria = placed_state;
        this._TE_criteria = TE_state;
    }

    @Override
    public final boolean test(PlayerEntity player, BlockState state) {
        boolean r = false;
        if (player instanceof ServerPlayerEntity && state != null) {
            if (this._strict && !SharedGlue.isaProgressAffectedPlayer((Entity)player)) {
                return false;
            }
            if (this._in != null && !state.func_235714_a_(this._in)) {
                return false;
            }
            if (this._the_block != null && state.func_177230_c() != this._the_block) {
                return false;
            }
            if (!this._state_criteria.func_227181_a_(state)) {
                return false;
            }
            r = true;
        }
        return r;
    }

    @Override
    public boolean test(PlayerEntity player, BlockXyz xyz) {
        boolean r = this.test(player, xyz.state);
        if (r && this._TE_criteria != NBTPredicate.field_193479_a) {
            if (xyz.worldr == null || !xyz.isLocated()) {
                return false;
            }
            TileEntity te = xyz.worldr.func_175625_s(xyz.pos);
            if (te == null || !this._TE_criteria.func_193477_a((INBT)te.func_189515_b(new CompoundNBT()))) {
                return false;
            }
        }
        return r;
    }

    static final Block loadBlock(String name) {
        ResourceLocation blockid = new ResourceLocation(name);
        if (!ForgeRegistries.BLOCKS.containsKey(blockid)) {
            throw new JsonParseException("Unable to find block '" + blockid + "'");
        }
        return (Block)ForgeRegistries.BLOCKS.getValue(blockid);
    }

    static final HarvestedPredicate from(String name) {
        return new HarvestedPredicate(true, null, HarvestedPredicate.loadBlock(name), StatePropertiesPredicate.field_227178_a_, NBTPredicate.field_193479_a);
    }

    @Nonnull
    public JsonElement serialize_value() {
        JsonObject block_criteria = new JsonObject();
        if (this._the_block != null) {
            block_criteria.addProperty("name", ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)this._the_block).toString());
        }
        if (this._in != null) {
            block_criteria.addProperty("tag", this._in.func_230234_a_().toString());
        }
        block_criteria.add("state", this._state_criteria.func_227180_a_());
        block_criteria.add("nbt", this._TE_criteria.func_200322_a());
        return block_criteria;
    }

    @Nonnull
    public JsonObject serialize_into(@Nonnull JsonObject into) {
        into.add(MEMBER, this.serialize_value());
        return into;
    }

    @Nonnull
    public JsonElement serialize() {
        return this.serialize_into(new JsonObject());
    }

    @Nonnull
    public static final HarvestedPredicate deserialize_value(JsonElement json) {
        String s;
        if (json.isJsonPrimitive()) {
            return HarvestedPredicate.from(json.getAsString());
        }
        JsonObject body = JSONUtils.func_151210_l((JsonElement)json, (String)MEMBER);
        boolean strict = true;
        Block block_match = null;
        if (body.has("name")) {
            s = JSONUtils.func_151200_h((JsonObject)body, (String)"name");
            if (body.size() == 1) {
                return HarvestedPredicate.from(s);
            }
            block_match = HarvestedPredicate.loadBlock(s);
        }
        ITag.INamedTag tag_match = null;
        if (body.has("tag")) {
            s = JSONUtils.func_151200_h((JsonObject)body, (String)"tag");
            ITag<Block> gen_match = RID.getBlockTag(s);
            ITag.INamedTag iNamedTag = tag_match = gen_match instanceof ITag.INamedTag ? (ITag.INamedTag)gen_match : null;
            if (tag_match == null) {
                throw new JsonParseException("Unable to find tag group '" + s + "'");
            }
        }
        if (block_match == null && tag_match == null) {
            throw new JsonParseException("Either a known block tag group or block name is required");
        }
        NBTPredicate TE_check = NBTPredicate.func_193476_a((JsonElement)body.get("nbt"));
        StatePropertiesPredicate state_check = StatePropertiesPredicate.func_227186_a_((JsonElement)body.get("state"));
        if (body.has("strict")) {
            strict = JSONUtils.func_151212_i((JsonObject)body, (String)"strict");
        }
        return new HarvestedPredicate(strict, (ITag<Block>)tag_match, block_match, state_check, TE_check);
    }

    @Nonnull
    public static final Optional<HarvestedPredicate> deserialize_outof(JsonObject from) {
        return Optional.ofNullable(from.has(MEMBER) ? HarvestedPredicate.deserialize_value(from.get(MEMBER)) : null);
    }
}

