/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.advancements;

import com.google.gson.JsonObject;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.AbstractCriterionTrigger;
import net.minecraft.advancements.criterion.CriterionInstance;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.loot.ConditionArrayParser;
import net.minecraft.loot.ConditionArraySerializer;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.advancements.HarvestedPredicate;

public final class HarvestedTrigger
extends AbstractCriterionTrigger<Instance> {
    @Nonnull
    public static final ResourceLocation NAME = LibInfo.r("player_harvested");
    @Nonnull
    public static final HarvestedTrigger INSTANCE = new HarvestedTrigger();

    public ResourceLocation func_192163_a() {
        return NAME;
    }

    protected Instance deserializeTrigger(@Nonnull JsonObject json, @Nonnull EntityPredicate.AndPredicate pp, @Nonnull ConditionArrayParser ca) {
        return new Instance(pp, HarvestedPredicate.deserialize_outof(json).get());
    }

    private HarvestedTrigger() {
    }

    public final void trigger(ServerPlayerEntity player, @Nullable BlockState harvested) {
        this.func_235959_a_(player, instance -> instance.test((PlayerEntity)player, harvested));
    }

    public static final void doApply(ServerPlayerEntity player, BlockState harvested) {
        INSTANCE.trigger(player, harvested);
    }

    public final void trigger(ServerPlayerEntity player, @Nullable BlockXyz harvested) {
        this.func_235959_a_(player, instance -> instance.test((PlayerEntity)player, harvested));
    }

    public static final void doApply(ServerPlayerEntity player, BlockXyz harvested) {
        INSTANCE.trigger(player, harvested);
    }

    public static final class Instance
    extends CriterionInstance {
        private final HarvestedPredicate _block_criteria;

        public Instance(EntityPredicate.AndPredicate pp, @Nonnull HarvestedPredicate match_criteria) {
            super(NAME, pp);
            this._block_criteria = Objects.requireNonNull(match_criteria);
        }

        public boolean test(PlayerEntity player, BlockXyz block) {
            return this._block_criteria.test(player, block);
        }

        public boolean test(PlayerEntity player, BlockState block) {
            return this._block_criteria.test(player, block);
        }

        public JsonObject func_230240_a_(ConditionArraySerializer ca) {
            return this._block_criteria.serialize_into(super.func_230240_a_(ca));
        }
    }
}

