/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.apache.commons.lang3.ArrayUtils;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.TimeFrame;

public enum DayNightState implements IStringSerializable
{
    UNKNOWN(true),
    DAWN(false),
    DAY(false),
    DUSK(false),
    NIGHT(false),
    NOT_NIGHT(true),
    BEGINNING(true),
    ENDING(true),
    TWILIGHT(true),
    MORNING(true),
    AFTERNOON(true);

    private final String _name_lc = this.name().toLowerCase(Locale.ROOT);
    private final boolean _computed;
    public static final DayNightState[] EMPTY_ARRAY;
    public static final List<DayNightState> SET;
    public static final List<DayNightState> SET5;
    private static final DayNightState[] _VALUES;

    private DayNightState(boolean algo) {
        this._computed = algo;
    }

    public int index() {
        return this.ordinal() - 1;
    }

    public final String func_176610_l() {
        return this._name_lc;
    }

    public final String toString() {
        return this.func_176610_l();
    }

    public final boolean isKnown() {
        return this != UNKNOWN;
    }

    public final boolean isComputed() {
        return this._computed;
    }

    public final boolean hasAnyLight() {
        return !this.isComputed() && this != NIGHT;
    }

    @Nonnull
    public final String getTranslationKey() {
        return this.isComputed() ? "carrots.null" : LibInfo.lstring("daynight." + this._name_lc);
    }

    @Nullable
    public static final DayNightState fromLString(@Nullable String s) {
        return (DayNightState)SharedGlue.fromLString((String)s, (IStringSerializable[])_VALUES);
    }

    @Nonnull
    public static final DayNightState[] deserialize_from(JsonElement json) throws JsonSyntaxException {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonPrimitive()) {
                String s = json.getAsString();
                if (Strings.isNoneValue(s, true)) {
                    return EMPTY_ARRAY;
                }
                DayNightState state = DayNightState.fromLString(s);
                if (state == null) {
                    throw new JsonSyntaxException("Unrecognized daynight state '" + s + "'");
                }
                return (DayNightState[])ArrayUtils.toArray((Object[])new DayNightState[]{state});
            }
            if (json.isJsonArray()) {
                ArrayList choices = new ArrayList();
                json.getAsJsonArray().forEach(e -> {
                    String s = e.getAsString();
                    DayNightState state = DayNightState.fromLString(s);
                    if (state == null) {
                        throw new JsonSyntaxException("Unrecognized daynight state '" + s + "'");
                    }
                    choices.add(state);
                });
                if (!choices.isEmpty()) {
                    return choices.toArray(EMPTY_ARRAY);
                }
            }
        }
        throw new JsonSyntaxException("At least one daynight state must be defined");
    }

    @Nullable
    public static final DayNightState getUnchangingState(IBiomeReader br, BlockPos at) {
        DayNightState st = UNKNOWN;
        if (br instanceof World) {
            RegistryKey<Biome> biome;
            RegistryKey w = ((World)br).func_234923_W_();
            st = w == World.field_234919_h_ || w == World.field_234920_i_ ? NIGHT : (Locations.inTheNether(biome = Locations.biomeKeyFor(br, at), br, at) || Locations.inTheEnd(biome, br, at) ? NIGHT : null);
        }
        return st;
    }

    static {
        EMPTY_ARRAY = new DayNightState[0];
        SET = Collections.unmodifiableList((List)Util.func_200696_a(new ArrayList(), s -> {
            s.add(DAWN);
            s.add(DAY);
            s.add(DUSK);
            s.add(NIGHT);
        }));
        SET5 = Collections.unmodifiableList((List)Util.func_200696_a(new ArrayList(), s -> {
            s.add(DAWN);
            s.add(DAY);
            s.add(DUSK);
            s.add(NIGHT);
            s.add(UNKNOWN);
        }));
        _VALUES = DayNightState.values();
    }

    @ParametersAreNonnullByDefault
    public static interface Provider
    extends BiFunction<World, BlockPos, DayNightState> {
        default public boolean matches(@Nullable DayNightState is, DayNightState wanted) {
            if (wanted == null || is == null) {
                return is == null ? wanted == UNKNOWN : false;
            }
            switch (wanted) {
                case UNKNOWN: 
                case DAWN: 
                case DAY: 
                case DUSK: 
                case NIGHT: {
                    return is == wanted;
                }
                case NOT_NIGHT: {
                    return is != NIGHT;
                }
                case TWILIGHT: {
                    return is == DAWN || is == DUSK;
                }
                case BEGINNING: {
                    return is == DAWN || is == DAY || is == MORNING;
                }
                case ENDING: {
                    return is == DUSK || is == NIGHT;
                }
                case MORNING: {
                    return is == DAWN || is == MORNING;
                }
                case AFTERNOON: {
                    return is == AFTERNOON;
                }
            }
            return false;
        }

        default public boolean matches(World w, BlockPos at, DayNightState wanted) {
            DayNightState is = this.apply(w, at);
            return this.matches(is, wanted);
        }

        default public DayNightState getTimeOfDay(World w, BlockPos at) {
            return this.apply(w, at);
        }

        @Override
        default public DayNightState apply(World w, BlockPos at) {
            return w == null ? UNKNOWN : (w.func_72935_r() ? DAY : NIGHT);
        }

        default public Detailed getDetailedTimeOfDay(World w, BlockPos at) {
            return new Detailed(this.apply(w, at));
        }
    }

    public static final class Detailed
    implements Comparable<Detailed> {
        @Nonnull
        public final DayNightState state;
        @Nonnull
        public final TimeFrame timeframe;
        public static final Detailed UNKNOWN = new Detailed();

        private Detailed() {
            this(UNKNOWN, TimeFrame.ANY);
        }

        public Detailed(DayNightState s) {
            this(s, TimeFrame.ANY);
        }

        public Detailed(DayNightState s, TimeFrame w) {
            if (s == null || !SET5.contains((Object)s)) {
                throw new IllegalArgumentException("Bad state; must be [UNKNOWN,DAWN,DUSK,DAY,NIGHT]");
            }
            this.state = s;
            this.timeframe = w == null ? TimeFrame.ANY : w;
        }

        public final boolean isUnknown() {
            return this.state == UNKNOWN;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() == Detailed.class) {
                return ((Detailed)o).state == this.state && ((Detailed)o).timeframe == this.timeframe;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.timeframe});
        }

        @Override
        public int compareTo(Detailed other) {
            if (other == null) {
                throw new NullPointerException("daynight.detail");
            }
            if (other == this) {
                return 0;
            }
            if (this.isUnknown()) {
                return other.isUnknown() ? 0 : -1;
            }
            int sc = this.state.compareTo(other.state);
            return sc != 0 ? sc : TimeFrame.COMPARATOR.compare(this.timeframe, other.timeframe);
        }

        public String toString() {
            return this.timeframe == TimeFrame.ANY ? this.state.toString() : "" + (Object)((Object)this.state) + "(" + this.timeframe + ")";
        }

        public IFormattableTextComponent getDisplayText() {
            TranslationTextComponent stateText = new TranslationTextComponent(this.state.getTranslationKey());
            return this.timeframe == TimeFrame.ANY ? stateText : new TranslationTextComponent("tooltip.itemsuffix.string.narrow", new Object[]{stateText, this.timeframe.toString()});
        }

        public DayNightState timeframed_state() {
            DayNightState st = this.state;
            if (st == DAY) {
                if (this.timeframe == TimeFrame.EARLY) {
                    st = MORNING;
                } else if (this.timeframe == TimeFrame.LATE) {
                    st = AFTERNOON;
                }
            }
            return st;
        }
    }
}

