/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;

public interface ICraftedStorage {
    public Type storedType();

    public int quantityStored(@Nullable ItemStack var1, @Nullable PlayerEntity var2);

    public int quantityStored(BlockState var1, @Nullable PlayerEntity var2);

    public static enum Type implements IStringSerializable
    {
        GENERAL('*'),
        ITEM('I'),
        BLOCK('B'),
        ENTITY('E'),
        STACK('S'),
        PORTION('R'),
        USE('u'),
        POINT('o', false),
        UNIT('U'),
        MILLIBUCKET('k'),
        BUCKET('K'),
        NUGGET('t'),
        INGOT('T'),
        SEED('D'),
        PACKET('P'),
        BAG('G'),
        CARTON('C'),
        BUNDLE('L'),
        XP('X', false),
        SQUIRMY('Q');

        private static final Type[] _VALUES;
        private final char _id;
        private final String _i18n_name;
        private final boolean _intformat;

        private Type(char id, boolean integerformat) {
            this._id = id;
            this._i18n_name = this.name().toLowerCase(Locale.ROOT);
            this._intformat = integerformat;
        }

        private Type(char id) {
            this(id, true);
        }

        public final char id() {
            return this._id;
        }

        public final String idString() {
            return "" + this.id();
        }

        public final String func_176610_l() {
            return this._i18n_name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public final String getTranslateKey() {
            return Strings.tooltipKey("storage.type." + this._i18n_name);
        }

        public final boolean intF() {
            return this._intformat;
        }

        public final boolean floatF() {
            return !this.intF();
        }

        @Nonnull
        public static final Type fromLString(@Nullable String s) {
            if (s == null) {
                return GENERAL;
            }
            Type t = (Type)SharedGlue.fromLString((String)s, (IStringSerializable[])_VALUES);
            return t != null ? t : UNIT;
        }

        @Nonnull
        public static final Type fromID(@Nullable String s) {
            if (s == null) {
                return GENERAL;
            }
            if (s.length() == 1 && Character.isDefined(s.charAt(0))) {
                char ch = s.charAt(0);
                for (Type t : _VALUES) {
                    if (t.id() != ch) continue;
                    return t;
                }
            }
            return UNIT;
        }

        static {
            _VALUES = Type.values();
        }
    }
}

