/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;

public interface INutritionSource {
    public static final INutritionSource NONE = new INutritionSource(){

        @Override
        public long getNNCheckList(ItemStack source) {
            return 0L;
        }

        @Override
        public boolean isNNUnsafe(ItemStack source) {
            return false;
        }
    };
    public static final Pair<Integer, Float> NONE_EXPORT = Pair.of((Object)0, (Object)Float.valueOf(0.0f));

    default public float getNNHealAmount() {
        return this.getNNHealAmount(ItemStack.field_190927_a);
    }

    default public float getNNHealAmount(ItemStack source) {
        return 0.0f;
    }

    default public float getNNCalories(ItemStack source) {
        return this.getNNHealAmount(source);
    }

    default public float getNNSaturationModifier() {
        return this.getNNSaturationModifier(ItemStack.field_190927_a);
    }

    default public float getNNSaturationModifier(ItemStack source) {
        return 0.0f;
    }

    default public long getNNCheckList(ItemStack source) {
        return source.func_190926_b() ? 0L : NutritionNote.getFrom(source);
    }

    @Nonnull
    default public Map<ResourceLocation, Float> getNNBreakdown(ItemStack source) {
        return Collections.EMPTY_MAP;
    }

    default public boolean isNNUnsafe(ItemStack source) {
        return NutritionNote.UNSAFE.in(this.getNNCheckList(source));
    }

    public static Pair<Integer, Float> export(ItemStack source) {
        INutritionSource ns = null;
        Item item = source.func_77973_b();
        if (item instanceof INutritionSource) {
            ns = (INutritionSource)item;
        } else if (item instanceof Wrap) {
            ns = (INutritionSource)((Wrap)item).get();
        }
        Pair nn = ns != null && ns != NONE ? Pair.of((Object)((int)ns.getNNHealAmount(source)), (Object)Float.valueOf(ns.getNNSaturationModifier(source))) : NONE_EXPORT;
        return nn;
    }

    public static Triple<List<ItemStack>, Integer, Float> export(PlayerEntity player, ItemStack source) {
        CompoundNBT instr;
        Pair<Integer, Float> nn = INutritionSource.export(source);
        if (Instructions.present(source) && (instr = Instructions.get(source)).func_74764_b("Size") && instr.func_150297_b(SharedGlue.DEFAULT_ITEMLIST_TAGNAME(), 9)) {
            NonNullList items = NonNullList.func_191197_a((int)instr.func_74762_e("Size"), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)instr, (NonNullList)items);
            return Triple.of((Object)items, (Object)((Integer)nn.getLeft()), (Object)((Float)nn.getRight()));
        }
        return Triple.of(Collections.singletonList(source), (Object)((Integer)nn.getLeft()), (Object)((Float)nn.getRight()));
    }

    public static boolean hasExportedIngredients(ItemStack source) {
        return !source.func_190926_b() && source.func_222117_E() && Instructions.present(source) && Instructions.get(source).func_150297_b(SharedGlue.DEFAULT_ITEMLIST_TAGNAME(), 9);
    }

    @FunctionalInterface
    public static interface Wrap
    extends Supplier<INutritionSource> {
    }

    public static class Simple
    implements INutritionSource {
        public final float baseHealAmount;
        public final float baseSaturationAmount;
        public final long baseNotes;

        public Simple(float h, float s, long n) {
            this.baseHealAmount = h;
            this.baseSaturationAmount = s;
            this.baseNotes = NutritionNote.clean(n);
        }

        public Simple(@Nonnull CompoundNBT from) {
            this(from.func_74760_g("He"), from.func_74760_g("Sa"), from.func_74763_f("NN"));
        }

        public Simple(@Nonnull Food from, long notes) {
            this(from.func_221466_a(), from.func_221469_b(), notes);
        }

        public Simple(@Nonnull Food from) {
            this(from, 0L);
        }

        public CompoundNBT save(CompoundNBT to) {
            if (to == null) {
                to = new CompoundNBT();
            }
            to.func_74776_a("He", this.baseHealAmount);
            to.func_74776_a("Sa", this.baseSaturationAmount);
            to.func_74772_a("NN", this.baseNotes);
            return to;
        }

        @Override
        public final float getNNHealAmount(ItemStack unused) {
            return this.getNNHealAmount();
        }

        @Override
        public float getNNHealAmount() {
            return this.baseHealAmount;
        }

        @Override
        public final float getNNSaturationModifier(ItemStack unused) {
            return this.getNNSaturationModifier();
        }

        @Override
        public float getNNSaturationModifier() {
            return this.baseSaturationAmount;
        }

        @Override
        public long getNNCheckList(ItemStack unused) {
            return this.baseNotes;
        }
    }
}

