/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;

public interface ISoakable {
    public static final String PROPERTY_SOAKED = "soaked";
    public static final String NBT_CREATE_SOAKED = LibInfo.rstring("Soaked");

    default public boolean canSoak(ItemStack stack) {
        return true;
    }

    default public boolean isSoaked(ItemStack stack) {
        return !PotionUtils.func_185189_a((ItemStack)stack).isEmpty();
    }

    default public boolean shouldBeSoaked(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b(NBT_CREATE_SOAKED);
    }

    default public boolean isSoakedOrShouldBeSoaked(ItemStack stack) {
        return this.shouldBeSoaked(stack) || this.isSoaked(stack);
    }

    @Nonnull
    default public String stripShouldBeSoakedWith(ItemStack stack) {
        String rid;
        String string = rid = ItemStacks.hasData(stack, NBT_CREATE_SOAKED, 8) ? ItemStacks.getString(stack, NBT_CREATE_SOAKED) : "";
        if (!rid.isEmpty()) {
            ItemStacks.removeData(stack, NBT_CREATE_SOAKED, true);
        }
        return rid;
    }

    @Nonnull
    default public List<EffectInstance> getSoakingEffects(ItemStack stack) {
        return PotionUtils.func_185189_a((ItemStack)stack);
    }

    @Nullable
    default public List<EffectInstance> getSoakingEffectsIfPresent(ItemStack stack) {
        if (!this.isSoaked(stack)) {
            return null;
        }
        List<EffectInstance> effects = this.getSoakingEffects(stack);
        return effects == null || effects.isEmpty() ? null : effects;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SoakedPropertyGetter
    implements IItemPropertyGetter {
        public static final ResourceLocation ID = new ResourceLocation("soaked");
        public static final IItemPropertyGetter INSTANCE = new SoakedPropertyGetter();

        public static final void addTo(@Nonnull Item item) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)ID, (IItemPropertyGetter)INSTANCE);
        }

        public static final void addTo(@Nonnull Item item, String property) {
            ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation(property), (IItemPropertyGetter)INSTANCE);
        }

        public float call(ItemStack stack, ClientWorld world, LivingEntity entity) {
            float value = 0.0f;
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ISoakable) {
                ISoakable soakable = (ISoakable)stack.func_77973_b();
                if (soakable.isSoaked(stack)) {
                    value = 1.0f;
                } else if (soakable.shouldBeSoaked(stack) && ItemStacks.hasData(stack, "Potion")) {
                    value = 1.0f;
                }
            }
            return value;
        }
    }
}

