/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.LibConfig;

public final class PropertyDefinition
implements IntSupplier {
    public static final int NO_READING = -1;
    public final IntegerProperty property;
    public int value;
    public final int max_value;

    public PropertyDefinition(int val, int max, IntegerProperty nam) {
        this.value = val;
        this.max_value = max;
        this.property = nam;
    }

    public PropertyDefinition(PropertyDefinition from) {
        this.value = from.value;
        this.max_value = from.max_value;
        this.property = from.property;
    }

    public PropertyDefinition(int val, PropertyDefinition from) {
        this(from);
        this.value = val;
    }

    @Override
    public final int getAsInt() {
        return this.value;
    }

    public final void set(int v) {
        this.value = Math.max(v, this.max_value);
    }

    public final boolean immature() {
        return this.property != null && this.value < this.max_value;
    }

    public void increment(World world, BlockState state, BlockPos pos) {
        world.func_175656_a(pos, (BlockState)state.func_235896_a_((Property)this.property));
    }

    public final int reading(@Nonnull BlockState state) {
        return PropertyDefinition.getReadingFrom(state, this.property.func_177701_a(), -1);
    }

    public static final int getMaxValueAllowed(@Nonnull IntegerProperty ip) {
        int max = -1;
        Iterator iterator = ip.func_177700_c().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static final int getReadingFrom(@Nonnull BlockState state, @Nonnull String NAME, int valueIfMissing) {
        int value = valueIfMissing;
        for (Property p : state.func_235904_r_()) {
            if (!NAME.equals(p.func_177701_a()) || !(p instanceof IntegerProperty)) continue;
            value = (Integer)state.func_177229_b(p);
            break;
        }
        return value;
    }

    public static final int getReadingFrom(@Nonnull BlockState state, @Nonnull IntegerProperty PROPERTY) {
        return PropertyDefinition.getReadingFrom(state, PROPERTY.func_177701_a(), -1);
    }

    public static final int getAgeReading(@Nonnull BlockState state) {
        int age;
        block1: {
            String synonym;
            age = PropertyDefinition.getReadingFrom(state, BlockStateProperties.field_222512_Y);
            if (age >= 0) break block1;
            Iterator<String> iterator = LibConfig.agePropertyNames().iterator();
            while (iterator.hasNext() && (age = PropertyDefinition.getReadingFrom(state, synonym = iterator.next(), -1)) < 0) {
            }
        }
        return age;
    }

    public static final int getMoistureReading(@Nonnull BlockState state) {
        int wet;
        block1: {
            String synonym;
            wet = PropertyDefinition.getReadingFrom(state, BlockStateProperties.field_208133_ah);
            if (wet >= 0) break block1;
            Iterator<String> iterator = LibConfig.wetPropertyNames().iterator();
            while (iterator.hasNext() && (wet = PropertyDefinition.getReadingFrom(state, synonym = iterator.next(), -1)) < 0) {
            }
        }
        return wet;
    }

    @Nullable
    public static final PropertyDefinition getFrom(@Nonnull BlockState state, @Nonnull String p_config_id, String ... NAMES) {
        List<String> properties = NAMES.length == 0 ? LibConfig.propertySynonyms(p_config_id) : Arrays.asList(NAMES);
        if (!properties.isEmpty()) {
            int age = -1;
            int max = -1;
            int i = 0;
            do {
                for (Property p : state.func_235904_r_()) {
                    if (!(p instanceof IntegerProperty) || !properties.get(i).equals(p.func_177701_a())) continue;
                    age = (Integer)state.func_177229_b(p);
                    max = PropertyDefinition.getMaxValueAllowed((IntegerProperty)p);
                    return new PropertyDefinition(age, max, (IntegerProperty)p);
                }
            } while (++i < properties.size());
        }
        return null;
    }

    @Nullable
    public static final PropertyDefinition getAgeFrom(@Nonnull BlockState state, String ... NAMES) {
        return PropertyDefinition.getFrom(state, BlockStateProperties.field_222512_Y.func_177701_a(), NAMES);
    }

    @Nullable
    public static final PropertyDefinition getWetFrom(@Nonnull BlockState state, String ... NAMES) {
        return PropertyDefinition.getFrom(state, BlockStateProperties.field_208133_ah.func_177701_a(), NAMES);
    }
}

