/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.NPE;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Villagers;

public enum Relationship {
    HOSTILE,
    UNKNOWN,
    NEUTRAL,
    PASSIVE,
    FRIENDLY,
    FAMILY,
    SELF;


    public final boolean isSelf() {
        return this == SELF;
    }

    public final boolean isFamily() {
        return this == SELF || this == FAMILY;
    }

    public final boolean isGenerous() {
        return Relationship.isGenerous(this);
    }

    public final boolean isGenerous(LivingEntity to) {
        return this.isGenerous() && (this == SELF || SharedGlue.isaPlayer((Entity)to));
    }

    public final boolean isOverlyGenerous() {
        return Relationship.isOverlyGenerous(this);
    }

    public static final boolean isGenerous(@Nullable Relationship r) {
        return r == SELF || r == FAMILY || r == FRIENDLY;
    }

    public static final boolean isOverlyGenerous(@Nullable Relationship r) {
        return r == SELF || r == FAMILY || r == FRIENDLY || r == PASSIVE;
    }

    @Nonnull
    public static final Relationship identify(@Nullable LivingEntity of) {
        Relationship r = UNKNOWN;
        if (of != null) {
            if (SharedGlue.isaRealPlayer((Entity)of)) {
                r = NEUTRAL;
            } else if (SharedGlue.isAnyMonsterOrPiOoed((Entity)of)) {
                r = HOSTILE;
            } else if (SharedGlue.isaAnimal((Entity)of)) {
                r = PASSIVE;
            } else if (Villagers.isa((Entity)of, true)) {
                r = PASSIVE;
            }
        }
        return r;
    }

    @Nonnull
    public static final Relationship get(@Nullable LivingEntity source, @Nullable LivingEntity to) {
        if (source == null || to == null) {
            return UNKNOWN;
        }
        if (source == to) {
            return SELF;
        }
        boolean teammate = source.func_184191_r((Entity)to);
        Relationship r = UNKNOWN;
        if (SharedGlue.isaPlayer((Entity)source)) {
            PlayerEntity player = (PlayerEntity)source;
            if (teammate) {
                r = FAMILY;
            } else if (SharedGlue.isaPlayer((Entity)to)) {
                r = LibConfig.playersAreFriends(player.func_184102_h().func_71264_H()) ? FRIENDLY : NEUTRAL;
            } else if (SharedGlue.isAnyMonsterOrPiOoed((Entity)to, (LivingEntity)player)) {
                r = HOSTILE;
            } else if (Villagers.isaFriendly((Entity)to, true) || NPE.isVillageProtector((Entity)to, true, true)) {
                r = PASSIVE;
            } else if (SharedGlue.isDefaultPassiveRelationship((Entity)to)) {
                r = NEUTRAL;
            }
        } else if (SharedGlue.isaPlayer((Entity)to)) {
            r = teammate ? FAMILY : (SharedGlue.isAnyMonsterOrPiOoed((Entity)source, to) ? (source.func_213336_c(to) ? HOSTILE : NEUTRAL) : PASSIVE);
        } else if (!SharedGlue.isAnyMonster((Entity)source)) {
            if (SharedGlue.isAnyMonster((Entity)to)) {
                r = HOSTILE;
            } else if (SharedGlue.isDefaultPassiveRelationship((Entity)to)) {
                r = PASSIVE;
            }
        } else if (SharedGlue.isAnyMonster((Entity)to)) {
            r = source.func_213336_c(to) ? HOSTILE : NEUTRAL;
        }
        return r;
    }
}

