/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import org.jwaresoftware.mcmods.lib.BlockXyz;

public enum TemperatureRange {
    FREEZING(0.07),
    COLD(0.18),
    MEDIUM(0.65),
    WARM(1.1),
    BROILING(1.5);

    private final double _biome_sampling;

    public final boolean lessThan(TemperatureRange other) {
        return other != null && this.ordinal() < other.ordinal();
    }

    public static final TemperatureRange match(double temperature) {
        return temperature < 0.15 ? FREEZING : (temperature < 0.2 ? COLD : (temperature < 1.0 ? MEDIUM : (temperature < 1.3 ? WARM : BROILING)));
    }

    public static final TemperatureRange match(Biome biome_obj, BlockPos at) {
        Biome.Category c = biome_obj.func_201856_r();
        if (c == Biome.Category.NETHER) {
            return BROILING;
        }
        if (c == Biome.Category.THEEND) {
            return FREEZING;
        }
        float t = biome_obj.func_225486_c(at);
        return TemperatureRange.match(t);
    }

    private TemperatureRange(double sampling) {
        this._biome_sampling = sampling;
    }

    public final double sampling() {
        return this._biome_sampling;
    }

    @ParametersAreNonnullByDefault
    public final class Converter
    implements DoubleSupplier,
    DoubleUnaryOperator {
        @Nonnull
        protected final DoubleSupplier _sensor;
        @Nonnull
        private final DoubleUnaryOperator _normalizer;

        public Converter(DoubleSupplier sensor) {
            this(sensor, null);
        }

        public Converter(@Nullable DoubleSupplier sensor, DoubleUnaryOperator normalizer) {
            this._sensor = Objects.requireNonNull(sensor, "Sensor required");
            this._normalizer = normalizer == null ? DoubleUnaryOperator.identity() : normalizer;
        }

        public Converter(Supplier<BlockXyz> sensor) {
            this(() -> {
                BlockXyz xyz = (BlockXyz)sensor.get();
                return xyz.worldr.func_226691_t_(xyz.pos).func_225486_c(xyz.pos);
            }, null);
        }

        @Override
        public double getAsDouble() {
            return this.applyAsDouble(this._sensor.getAsDouble());
        }

        public final double get() {
            return this.getAsDouble();
        }

        @Override
        public double applyAsDouble(double in) {
            return this._normalizer.applyAsDouble(in);
        }

        public final double get(double in) {
            return this.applyAsDouble(in);
        }
    }
}

