/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;
import org.jwaresoftware.mcmods.lib.api.TripleFrame;

public enum TimeFrame implements IStringSerializable,
Comparable<TimeFrame>
{
    ANY,
    EARLY,
    MID,
    LATE;

    public static final Comparator<TimeFrame> COMPARATOR;
    private final String _name_lc = this.name().toLowerCase(Locale.ROOT);

    public String func_176610_l() {
        return this._name_lc;
    }

    public final String qualify(@Nonnull String context) {
        return this == ANY ? context : this._name_lc + "_" + context;
    }

    public final TripleFrame triframe() {
        return TripleFrame._VALUES[this.ordinal()];
    }

    public static final TimeFrame unqualify(String s, boolean lenient) {
        if (s != null) {
            TripleFrame alt;
            if (s.startsWith("early_")) {
                return EARLY;
            }
            if (s.startsWith("mid_")) {
                return MID;
            }
            if (s.startsWith("late_")) {
                return LATE;
            }
            if (lenient && (alt = TripleFrame.unqualify(s, lenient)) != TripleFrame.ANY) {
                return alt == TripleFrame.LESS ? EARLY : LATE;
            }
        }
        return ANY;
    }

    public static final TimeFrame unqualify(String s) {
        return TimeFrame.unqualify(s, false);
    }

    public static final TimeFrame guess(int at, int total_amount) {
        int amt_per_timeframe = total_amount / 3;
        if (at >= 0) {
            at %= total_amount;
        }
        return at < 0 ? ANY : (at < amt_per_timeframe ? EARLY : (at < 2 * amt_per_timeframe ? MID : LATE));
    }

    static {
        COMPARATOR = new Comparator<TimeFrame>(){

            @Override
            public int compare(TimeFrame one, TimeFrame two) {
                if (one == null || two == null) {
                    throw new NullPointerException("timeframe");
                }
                if (one == ANY || two == ANY) {
                    return 0;
                }
                return one.compareTo(two);
            }
        };
    }
}

