/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.util.IStringSerializable;

public enum TripleFrame implements IStringSerializable,
Comparable<TripleFrame>
{
    ANY,
    LESS,
    MID,
    MORE;

    public static final Comparator<TripleFrame> COMPARATOR;
    static final TripleFrame[] _VALUES;
    private final String _name_lc = this.name().toLowerCase(Locale.ROOT);

    public String func_176610_l() {
        return this._name_lc;
    }

    public final String qualify(@Nonnull String context) {
        return this == ANY ? context : this._name_lc + "_" + context;
    }

    public static final TripleFrame unqualify(String s, boolean lenient) {
        if (s != null) {
            if (s.startsWith("less_")) {
                return LESS;
            }
            if (s.startsWith("mid_")) {
                return MID;
            }
            if (s.startsWith("more_")) {
                return MORE;
            }
            if (lenient) {
                if (s.startsWith("mild_")) {
                    return LESS;
                }
                if (s.startsWith("least_")) {
                    return LESS;
                }
                if (s.startsWith("very_")) {
                    return MORE;
                }
                if (s.startsWith("most_")) {
                    return MORE;
                }
                if (s.startsWith("extreme_")) {
                    return MORE;
                }
            }
        }
        return ANY;
    }

    public static final TripleFrame unqualify(String s) {
        return TripleFrame.unqualify(s, false);
    }

    public static final TripleFrame guess(int at, int total_amount) {
        int amt_per_tripleframe = total_amount / 3;
        if (at >= 0) {
            at %= total_amount;
        }
        return at < 0 ? ANY : (at < amt_per_tripleframe ? LESS : (at < 2 * amt_per_tripleframe ? MID : MORE));
    }

    static {
        COMPARATOR = new Comparator<TripleFrame>(){

            @Override
            public int compare(TripleFrame one, TripleFrame two) {
                if (one == null || two == null) {
                    throw new NullPointerException("triframe");
                }
                if (one == ANY || two == ANY) {
                    return 0;
                }
                return one.compareTo(two);
            }
        };
        _VALUES = TripleFrame.values();
    }
}

