/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.TemperatureRange;
import org.jwaresoftware.mcmods.lib.api.TimeFrame;

public enum WorldSeason implements IStringSerializable
{
    UNKNOWN("unknown", TextFormatting.BLACK),
    EARLY_HOT("spring", TextFormatting.YELLOW),
    HOT("summer", TextFormatting.RED),
    EARLY_COLD("autumn", TextFormatting.DARK_AQUA),
    COLD("winter", TextFormatting.BLUE);

    public static final WorldSeason SPRING;
    public static final WorldSeason SUMMER;
    public static final WorldSeason AUTUMN;
    public static final WorldSeason WINTER;
    private static final Map<String, WorldSeason> _VALUES;
    public static final WorldSeason[] EMPTY_ARRAY;
    public static final List<WorldSeason> SET4;
    public static final List<WorldSeason> SET2;
    public static final Detailed[] EMPTY_DETAIL_ARRAY;
    static final Map<String, Detailed> _DETAILED_VALUES;
    public static final Provider BY_84DAY_4SEASON_ALMANAC;
    public static final Provider BY_CONFIGURED_ALMANAC;
    private final String _name_lc = this.name().toLowerCase(Locale.ROOT);
    private final TextFormatting _color;
    private final String _common_name;

    private WorldSeason(String n2, TextFormatting c) {
        this._color = c;
        this._common_name = n2;
    }

    public int index() {
        return this.ordinal() - 1;
    }

    @Nonnull
    public String func_176610_l() {
        return this._name_lc;
    }

    public String toString() {
        return this._name_lc;
    }

    public boolean isKnown() {
        return this != UNKNOWN;
    }

    @Nonnull
    public TextFormatting getTipColor() {
        return this._color;
    }

    public final String commonName() {
        return this._common_name;
    }

    @Nonnull
    public final String getTranslationKey(String variant) {
        return LibInfo.lstring("season." + this.func_176610_l() + (variant == null || variant.isEmpty() ? "" : "." + variant));
    }

    @Nonnull
    public final String getTranslationKey() {
        return this.getTranslationKey("");
    }

    @Nullable
    public static final WorldSeason fromLString(String s) {
        return s != null ? _VALUES.get(s.toLowerCase(Locale.ROOT)) : null;
    }

    @Nonnull
    public static final WorldSeason fromFast(@Nonnull String s) {
        return _VALUES.getOrDefault(s, UNKNOWN);
    }

    @Nonnull
    public static final WorldSeason fromIndex(int index, int count) {
        List<WorldSeason> _SET = count == 2 ? SET2 : SET4;
        return index < 0 || index >= _SET.size() ? UNKNOWN : _SET.get(index);
    }

    @Nonnull
    public static final WorldSeason fromIndex(int index) {
        return index < 0 || index >= SET4.size() ? UNKNOWN : SET4.get(index);
    }

    public static final boolean isUnchanging(@Nonnull World w) {
        return w == null ? false : WorldSeason.isTheNetherOrTheEnd((RegistryKey<World>)w.func_234923_W_());
    }

    public static final boolean isTheNetherOrTheEnd(@Nonnull RegistryKey<World> w) {
        return w == World.field_234919_h_ || w == World.field_234920_i_;
    }

    @Nullable
    public static final WorldSeason getUnchangingSeason(IBiomeReader br, BlockPos at) {
        RegistryKey<Biome> biome;
        if (br instanceof World) {
            RegistryKey w = ((World)br).func_234923_W_();
            if (w == World.field_234919_h_) {
                return HOT;
            }
            if (w == World.field_234920_i_) {
                return COLD;
            }
        }
        if (Locations.inTheNether(biome = Locations.biomeKeyFor(br, at), br, at) || br.func_230315_m_().func_236040_e_()) {
            return HOT;
        }
        if (Locations.inTheEnd(biome, br, at)) {
            return COLD;
        }
        return null;
    }

    @Nonnull
    public static final WorldSeason fromBiome(IBiomeReader br, BlockPos at) {
        WorldSeason locked = WorldSeason.getUnchangingSeason(br, at);
        if (locked != null) {
            return locked;
        }
        RegistryKey<Biome> biome = Locations.biomeKeyFor(br, at);
        if (Locations.isOverworld((IWorldReader)br) || Locations.isBiomeLike(biome, BiomeDictionary.Type.OVERWORLD)) {
            Biome biome_obj = Locations.biomeFor(br, biome);
            float t = biome_obj.func_225486_c(at);
            TemperatureRange tempcat = TemperatureRange.match(t);
            if (tempcat == TemperatureRange.FREEZING || tempcat == TemperatureRange.COLD) {
                return COLD;
            }
            if (tempcat == TemperatureRange.BROILING || tempcat == TemperatureRange.WARM) {
                return HOT;
            }
            if (biome_obj.func_201850_b((IWorldReader)br, at)) {
                return EARLY_HOT;
            }
            return EARLY_COLD;
        }
        if (Locations.isBiomeLike(biome, BiomeDictionary.Type.HOT)) {
            return HOT;
        }
        if (Locations.isBiomeLike(biome, BiomeDictionary.Type.COLD)) {
            return COLD;
        }
        return UNKNOWN;
    }

    @Nonnull
    public static final Detailed[] deserialize_from(JsonElement json) throws JsonSyntaxException {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonPrimitive()) {
                String s = json.getAsString();
                if (Strings.isNoneValue(s, true)) {
                    return EMPTY_DETAIL_ARRAY;
                }
                Detailed season = Detailed.fromLString(s);
                if (season == null) {
                    throw new JsonSyntaxException("Unrecognized season '" + s + "'");
                }
                return (Detailed[])ArrayUtils.toArray((Object[])new Detailed[]{season});
            }
            if (json.isJsonArray()) {
                ArrayList choices = new ArrayList();
                json.getAsJsonArray().forEach(e -> {
                    String s = e.getAsString();
                    Detailed season = Detailed.fromLString(s);
                    if (season == null) {
                        throw new JsonSyntaxException("Unrecognized season '" + s + "'");
                    }
                    choices.add(season);
                });
                if (!choices.isEmpty()) {
                    return choices.toArray(EMPTY_DETAIL_ARRAY);
                }
            }
        }
        throw new JsonSyntaxException("At least one season must be defined");
    }

    static {
        SPRING = EARLY_HOT;
        SUMMER = HOT;
        AUTUMN = EARLY_COLD;
        WINTER = COLD;
        _VALUES = (Map)Util.func_200696_a(new HashMap(), m -> {
            for (WorldSeason s : WorldSeason.values()) {
                m.put(s._name_lc, s);
            }
            m.put("spring", EARLY_HOT);
            m.put("early_spring", EARLY_HOT);
            m.put("mid_spring", EARLY_HOT);
            m.put("late_spring", EARLY_HOT);
            m.put("late_wet", EARLY_HOT);
            m.put("summer", HOT);
            m.put("early_summer", HOT);
            m.put("mid_summer", HOT);
            m.put("late_summer", HOT);
            m.put("dry", HOT);
            m.put("early_dry", HOT);
            m.put("mid_dry", HOT);
            m.put("late_dry", HOT);
            m.put("autumn", EARLY_COLD);
            m.put("fall", EARLY_COLD);
            m.put("early_autumn", EARLY_COLD);
            m.put("mid_autumn", EARLY_COLD);
            m.put("late_autumn", EARLY_COLD);
            m.put("early_wet", EARLY_COLD);
            m.put("winter", COLD);
            m.put("early_winter", COLD);
            m.put("mid_winter", COLD);
            m.put("late_winter", COLD);
            m.put("wet", COLD);
        });
        EMPTY_ARRAY = new WorldSeason[0];
        SET4 = Collections.unmodifiableList((List)Util.func_200696_a(new ArrayList(), s -> {
            s.add(SPRING);
            s.add(SUMMER);
            s.add(AUTUMN);
            s.add(WINTER);
        }));
        SET2 = Collections.unmodifiableList((List)Util.func_200696_a(new ArrayList(), s -> {
            s.add(HOT);
            s.add(COLD);
        }));
        EMPTY_DETAIL_ARRAY = new Detailed[0];
        _DETAILED_VALUES = (Map)Util.func_200696_a(new HashMap(), m -> {
            Detailed d;
            for (WorldSeason s : WorldSeason.values()) {
                d = s == UNKNOWN ? Detailed.UNKNOWN : new Detailed(s);
                m.put(s._name_lc, d);
                m.putIfAbsent(s.commonName(), d);
            }
            m.put("early_spring", new Detailed(EARLY_HOT, TimeFrame.EARLY));
            m.put("mid_spring", new Detailed(EARLY_HOT, TimeFrame.MID));
            d = new Detailed(EARLY_HOT, TimeFrame.LATE);
            m.put("late_spring", d);
            m.put("late_wet", d);
            m.put("dry", m.get(HOT.func_176610_l()));
            d = new Detailed(HOT, TimeFrame.EARLY);
            m.put("early_summer", d);
            m.put("early_dry", d);
            d = new Detailed(HOT, TimeFrame.MID);
            m.put("mid_summer", d);
            m.put("mid_dry", d);
            d = new Detailed(HOT, TimeFrame.LATE);
            m.put("late_summer", d);
            m.put("late_dry", d);
            m.put("fall", m.get(EARLY_COLD.func_176610_l()));
            d = new Detailed(EARLY_COLD, TimeFrame.EARLY);
            m.put("early_autumn", d);
            m.put("early_wet", d);
            d = new Detailed(EARLY_COLD, TimeFrame.MID);
            m.put("mid_autumn", d);
            d = new Detailed(EARLY_COLD, TimeFrame.LATE);
            m.put("late_autumn", d);
            m.put("mid_wet", d);
            m.put("wet", m.get(COLD.func_176610_l()));
            d = new Detailed(COLD, TimeFrame.EARLY);
            m.put("early_winter", d);
            d = new Detailed(COLD, TimeFrame.MID);
            m.put("mid_winter", d);
            d = new Detailed(COLD, TimeFrame.LATE);
            m.put("late_winter", d);
        });
        BY_84DAY_4SEASON_ALMANAC = new FixedAlmanacProvider(-1, -1);
        BY_CONFIGURED_ALMANAC = new Provider(){

            @Override
            public boolean locationSensitive(@Nullable World w) {
                return LibConfig.__locationImportantToSeasonCompute();
            }

            @Override
            public long nowTicks(World w) {
                return SharedGlue.tickingTime(w) + (long)LibConfig.__day1TickOffset();
            }

            @Override
            public int getSeasonCount(World w) {
                return LibConfig.__seasonsPerAlmanacYear(w);
            }

            @Override
            public int getSeasonDays(World w) {
                return LibConfig.__daysPerSeason(w);
            }

            @Override
            public int getSeasonDaysOrDefault(World w) {
                int n = this.getSeasonDays(w);
                return n > 0 ? n : 4;
            }

            @Override
            public int getFullYearDays(World w) {
                return LibConfig.__daysPerAlmanacYear(w);
            }
        };
    }

    public static final class Detailed
    implements IStringSerializable,
    Comparable<Detailed> {
        @Nonnull
        public final WorldSeason season;
        @Nonnull
        public final TimeFrame timeframe;
        public static final Detailed UNKNOWN = new Detailed();

        private Detailed() {
            this(UNKNOWN, TimeFrame.ANY);
        }

        public Detailed(WorldSeason s) {
            this(s, TimeFrame.ANY);
        }

        public Detailed(WorldSeason s, TimeFrame w) {
            this.season = s == null ? UNKNOWN : s;
            this.timeframe = w == null ? TimeFrame.ANY : w;
        }

        public final boolean isUnknown() {
            return this == UNKNOWN || this.season == UNKNOWN;
        }

        public final boolean isAny() {
            return !this.isUnknown() && this.timeframe == TimeFrame.ANY;
        }

        @Override
        public int compareTo(Detailed other) {
            if (other == null) {
                throw new NullPointerException("season.detail");
            }
            if (other == this) {
                return 0;
            }
            if (this.isUnknown()) {
                return other.isUnknown() ? 0 : -1;
            }
            int wc = this.season.compareTo(other.season);
            if (wc != 0) {
                return wc;
            }
            return TimeFrame.COMPARATOR.compare(this.timeframe, other.timeframe);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() == Detailed.class) {
                return this.compareTo((Detailed)o) == 0;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.season, this.timeframe});
        }

        @Nonnull
        public String func_176610_l() {
            return this.timeframe.qualify(this.season.commonName());
        }

        public String toString() {
            return this.func_176610_l();
        }

        @Nullable
        public static final Detailed fromLString(String s) {
            return s != null ? _DETAILED_VALUES.get(s.toLowerCase(Locale.ROOT)) : null;
        }
    }

    public static class FixedAlmanacProvider
    implements Provider {
        private final int _seasonCount;
        private final int _seasonDays;

        public FixedAlmanacProvider(int seasonCount, int seasonDays) {
            this._seasonCount = seasonCount;
            this._seasonDays = seasonDays;
        }

        @Override
        public int getSeasonCount(World w) {
            return this._seasonCount > 0 ? this._seasonCount : 4;
        }

        @Override
        public int getSeasonDays(World w) {
            return this._seasonDays > 0 ? this._seasonDays : (this._seasonCount == 1 ? 336 : 84);
        }
    }

    @ParametersAreNonnullByDefault
    public static interface Provider
    extends BiFunction<World, BlockPos, WorldSeason> {
        default public void initConfigured(MinecraftServer minecraft) {
        }

        @Nonnull
        default public RegistryKey<World> bestID(@Nullable World w) {
            return w == null ? World.field_234918_g_ : w.func_234923_W_();
        }

        default public boolean locationSensitive(@Nullable World w) {
            return false;
        }

        @Nonnull
        default public BlockPos positionZero(World w) {
            return this.locationSensitive(w) ? Locations.getSpawnPoint(w) : BlockPos.field_177992_a;
        }

        default public long nowTicks(World w) {
            return SharedGlue.tickingTime(w);
        }

        default public int ticksPerFullDay(RegistryKey<World> w) {
            return LibConfig.__ticksPerFullDay((RegistryKey<World>)(w != null ? w : World.field_234918_g_));
        }

        default public int ticksInDaytime(RegistryKey<World> w) {
            return LibConfig.__ticksInDaytime((RegistryKey<World>)(w != null ? w : World.field_234918_g_));
        }

        public int getSeasonCount(World var1);

        public int getSeasonDays(World var1);

        default public int getSeasonDaysOrDefault(World w) {
            return this.getSeasonDays(w);
        }

        @Nonnull
        default public WorldSeason getSeason(World w) {
            return this.apply(w, this.positionZero(w));
        }

        @Nonnull
        default public WorldSeason getSeason(World w, BlockPos at) {
            return this.apply(w, at);
        }

        default public int getFullYearDays(World w) {
            return this.getSeasonCount(w) * this.getSeasonDays(w);
        }

        default public String translationKey(@Nullable World w, WorldSeason s) {
            return s.getTranslationKey("common");
        }

        @Nonnull
        default public TemperatureRange getTemperature(World w, BlockPos at) {
            return TemperatureRange.match(Locations.biomeFor((IBiomeReader)w, Locations.biomeKeyFor((IBiomeReader)w, at)).func_225486_c(at));
        }

        @Override
        @Nonnull
        default public WorldSeason apply(World w, BlockPos p) {
            WorldSeason locked = WorldSeason.getUnchangingSeason((IBiomeReader)w, p);
            if (locked != null) {
                return locked;
            }
            int elapsedDays = (int)(this.nowTicks(w) / (long)this.ticksPerFullDay(this.bestID(w)));
            int N = this.getSeasonCount(w);
            return WorldSeason.fromIndex(elapsedDays / this.getSeasonDays(w) % N, N);
        }

        default public boolean hasDetailedSeasons() {
            return false;
        }

        @Nonnull
        default public Detailed getDetailedSeason(World w, BlockPos at) {
            return new Detailed(this.apply(w, at));
        }
    }

    public static final class ConstantSeasonProvider
    extends FixedAlmanacProvider {
        private final WorldSeason _season;

        public static final ConstantSeasonProvider of(@Nonnull WorldSeason season) {
            return new ConstantSeasonProvider(Objects.requireNonNull(season, "A season is required"), -1);
        }

        public static final ConstantSeasonProvider of(@Nonnull WorldSeason season, int yearDays) {
            return new ConstantSeasonProvider(Objects.requireNonNull(season, "A season is required"), yearDays);
        }

        @Override
        public final WorldSeason apply(World w, BlockPos at) {
            return this._season;
        }

        private ConstantSeasonProvider(WorldSeason season, int yearDays) {
            super(1, yearDays);
            this._season = season;
        }
    }
}

