/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api.combat;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;

public final class ProjectileTweaks {
    public boolean enabled;
    public float inaccuracyImprovement;
    public float velocityAdjustment;
    public float damageIncrease;
    public int knockbackStrength;
    public int flameStrength = -1;
    public boolean infiniteFlag;
    public boolean ghostMode;
    public boolean waterProof;
    public boolean ethereal;
    public static final ProjectileTweaks EMPTY = new ProjectileTweaks();

    public ProjectileTweaks() {
    }

    public ProjectileTweaks(ProjectileTweaks from) {
        if (this != EMPTY && from != null) {
            this.enabled = from.enabled;
            this.infiniteFlag = from.infiniteFlag;
            this.ghostMode = from.ghostMode;
            this.ethereal = from.ethereal;
            this.waterProof = from.waterProof;
            this.inaccuracyImprovement = from.inaccuracyImprovement;
            this.velocityAdjustment = from.velocityAdjustment;
            this.damageIncrease = from.damageIncrease;
            this.knockbackStrength = from.knockbackStrength;
            this.flameStrength = from.flameStrength;
        }
    }

    public final boolean isEnabled() {
        return this.enabled && this != EMPTY;
    }

    public final boolean isUndefined() {
        return this == EMPTY || this.inaccuracyImprovement == 0.0f && this.velocityAdjustment == 0.0f && this.damageIncrease == 0.0f && this.knockbackStrength == 0 && this.flameStrength < 0;
    }

    public final boolean hasFlame() {
        return this.flameStrength > 0;
    }

    public final boolean fromInfiniteSource() {
        return this.infiniteFlag;
    }

    public final boolean isWaterproof() {
        return this.waterProof;
    }

    public final boolean asGhost() {
        return this.ghostMode;
    }

    public final boolean asGhost(boolean etherealCheck) {
        return this.ghostMode || etherealCheck && this.ethereal;
    }

    public final boolean isPowered() {
        return this.damageIncrease > 0.0f;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        if (this.isEnabled() || !this.isUndefined()) {
            nbt.func_74757_a("Enabled", this.enabled);
            nbt.func_74757_a("Infinite", this.infiniteFlag);
            nbt.func_74757_a("Ethereal", this.ethereal);
            nbt.func_74757_a("Ghost", this.ghostMode);
            nbt.func_74757_a("Waterproof", this.waterProof);
            nbt.func_74776_a("Inaccuracy", this.inaccuracyImprovement);
            nbt.func_74776_a("Velocity", this.velocityAdjustment);
            nbt.func_74776_a("Damage", this.damageIncrease);
            nbt.func_74768_a("Knockback", this.knockbackStrength);
            nbt.func_74768_a("Flame", this.flameStrength);
        }
        return nbt;
    }

    public void readFromNBT(CompoundNBT nbt) {
        if (this != EMPTY) {
            this.enabled = nbt.func_74767_n("Enabled");
            this.infiniteFlag = nbt.func_74767_n("Infinite");
            this.ethereal = nbt.func_74767_n("Ethereal");
            this.ghostMode = nbt.func_74767_n("Ghost");
            this.waterProof = nbt.func_74767_n("Waterproof");
            if (nbt.func_74764_b("Inaccuracy")) {
                this.inaccuracyImprovement = nbt.func_74760_g("Inaccuracy");
            }
            if (nbt.func_74764_b("Velocity")) {
                this.velocityAdjustment = nbt.func_74760_g("Velocity");
            }
            if (nbt.func_74764_b("Damage")) {
                this.damageIncrease = nbt.func_74760_g("Damage");
            }
            if (nbt.func_74764_b("Knockback")) {
                this.knockbackStrength = nbt.func_74762_e("Knockback");
            }
            if (nbt.func_74764_b("Flame")) {
                this.flameStrength = nbt.func_74762_e("Flame");
            }
        }
    }

    public static ProjectileTweaks loadFrom(CompoundNBT nbt) {
        if (nbt != null && nbt.func_186856_d() > 0) {
            ProjectileTweaks tweaks = new ProjectileTweaks();
            tweaks.readFromNBT(nbt);
            if (tweaks.isEnabled() || !tweaks.isUndefined()) {
                return tweaks;
            }
        }
        return EMPTY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("E:" + (this.enabled ? "T" : "F")).append(",X:").append(this.infiniteFlag ? "T" : "F").append(",");
        sb.append("G:").append(this.ghostMode ? "T" : "F").append(",");
        sb.append("g:").append(this.ethereal ? "t" : "F").append(",");
        sb.append("W:").append(this.waterProof ? "T" : "F").append(",");
        sb.append("I:" + String.format("%.2f", Float.valueOf(this.inaccuracyImprovement))).append(",");
        sb.append("V:" + String.format("%.2f", Float.valueOf(this.velocityAdjustment))).append(",");
        sb.append("D:" + String.format("%.2f", Float.valueOf(this.damageIncrease))).append(",");
        sb.append("K:" + this.knockbackStrength).append(",");
        sb.append("F:" + (this.hasFlame() ? "T" : "F"));
        return sb.toString();
    }

    public static final ProjectileTweaks safe(@Nullable ProjectileTweaks tweaks) {
        return tweaks == null ? EMPTY : tweaks;
    }
}

