/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api.mod;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.BooleanUtils;
import org.jwaresoftware.mcmods.lib.Strings;

public enum FlexibleBoolean {
    FALSE("false"),
    TRUE("true"),
    DEFAULT("*DEFAULT*");

    public static final Collection<String> ACCEPTABLE_VALUES;
    private final String _value_lc;

    private FlexibleBoolean(String id) {
        this._value_lc = id;
    }

    public String setting() {
        return this._value_lc;
    }

    public boolean isDefined() {
        return this == TRUE || this == FALSE;
    }

    public static final boolean isDefined(@Nullable FlexibleBoolean v) {
        return v != null && v.isDefined();
    }

    public boolean asbool() {
        return this == TRUE;
    }

    public static final boolean asbool(@Nullable FlexibleBoolean v, boolean d) {
        return FlexibleBoolean.isDefined(v) ? v.asbool() : d;
    }

    public static final ForgeConfigSpec.ConfigValue<String> define(String name, ForgeConfigSpec.Builder sb) {
        return sb.defineInList(name, (Object)DEFAULT.setting(), ACCEPTABLE_VALUES);
    }

    @Nullable
    public static final FlexibleBoolean fromLString(String s) {
        if (s != null) {
            if (Strings.isDefaultValue(s, false)) {
                return DEFAULT;
            }
            Boolean b = BooleanUtils.toBooleanObject((String)s);
            if (b == Boolean.TRUE) {
                return TRUE;
            }
            if (b == Boolean.FALSE) {
                return FALSE;
            }
        }
        return null;
    }

    @Nullable
    public static final FlexibleBoolean from(@Nullable Boolean b, @Nullable FlexibleBoolean null_value) {
        return b == null ? null_value : (Boolean.TRUE.equals(b) ? TRUE : FALSE);
    }

    @Nullable
    public static final FlexibleBoolean from(@Nullable Boolean b) {
        return FlexibleBoolean.from(b, null);
    }

    static {
        ACCEPTABLE_VALUES = Collections.unmodifiableList(Arrays.asList("false", "true", "*DEFAULT*"));
    }
}

