/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.api.mod;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.mod.IModConfig;

public interface IModRuntime {
    public static final String UI = "ui";

    public void beforeStartUp();

    default public void earlyStartUp(ModLifecycleEvent e) {
    }

    default public void midStartUp(ModLifecycleEvent e) {
    }

    default public void lateStartUp(ModLifecycleEvent e) {
    }

    default public void commandsStartUp(RegisterCommandsEvent e) {
    }

    public void afterStartUp();

    default public void shutDown() {
    }

    default public boolean hasUI() {
        return false;
    }

    @Nullable
    default public Boolean isEnabled(String id) {
        return UI.equals(id) ? Boolean.valueOf(this.hasUI()) : null;
    }

    default public void setStartedFully() {
    }

    @Nonnull
    public String getId();

    @Nonnull
    public Random getPRNG();

    @Nonnull
    public Logger getLog();

    @Nonnull
    public <T extends IModConfig> T getConfig();

    @Nullable
    default public ItemGroup getOwnedTab() {
        return null;
    }

    default public void setOwnedTab(@Nonnull ItemGroup tab) {
    }

    default public void reloadConfig() {
    }

    default public void setupModdedLootTables(@Nonnull MinecraftServer server) {
    }

    default public boolean isaMasterLocksmith(PlayerEntity player, @Nullable String op) {
        return SharedGlue.isaRealNonSpectatingPlayer((Entity)player) && this.getConfig().hasLocksmithACL(player.func_130014_f_());
    }

    default public void sendPlayerMessage(PlayerEntity player, boolean important, ITextComponent message) {
        if (SharedGlue.isaServerWorld((Entity)player)) {
            player.func_145747_a(message, Util.field_240973_b_);
        }
    }

    default public void sendPlayerMessage(PlayerEntity player, boolean important, String formattedText, Object ... args) {
        this.sendPlayerMessage(player, important, (ITextComponent)new TranslationTextComponent(formattedText, args));
    }

    default public void sendPlayerMessage(PlayerEntity player, @Nonnull List<ITextComponent> message) {
        if (SharedGlue.isaServerWorld((Entity)player) && !message.isEmpty()) {
            for (ITextComponent message_line : message) {
                player.func_145747_a(message_line, Util.field_240973_b_);
            }
        }
    }

    default public void setRuntimeServer(MinecraftServer server) {
    }

    @Nullable
    default public MinecraftServer getRuntimeServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }

    @Nullable
    default public PlayerEntity getClientPlayer() {
        throw new WrongSideException("No client playr on " + this.getId());
    }

    @Nullable
    default public World getClientWorld() {
        throw new WrongSideException("No client world on " + this.getId());
    }

    default public PlayerEntity getPlayer(NetworkEvent.Context context) {
        if (context.getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            return context.getSender();
        }
        throw new WrongSideException("Tried to get player from a client-side on " + this.getId());
    }

    public static class WrongSideException
    extends RuntimeException {
        public WrongSideException(String message) {
            super(message);
        }

        public WrongSideException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

