/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.barter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.barter.OwnableToken;
import org.jwaresoftware.mcmods.lib.capability.IGradeable;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;

public class BarterToken
extends OwnableToken
implements IGradeable,
IVariant {
    public static final int NO_RATE = -1;
    static final List<BarterToken> _LOOTABLES = new ArrayList<BarterToken>(10);
    @Nonnull
    protected final QualityGrade _quality_grade;
    protected int _exchange_rate = -1;

    public BarterToken(@Nonnull String gid, @Nonnull String oid, @Nonnull QualityGrade g, boolean hidden, @Nullable Item.Properties ip) {
        super(gid, oid, hidden, ip);
        this._quality_grade = Objects.requireNonNull(g);
    }

    public BarterToken(@Nonnull String oid, @Nonnull QualityGrade g, boolean hidden, Item.Properties ip) {
        super(oid, hidden, ip);
        this._quality_grade = Objects.requireNonNull(g);
    }

    public BarterToken(String oid, @Nonnull QualityGrade g) {
        super(oid);
        this._quality_grade = Objects.requireNonNull(g);
    }

    public BarterToken(String oid, @Nonnull QualityGrade g, boolean hidden) {
        super(oid, hidden);
        this._quality_grade = Objects.requireNonNull(g);
    }

    public BarterToken(String gid, String oid, @Nonnull QualityGrade g) {
        super(gid, oid);
        this._quality_grade = Objects.requireNonNull(g);
    }

    protected BarterToken(String oid) {
        this(oid, QualityGrade.UNKNOWN);
    }

    protected BarterToken(@Nonnull String oid, boolean hidden, @Nullable Item.Properties ip) {
        super(oid, hidden, ip);
        this._quality_grade = QualityGrade.UNKNOWN;
    }

    public static final boolean isa(ItemStack source) {
        return !ItemStacks.isEmpty(source) && source.func_77973_b() instanceof BarterToken;
    }

    public static final boolean like(ItemStack source) {
        return BarterToken.isa(source) || source.func_77973_b().func_206844_a(RID.Tags.BARTER_TOKENS);
    }

    protected List<BarterToken> getLootables() {
        return this.getClass() == BarterToken.class ? _LOOTABLES : Collections.EMPTY_LIST;
    }

    @Override
    public String varid() {
        return this.oid();
    }

    @Override
    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(10);
        for (BarterToken token : this.getLootables()) {
            out.add(ItemStacks.create(token));
        }
        return out;
    }

    @Override
    @Nonnull
    public QualityGrade getQualityGrade(ItemStack token) {
        return this._quality_grade.isKnown() ? this._quality_grade : IGradeable.super.getQualityGrade(token);
    }

    public final int getDefaultExchangeRate() {
        return this._exchange_rate;
    }

    public final void setDefaultExchangeRate(int x) {
        this._exchange_rate = x;
    }

    public static final boolean isaEnchantableToken(ItemStack source) {
        return BarterToken.isa(source) && ((BarterToken)source.func_77973_b()).getQualityGrade(source).isEqualOrBetter(QualityGrade.BASE);
    }

    public boolean func_77616_k(ItemStack source) {
        return BarterToken.isaEnchantableToken(source);
    }

    public int getItemEnchantability(ItemStack token) {
        QualityGrade qg = this.getQualityGrade(token);
        return qg.isEqualOrBetter(QualityGrade.GOLD) ? ItemTier.GOLD.func_200927_e() * qg.multiplierTier(QualityGrade.GOLD) : (qg.isEqualOrBetter(QualityGrade.BASE) ? ItemTier.STONE.func_200927_e() * qg.multiplierTier(QualityGrade.BASE) : 0);
    }

    public boolean canApplyAtEnchantingTable(ItemStack token, Enchantment e) {
        return e == Enchantments.field_185308_t || e == Enchantments.field_151370_z || e == Enchantments.field_185304_p || e == Enchantments.field_190940_C;
    }

    public boolean isBookEnchantable(ItemStack token, ItemStack book) {
        return false;
    }
}

