/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.barter;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.impl.ItemBase;

public abstract class OwnableToken
extends ItemBase
implements ILootedListener {
    protected OwnableToken(@Nonnull String gid, @Nonnull String oid, boolean hidden, @Nullable Item.Properties ip) {
        super(gid, oid, hidden, ip);
    }

    protected OwnableToken(@Nonnull String oid, boolean hidden, @Nullable Item.Properties ip) {
        super("trading", oid, hidden, ip);
    }

    protected OwnableToken(String oid) {
        this(oid, false, null);
    }

    protected OwnableToken(String oid, boolean hidden) {
        this(oid, hidden, null);
    }

    protected OwnableToken(String gid, String oid) {
        this(gid, oid, false, null);
    }

    public String func_77667_c(ItemStack token) {
        String i18n = super.func_77667_c(token);
        String from = ItemStacks.getString(token, "barter:modid");
        return from.isEmpty() ? i18n : i18n + "." + from;
    }

    public void func_77622_d(ItemStack token, World unused, @Nullable PlayerEntity player) {
        if (player == null) {
            Instructions.clearOwner(token);
        } else if (Instructions.setOwner(token, player, false)) {
            Instructions.setCrafted(token);
        }
        this.onCookedOrCrafted(token);
    }

    @Override
    public void notifyLooted(@Nonnull ItemStack token, @Nonnull World world, @Nonnull PlayerEntity player, float luckLevel, @Nullable String context) {
        Instructions.setOwner(token, player, true);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack token, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        Tooltips.addOwnerTip(token, tooltip);
        super.func_77624_a(token, world, tooltip, flags);
    }
}

