/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.capability;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;

public interface IGradeable {
    public static final String PROPERTY_QGRADE = "qgrade";
    public static final String NBT_QGRADE = LibInfo.rstring("QGrade");

    @Nonnull
    default public QualityGrade getQualityGrade(ItemStack source) {
        return QualityGradePropertyGetter.getFromTag(source);
    }

    public static final class QualityGradePropertyGetter {
        private QualityGradePropertyGetter() {
        }

        public static final boolean hasTag(ItemStack stack) {
            return !ItemStacks.isEmpty(stack) && ItemStacks.hasString(stack, NBT_QGRADE);
        }

        @Nonnull
        public static final QualityGrade getFromTag(ItemStack stack) {
            QualityGrade out = QualityGrade.UNKNOWN;
            if (QualityGradePropertyGetter.hasTag(stack)) {
                String s = ItemStacks.getString(stack, NBT_QGRADE);
                out = QualityGrade.findOrUnknown(s);
            }
            return out;
        }

        public static final boolean has(ItemStack stack) {
            return stack != null && (QualityGradePropertyGetter.hasTag(stack) || stack.func_77973_b() instanceof IGradeable);
        }

        @Nonnull
        public static final QualityGrade getFrom(ItemStack stack) {
            QualityGrade out = QualityGrade.UNKNOWN;
            if (!ItemStacks.isEmpty(stack)) {
                if (stack.func_77973_b() instanceof IGradeable) {
                    IGradeable cap = (IGradeable)stack.func_77973_b();
                    out = Objects.requireNonNull(cap.getQualityGrade(stack));
                } else {
                    out = QualityGradePropertyGetter.getFromTag(stack);
                }
            }
            return out;
        }

        public static final ItemStack setToTag(ItemStack stack, @Nullable QualityGrade grade) {
            grade = QualityGrade.sameOrUnknown(grade);
            ItemStacks.setString(stack, NBT_QGRADE, grade.func_176610_l());
            return stack;
        }

        public static final ItemStack scrub(ItemStack stack) {
            if (!stack.func_190926_b() && stack.func_77942_o()) {
                ItemStacks.removeData(stack, NBT_QGRADE, true);
                CompoundNBT instr = Instructions.get(stack);
                if (instr != null && instr.func_74764_b(NBT_QGRADE)) {
                    instr.func_82580_o(NBT_QGRADE);
                    if (instr.isEmpty()) {
                        Instructions.remove(stack);
                    }
                }
            }
            return stack;
        }
    }
}

