/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICraftedStorage;

public final class CraftedStorageSupport {
    public static final ICraftedStorage UNKNOWN = new ICraftedStorage(){

        @Override
        public ICraftedStorage.Type storedType() {
            return ICraftedStorage.Type.GENERAL;
        }

        @Override
        public int quantityStored(ItemStack unused, PlayerEntity unused1) {
            return -1;
        }

        @Override
        public int quantityStored(BlockState unused, PlayerEntity unused1) {
            return -1;
        }
    };

    public static final ICraftedStorage forItem(int n) {
        switch (n) {
            case 0: 
            case 9: {
                return ForItem.PACK9;
            }
            case 8: {
                return ForItem.PACK8;
            }
            case 6: {
                return ForItem.PACK6;
            }
            case 4: {
                return ForItem.PACK4;
            }
            case 3: {
                return ForItem.PACK3;
            }
        }
        return n < 0 ? ForItem.PACK4 : new ForItem(n);
    }

    public static final ICraftedStorage forBlock(int n) {
        switch (n) {
            case 0: 
            case 9: {
                return ForBlock.PACK9;
            }
            case 8: {
                return ForBlock.PACK8;
            }
            case 6: {
                return ForBlock.PACK6;
            }
            case 4: {
                return ForBlock.PACK4;
            }
        }
        return n < 0 ? ForBlock.PACK9 : new ForBlock(n);
    }

    private CraftedStorageSupport() {
    }

    public static class ForItem
    implements ICraftedStorage {
        private final int _size;
        public static final ForItem PACK9 = new ForItem(9);
        public static final ForItem PACK8 = new ForItem(8);
        public static final ForItem PACK6 = new ForItem(6);
        public static final ForItem PACK4 = new ForItem();
        public static final ForItem PACK3 = new ForItem(3);
        public static final ForItem BULK_STACK = new ForItem(SharedGlue.MAX_STACK_SIZE());
        public static final ForItem LARGE_STACK = new ForItem(SharedGlue.MAX_STACK_SIZE() >> 1);
        public static final ForItem MEDIUM_STACK = new ForItem(SharedGlue.MAX_STACK_SIZE() >> 2);
        public static final ForItem SMALL_STACK = new ForItem(SharedGlue.MAX_STACK_SIZE() >> 3);
        public static final ForItem TINY_STACK = new ForItem(SharedGlue.MAX_STACK_SIZE() >> 4);

        public ForItem(int size) {
            this._size = size;
        }

        public ForItem() {
            this(SharedGlue.PLAYER_CRAFT_GRID_SIZE());
        }

        @Override
        public ICraftedStorage.Type storedType() {
            return ICraftedStorage.Type.ITEM;
        }

        @Override
        public int quantityStored(ItemStack stack, PlayerEntity unused) {
            return this._size * (stack != null ? ItemStacks.getSize(stack) : 1);
        }

        @Override
        public int quantityStored(BlockState block, PlayerEntity unused) {
            return -1;
        }
    }

    public static class ForBlock
    implements ICraftedStorage {
        private final int _size;
        public static final ForBlock PACK9 = new ForBlock();
        public static final ForBlock PACK8 = new ForBlock(8);
        public static final ForBlock PACK6 = new ForBlock(6);
        public static final ForBlock PACK4 = new ForBlock(4);

        public ForBlock(int size) {
            this._size = size;
        }

        public ForBlock() {
            this(SharedGlue.TABLE_CRAFT_GRID_SIZE());
        }

        @Override
        public ICraftedStorage.Type storedType() {
            return ICraftedStorage.Type.ITEM;
        }

        @Override
        public int quantityStored(ItemStack stack, PlayerEntity unused) {
            return this._size * (stack != null ? ItemStacks.getSize(stack) : 1);
        }

        @Override
        public int quantityStored(BlockState block, PlayerEntity unused) {
            return this._size;
        }
    }
}

