/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.StubbornPotionEffect;
import org.jwaresoftware.mcmods.lib.api.IModPotionEffect;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;

public abstract class EffectBase
extends Effect
implements IModPotionEffect {
    protected static final int _1SEC_TICKS = SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER();
    protected static final int _CONSTANT = _1SEC_TICKS >> 2;
    protected static final int _MORE_OFTEN = _1SEC_TICKS >> 1;
    protected static final int _OFTEN = _1SEC_TICKS;
    protected static final int _LESS_OFTEN = 2 * _1SEC_TICKS;
    protected static final int _SHARE_COOLDOWN = 10 * _1SEC_TICKS;
    protected final String _oid;
    protected final boolean _milkFlag;
    private boolean _visible;
    protected ResourceLocation _icon;
    private final String _translationKey;
    protected Item _vinegarCurative;

    protected EffectBase(IModInfo mod, String name, boolean visible, EffectType type, int particleColor, boolean milkCures) {
        super(type, particleColor);
        this._oid = name;
        this._visible = visible;
        this._icon = new ResourceLocation(mod.mod_id(), "textures/mob_effect/" + name + ".png");
        this._milkFlag = milkCures;
        String ns = mod.itemid_prefix();
        if (ns.isEmpty()) {
            ns = mod.mod_id() + ".";
        }
        this._translationKey = "potion." + ns + name;
        this.setRegistryName(new ResourceLocation(mod.mod_id(), name));
    }

    protected EffectBase(IModInfo mod, String name, boolean visible, boolean bad, int particleColor, boolean milkCures) {
        this(mod, name, visible, bad ? EffectType.HARMFUL : EffectType.BENEFICIAL, particleColor, milkCures);
    }

    protected EffectBase(IModInfo mod, String name, boolean bad, int particleColor) {
        this(mod, name, true, bad, particleColor, true);
    }

    @Override
    public final String oid() {
        return this._oid;
    }

    protected String func_210758_b() {
        return this._translationKey;
    }

    @Override
    public final boolean isHiddenByDefault() {
        return !this._visible;
    }

    public boolean shouldRender(EffectInstance effect) {
        return !this.isHiddenByDefault();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderInventoryEffect(EffectInstance effect, DisplayEffectsScreen<?> gui, MatrixStack ms, int x, int y, float z) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this._icon);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)(x + 6), (int)(y + 7), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderHUDEffect(EffectInstance effect, AbstractGui gui, MatrixStack ms, int x, int y, float z, float alpha) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this._icon);
        AbstractGui.func_238463_a_((MatrixStack)ms, (int)(x + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void addPotionInformation(@Nonnull List<ITextComponent> tooltip, int duration, boolean full, boolean indent) {
        EffectInstance instance = new EffectInstance((Effect)this, duration);
        Potions.addPotionInformation(Collections.singletonList(instance), tooltip, 0, full, indent);
    }

    public List<ItemStack> getCurativeItems() {
        if (this._milkFlag) {
            return LibConfig.getMilkBuckets();
        }
        if (this.vinegarCures()) {
            return Lists.newArrayList((Object[])new ItemStack[]{ItemStacks.create(this._vinegarCurative)});
        }
        return new ArrayList<ItemStack>();
    }

    public int clampedAmplifier(int amplifier) {
        return MathHelper.func_76125_a((int)amplifier, (int)0, (int)4);
    }

    public int clampedDuration(int duration) {
        return MathHelper.func_76125_a((int)duration, (int)0, (int)StubbornPotionEffect._MAX_EXTENDED_DURATION);
    }

    protected final boolean isReady(int cooldown_ticks, int duration_ticks, int amplifier) {
        int i = cooldown_ticks >> this.clampedAmplifier(amplifier);
        return i > 0 ? duration_ticks % i == 0 : true;
    }

    public void func_76394_a(LivingEntity target, int amplifier) {
    }

    public void func_111185_a(LivingEntity target, AttributeModifierManager attrs, int amplifier) {
        super.func_111185_a(target, attrs, this.clampedAmplifier(amplifier));
    }

    public void func_111187_a(LivingEntity target, AttributeModifierManager attrs, int amplifier) {
        super.func_111187_a(target, attrs, this.clampedAmplifier(amplifier));
    }

    public boolean vinegarCures() {
        return !this._milkFlag && SharedGlue.isDefined(this._vinegarCurative);
    }

    protected static final boolean showSharedEffectParticles(LivingEntity on) {
        return !SharedGlue.isaPlayer((Entity)on) || LibConfig.sharedEffectIsVisible();
    }
}

