/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import com.google.common.collect.Maps;
import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.UnbreakingEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.advancements.CraftedItemTrigger;
import org.jwaresoftware.mcmods.lib.advancements.HarvestedTrigger;
import org.jwaresoftware.mcmods.lib.advancements.PlayerEarnedTrigger;
import org.jwaresoftware.mcmods.lib.api.IBlockItem;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.impl.FoodItemBase;

public class ItemSupport {
    public static final String _DINK = "x";
    public static final Food CRUMB = new Food.Builder().func_221456_a(1).func_221454_a(0.05f).func_221457_c().func_221455_b().func_221453_d();
    public static final Map<DyeColor, Supplier<Block>> WOOL_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, () -> Blocks.field_196556_aL);
        map.put(DyeColor.ORANGE, () -> Blocks.field_196557_aM);
        map.put(DyeColor.MAGENTA, () -> Blocks.field_196558_aN);
        map.put(DyeColor.LIGHT_BLUE, () -> Blocks.field_196559_aO);
        map.put(DyeColor.YELLOW, () -> Blocks.field_196560_aP);
        map.put(DyeColor.LIME, () -> Blocks.field_196561_aQ);
        map.put(DyeColor.PINK, () -> Blocks.field_196562_aR);
        map.put(DyeColor.GRAY, () -> Blocks.field_196563_aS);
        map.put(DyeColor.LIGHT_GRAY, () -> Blocks.field_196564_aT);
        map.put(DyeColor.CYAN, () -> Blocks.field_196565_aU);
        map.put(DyeColor.PURPLE, () -> Blocks.field_196566_aV);
        map.put(DyeColor.BLUE, () -> Blocks.field_196567_aW);
        map.put(DyeColor.BROWN, () -> Blocks.field_196568_aX);
        map.put(DyeColor.GREEN, () -> Blocks.field_196569_aY);
        map.put(DyeColor.RED, () -> Blocks.field_196570_aZ);
        map.put(DyeColor.BLACK, () -> Blocks.field_196602_ba);
    });
    public static final Map<DyeColor, Supplier<Block>> GLASS_BY_COLOR = (Map)Util.func_200696_a((Object)Maps.newEnumMap(DyeColor.class), map -> {
        map.put(DyeColor.WHITE, () -> Blocks.field_196807_gj);
        map.put(DyeColor.ORANGE, () -> Blocks.field_196808_gk);
        map.put(DyeColor.MAGENTA, () -> Blocks.field_196809_gl);
        map.put(DyeColor.LIGHT_BLUE, () -> Blocks.field_196810_gm);
        map.put(DyeColor.YELLOW, () -> Blocks.field_196811_gn);
        map.put(DyeColor.LIME, () -> Blocks.field_196812_go);
        map.put(DyeColor.PINK, () -> Blocks.field_196813_gp);
        map.put(DyeColor.GRAY, () -> Blocks.field_196815_gq);
        map.put(DyeColor.LIGHT_GRAY, () -> Blocks.field_196816_gr);
        map.put(DyeColor.CYAN, () -> Blocks.field_196818_gs);
        map.put(DyeColor.PURPLE, () -> Blocks.field_196819_gt);
        map.put(DyeColor.BLUE, () -> Blocks.field_196820_gu);
        map.put(DyeColor.BROWN, () -> Blocks.field_196821_gv);
        map.put(DyeColor.GREEN, () -> Blocks.field_196822_gw);
        map.put(DyeColor.RED, () -> Blocks.field_196823_gx);
        map.put(DyeColor.BLACK, () -> Blocks.field_196824_gy);
    });
    private static Field _maxstackField = null;
    private static Field _containerItemField = null;
    private static Field _maxdamageField = null;
    private static Field _alwaysEdibleField;

    public static final String defaultTranslationKey(Item item) {
        String out = _DINK;
        if (item instanceof IModItem) {
            ResourceLocation rid;
            IModItem moditem = (IModItem)item;
            ResourceLocation resourceLocation = rid = ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item) ? ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item) : null;
            if (moditem.itemid_prefix().isEmpty()) {
                out = rid != null ? Util.func_200697_a((String)"item", (ResourceLocation)rid) : Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation("generic", moditem.oid()));
            } else {
                String prefix = moditem.itemid_prefix();
                if (prefix.endsWith("_")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                out = rid != null ? Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation(prefix, rid.func_110623_a())) : Util.func_200697_a((String)"item", (ResourceLocation)new ResourceLocation(prefix, moditem.oid()));
            }
        }
        return out;
    }

    public static final String defaultTranslationKey(Block block) {
        String out = _DINK;
        if (block instanceof IModBlock) {
            ResourceLocation rid;
            IModBlock modblock = (IModBlock)block;
            ResourceLocation resourceLocation = rid = ForgeRegistries.BLOCKS.containsValue((IForgeRegistryEntry)block) ? ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block) : null;
            if (modblock.itemid_prefix().isEmpty()) {
                out = rid != null ? Util.func_200697_a((String)"block", (ResourceLocation)rid) : Util.func_200697_a((String)"block", (ResourceLocation)new ResourceLocation("generic", modblock.oid()));
            } else {
                String prefix = modblock.itemid_prefix();
                if (prefix.endsWith("_")) {
                    prefix = prefix.substring(0, prefix.length() - 1);
                }
                out = rid != null ? Util.func_200697_a((String)"block", (ResourceLocation)new ResourceLocation(prefix, rid.func_110623_a())) : Util.func_200697_a((String)"block", (ResourceLocation)new ResourceLocation(prefix, modblock.oid()));
            }
        }
        return out;
    }

    public static final String derivativeTranslationKey(Block block, String group, String derivative) {
        String out = _DINK;
        if (block instanceof IModBlock) {
            String specific = ItemSupport.defaultTranslationKey(block);
            if (Strings.hasTranslation(specific)) {
                return specific;
            }
            IModBlock modblock = (IModBlock)block;
            String prefix = modblock.itemid_prefix();
            if (prefix.endsWith("_")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            if (derivative == null) {
                derivative = "block";
            }
            if (group == null) {
                group = "generic";
            }
            out = Util.func_200697_a((String)"block", (ResourceLocation)new ResourceLocation(prefix, group + "_template_" + derivative));
        }
        return out;
    }

    public static final Food.Builder foodFrom(int foodPoints, float saturationFactor, boolean wolfFood) {
        Food.Builder stupid = new Food.Builder().func_221456_a(foodPoints).func_221454_a(saturationFactor);
        if (wolfFood) {
            stupid.func_221451_a();
        }
        return stupid;
    }

    public static final Food.Builder foodFrom(int foodPoints, float saturationFactor, boolean wolfFood, boolean alwaysEdible, boolean instaEat) {
        Food.Builder stupid = new Food.Builder().func_221456_a(foodPoints).func_221454_a(saturationFactor);
        if (wolfFood) {
            stupid.func_221451_a();
        }
        if (alwaysEdible) {
            stupid.func_221457_c();
        }
        if (instaEat) {
            stupid.func_221457_c();
        }
        return stupid;
    }

    public static final Food.Builder curativeFrom(int foodPoints, float saturationFactor, boolean alwaysEdible) {
        return ItemSupport.foodFrom(foodPoints, saturationFactor, false, alwaysEdible, false);
    }

    @Nullable
    public static final Food foodFromOrNull(int foodPoints, float saturationFactor, boolean wolfFood) {
        if (foodPoints <= 0) {
            return null;
        }
        return ItemSupport.foodFrom(foodPoints, saturationFactor, wolfFood).func_221453_d();
    }

    @Nullable
    public static final Food foodFromOrCrumb(int foodPoints, float saturationFactor) {
        if (foodPoints <= 0) {
            return CRUMB;
        }
        return ItemSupport.foodFrom(foodPoints, saturationFactor, false).func_221453_d();
    }

    @Nonnull
    public static final RayTraceResult rayTraceFor(World world, @Nonnull PlayerEntity player, RayTraceContext.FluidMode fm) {
        return DummyItem.INSTANCE.doRayTrace(world, player, fm);
    }

    @Nullable
    public static final IPlantable plantableFrom(ItemStack stack) {
        IPlantable plantable = null;
        if (!ItemStacks.isEmpty(stack)) {
            Item item = stack.func_77973_b();
            if (item instanceof IPlantable) {
                plantable = (IPlantable)item;
            }
            if (plantable == null) {
                if (item instanceof IBlockItem) {
                    item = ((IBlockItem)item).getBlock();
                } else if (item instanceof BlockItem) {
                    item = ((BlockItem)item).func_179223_d();
                }
                if (item instanceof IPlantable) {
                    plantable = (IPlantable)item;
                }
            }
        }
        return plantable;
    }

    public static final void addUsedStat(PlayerEntity player, ItemStack stack) {
        if (!stack.func_190926_b()) {
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)stack.func_77973_b()));
        }
    }

    public static final void addBrokenStat(PlayerEntity player, ItemStack stack) {
        if (!stack.func_190926_b()) {
            player.func_71029_a(Stats.field_199088_e.func_199076_b((Object)stack.func_77973_b()));
        }
    }

    public static final void addPickedUpStat(PlayerEntity player, ItemStack stack) {
        if (!stack.func_190926_b()) {
            player.func_71029_a(Stats.field_199089_f.func_199076_b((Object)stack.func_77973_b()));
        }
    }

    public static final boolean isPristine(@Nonnull ItemStack stack, @Nonnull Item singleton) {
        return stack.func_77973_b() == singleton && !stack.func_77948_v() && !Instructions.present(stack);
    }

    public static final boolean isPristine(@Nonnull ItemStack stack) {
        return !stack.func_77948_v() && !Instructions.present(stack);
    }

    public static final boolean canApplyDamage(ItemStack item, int by, Random rng) {
        if (!item.func_190926_b() && by > 0 && !ItemStacks.isFlaggedUnbreakable(item)) {
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)item);
            int j = 0;
            for (int k = 0; i > 0 && k < by; ++k) {
                if (!UnbreakingEnchantment.func_92097_a((ItemStack)item, (int)i, (Random)rng)) continue;
                ++j;
            }
            return (by -= j) > 0;
        }
        return false;
    }

    public static boolean mendItemBy(@Nonnull ItemStack item, float by) {
        int mended_damage;
        boolean mended = false;
        int damage = item.func_77952_i();
        if (damage - (mended_damage = (int)((float)item.func_77958_k() * by)) < damage) {
            if ((damage -= mended_damage) < 0) {
                damage = 0;
            }
            item.func_196085_b(damage);
            if (by == 1.0f && item.func_82838_A() > 1 && item.func_82838_A() < SharedGlue.MAX_ANVIL_REPAIR_XP_LEVEL_COST() + 1) {
                item.func_82841_c(1);
            }
            mended = true;
        }
        return mended;
    }

    public static void reduceRepairCost(@Nonnull ItemStack damageable, float by) {
        if (ItemStacks.isFlaggedUnbreakable(damageable) || ItemStacks.isFlaggedUnrepairable(damageable)) {
            return;
        }
        int repairCost = damageable.func_82838_A();
        if (repairCost > 3) {
            repairCost -= (int)((float)repairCost * by);
            damageable.func_82841_c(repairCost);
        }
    }

    public static final void noteItemCrafted(PlayerEntity player, ItemStack stack) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player) && !stack.func_190926_b()) {
            CraftedItemTrigger.doApply((ServerPlayerEntity)player, stack);
        }
    }

    public static final void noteItemCraftedNontraditionalMeans(PlayerEntity player, World world, ItemStack generated) {
        generated.func_77980_a(world, player, generated.func_190916_E());
        ItemSupport.noteItemCrafted(player, generated);
    }

    public static final void noteItemConsumed(PlayerEntity player, ItemStack stack) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player) && !stack.func_190926_b()) {
            CriteriaTriggers.field_193138_y.func_193148_a((ServerPlayerEntity)player, stack);
        }
    }

    public static final void noteBlockPlaced(PlayerEntity player, BlockPos at, ItemStack with) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player)) {
            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, at, with);
        }
    }

    public static final void noteFluidPlacedAt(PlayerEntity player, BlockPos at, ItemStack with) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player)) {
            CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)player, at, with);
        }
    }

    public static final void noteBlockHarvested(PlayerEntity by, BlockXyz harvested, ItemStack with) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)by)) {
            HarvestedTrigger.doApply((ServerPlayerEntity)by, harvested);
        }
    }

    public static final void noteBlockHarvested(PlayerEntity by, BlockState harvested, ItemStack with) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)by)) {
            HarvestedTrigger.doApply((ServerPlayerEntity)by, harvested);
        }
    }

    public static final void noteItemNewDurability(LivingEntity bearer, ItemStack held, int newDurability) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)bearer)) {
            CriteriaTriggers.field_193132_s.func_193158_a((ServerPlayerEntity)bearer, held, newDurability);
        }
    }

    public static final void noteBucketFilled(PlayerEntity player, ItemStack bucket) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player)) {
            CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
        }
    }

    public static final void noteStateEarned(PlayerEntity player, ResourceLocation what) {
        if (what != null && SharedGlue.isaProgressAffectedPlayer((Entity)player)) {
            PlayerEarnedTrigger.doApply((ServerPlayerEntity)player, what);
        }
    }

    public static final void noteItemEarned(PlayerEntity player, ItemStack reward) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player) && !reward.func_190926_b()) {
            PlayerEarnedTrigger.doApply((ServerPlayerEntity)player, reward);
        }
    }

    public static final void noteItemEarned(PlayerEntity player, ResourceLocation trigger_name, ItemStack reward) {
        if (SharedGlue.isaProgressAffectedPlayer((Entity)player) && !reward.func_190926_b()) {
            PlayerEarnedTrigger.doApply((ServerPlayerEntity)player, trigger_name, reward);
        }
    }

    public static final int getColorFromMoonshine(ItemStack moonshine, int tintIndex) {
        Integer custom_color;
        int color_num = -1;
        if (tintIndex <= 0 && (custom_color = Potions.getColorOrNull(moonshine)) != null) {
            color_num = custom_color;
        }
        return color_num;
    }

    public static final void initAmendmentSupport() {
    }

    public static final <T extends Item> T setMaxStackSize(@Nonnull T item, int count) {
        if (_maxstackField != null) {
            try {
                _maxstackField.setInt(item, count);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set max stack of {} to {}", (Object)Strings.safe(item, "u/d"), (Object)count);
            }
        }
        return item;
    }

    public static final <T extends Item> T setContainerItem(@Nonnull T item, @Nullable Item container) {
        if (!SharedGlue.isDefined(container)) {
            container = null;
        }
        if (_containerItemField != null) {
            try {
                _containerItemField.set(item, container);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set container item for {}", (Object)Strings.safe(item, "u/d"));
            }
        }
        return item;
    }

    public static final <T extends Item> T setMaxDamage(@Nonnull T item, int amount) {
        if (amount < 0) {
            amount = 0;
        }
        if (_maxdamageField != null) {
            try {
                _maxdamageField.setInt(item, amount);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set max damage of {} to {}", (Object)Strings.safe(item, "u/d"), (Object)amount);
            }
        }
        return item;
    }

    public static final <T extends Item> T setAlwaysEdible(@Nonnull T item) {
        Food f;
        Food food = f = item instanceof FoodItemBase ? ((FoodItemBase)item).getBaseFood() : item.func_219967_s();
        if (f != null && _alwaysEdibleField != null) {
            try {
                _alwaysEdibleField.setBoolean(f, true);
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Could not set always edible for {}", (Object)Strings.safe(item, "u/d"));
            }
        }
        return item;
    }

    protected ItemSupport() {
    }

    static {
        int successes = 0;
        try {
            _maxstackField = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_77777_bU"));
            _maxstackField.setAccessible(true);
            ++successes;
            _containerItemField = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_77700_c"));
            _containerItemField.setAccessible(true);
            ++successes;
            _maxdamageField = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_77699_b"));
            _maxdamageField.setAccessible(true);
            ++successes;
        }
        catch (Throwable igX) {
            LibInfo.LOG.error("Unable to init ItemSupport field setters for max,container,damage?");
        }
        LibInfo.LOG.debug("carrots/lib Item tweaks completed [{},{}]", (Object)(successes == 3 ? "P" : "F"), (Object)successes);
        _alwaysEdibleField = null;
        try {
            _alwaysEdibleField = Food.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_221473_d"));
            _alwaysEdibleField.setAccessible(true);
        }
        catch (Throwable igX) {
            LibInfo.LOG.error("Unable to init ItemSupport field setter for always-edible flag");
        }
    }

    private static final class DummyItem
    extends Item {
        static final DummyItem INSTANCE = new DummyItem();

        DummyItem() {
            super(new Item.Properties());
        }

        public RayTraceResult doRayTrace(World world, PlayerEntity player, RayTraceContext.FluidMode fm) {
            return Item.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)fm);
        }
    }

    public static class DummyItemUseContext
    extends ItemUseContext {
        public static final BlockItemUseContext create_buc(World w, @Nullable PlayerEntity p, @Nonnull BlockRayTraceResult hit) {
            return new BlockItemUseContext((ItemUseContext)new DummyItemUseContext(w, p, Hand.MAIN_HAND, ItemStack.field_190927_a, hit));
        }

        public static final BlockItemUseContext create_buc(World w, @Nonnull BlockRayTraceResult hit) {
            return new BlockItemUseContext((ItemUseContext)new DummyItemUseContext(w, null, Hand.MAIN_HAND, ItemStack.field_190927_a, hit));
        }

        public DummyItemUseContext(World w, PlayerEntity p, Hand h, ItemStack held, BlockRayTraceResult hit) {
            super(w, p, h, held, hit);
        }

        public DummyItemUseContext(ItemUseContext in, ItemStack held) {
            super(in.func_195991_k(), in.func_195999_j(), in.func_221531_n(), held, (BlockRayTraceResult)ObfuscationReflectionHelper.getPrivateValue(ItemUseContext.class, (Object)in, (String)"field_221535_d"));
        }

        public final BlockRayTraceResult getHitTrace() {
            return this.func_242401_i();
        }
    }
}

