/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.api.IModPotionEffect;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.AttributeSupport;
import org.jwaresoftware.mcmods.lib.impl.EffectBase;

public class ShareableEffectBase
extends EffectBase {
    public static final Predicate<Entity> IS_RECEPTIVE = EntityPredicates.field_180132_d.and(e -> e instanceof LivingEntity && AttributeSupport.getIsolationModifier((LivingEntity)e, ItemStack.field_190927_a) < 1.0f);

    protected ShareableEffectBase(IModInfo mod, String name, boolean visible, EffectType type, int particleColor, boolean milkCures) {
        super(mod, name, visible, type, particleColor, milkCures);
    }

    protected ShareableEffectBase(IModInfo mod, String name, boolean visible, boolean bad, int particleColor, boolean milkCures) {
        super(mod, name, visible, bad, particleColor, milkCures);
    }

    protected ShareableEffectBase(IModInfo mod, String name, boolean bad, int particleColor) {
        super(mod, name, bad, particleColor);
    }

    @Override
    public boolean isShareable(@Nullable EffectInstance source, @Nullable LivingEntity from) {
        return super.isShareable(source, from) && this.isReady(_SHARE_COOLDOWN, this.clampedDuration(source.func_76459_b()), 0);
    }

    @Override
    public final void func_76394_a(@Nonnull LivingEntity target, int amplifier) {
        EffectInstance state = target.func_70660_b((Effect)this);
        if (state != null) {
            this.performEffect(target, target, Relationship.SELF, state, amplifier);
            if (LibConfig.canShareEffects() && this.getShareTrigger() == IModPotionEffect.ShareTrigger.EFFECT && this.isShareable(state, target)) {
                this.shareEffect(state, target, amplifier);
            }
        }
    }

    public void shareEffect(@Nonnull EffectInstance effect, @Nonnull LivingEntity target, int amplifier) {
        block2: {
            if (!LibConfig.canShareEffects() || !this.isShareable(effect, target)) break block2;
            BlockPos at = target.func_233580_cy_();
            int R = this.getShareBlockRange(effect);
            int N = 1 + this.clampedAmplifier(amplifier);
            List l = target.func_130014_f_().func_175674_a((Entity)target, new AxisAlignedBB(at.func_177982_a(-R, -R, -R), at.func_177982_a(R, R, R)), IS_RECEPTIVE);
            if (!l.isEmpty()) {
                Relationship r;
                Entity e;
                LivingEntity recipient;
                Collections.shuffle(l);
                int n = 0;
                Iterator iterator = l.iterator();
                while (iterator.hasNext() && (!this.performEffect(target, recipient = (LivingEntity)(e = (Entity)iterator.next()), r = Relationship.get(target, recipient), effect, amplifier) || --N != 0) && ++n != 10) {
                }
            }
        }
    }
}

