/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.IWorldReader;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.block.BlockSupport;

public abstract class TileEntityBase
extends TileEntity {
    protected TileEntityBase(TileEntityType<?> type) {
        super(type);
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT data) {
        super.func_230337_a_(state, data);
    }

    public void handleUpdateTag(CompoundNBT data) {
        this.handleUpdateTag(this.func_195044_w(), data);
    }

    public CompoundNBT getBaseUpdateTag() {
        return super.func_189517_E_();
    }

    public CompoundNBT func_189517_E_() {
        return this.isHeavyweight() ? this.func_189515_b(new CompoundNBT()) : this.getBaseUpdateTag();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        if (this.isClientWorld() && net.getDirection() == PacketDirection.CLIENTBOUND) {
            try {
                BlockState me = this.func_145831_w().func_180495_p(this.func_174877_v());
                this.func_230337_a_(me, pkt.func_148857_g());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected final boolean isClientWorld() {
        return this.func_145830_o() && SharedGlue.isaClientWorld((IWorldReader)this.func_145831_w());
    }

    protected final boolean isServerWorld() {
        return this.func_145830_o() && !SharedGlue.isaClientWorld((IWorldReader)this.func_145831_w());
    }

    protected boolean isHeavyweight() {
        return false;
    }

    public void syncToNearbyPlayers(double radius) {
        if (this.isServerWorld()) {
            BlockSupport.forEachAround(this.func_145831_w(), this.func_174877_v(), radius, SharedGlue.IS_BREATHING_PLAYER, this::sendStateTo);
        }
    }

    public void sendStateTo(Entity entity) {
        ServerPlayerEntity player = SharedGlue.getPlayerMPOrNull(entity);
        if (player != null) {
            player.field_71135_a.func_147359_a((IPacket)this.func_189518_D_());
        }
    }
}

