/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.almanac;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.jwaresoftware.mcmods.lib.api.DayNightState;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import org.jwaresoftware.mcmods.lib.impl.almanac.DayOfWeek;
import org.jwaresoftware.mcmods.lib.integration.AlmanacHelper;

public class AlmanacDate
implements Cloneable {
    @Nullable
    private World _world;
    @Nullable
    ResourceLocation _world_key;
    private int _gameday;
    private int _year;
    @Nonnull
    private WorldSeason.Detailed _season;
    private int _day;
    @Nonnull
    private DayOfWeek _dayofweek;
    @Nonnull
    private DayNightState.Detailed _timeofday = DayNightState.Detailed.UNKNOWN;

    protected AlmanacDate(@Nullable World w) {
        this._world = w;
        if (w != null) {
            this._world_key = w.func_234923_W_().func_240901_a_();
        }
    }

    public AlmanacDate(@Nullable World w, int gameday, int year, WorldSeason.Detailed season, int day, DayOfWeek weekday, DayNightState.Detailed timeofday) {
        this(w);
        this.assign(gameday, year, season, day, weekday, timeofday);
    }

    AlmanacDate(int gameday, int year, WorldSeason.Detailed season, int day, DayOfWeek weekday, DayNightState.Detailed timeofday) {
        this(null, gameday, year, season, day, weekday, timeofday);
    }

    protected final void assign(int gameday, int year, WorldSeason.Detailed season, int day, DayOfWeek weekday, DayNightState.Detailed timeofday) {
        this._gameday = gameday;
        this._year = year;
        this._season = Objects.requireNonNull(season);
        this._dayofweek = Objects.requireNonNull(weekday);
        this._day = day;
        this._timeofday = timeofday != null ? timeofday : DayNightState.Detailed.UNKNOWN;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException clnx) {
            throw new UnsupportedOperationException(clnx);
        }
    }

    public final <T extends AlmanacDate> T copy() {
        return (T)((AlmanacDate)this.clone());
    }

    @Nullable
    public World getWorld() {
        return this._world;
    }

    @Nullable
    public ResourceLocation getWorldId() {
        return this._world_key;
    }

    public final boolean isLinked() {
        return this._world != null;
    }

    public int gameDay() {
        return this._gameday;
    }

    @Nonnull
    public DayNightState timeOfDay() {
        return this._timeofday.state;
    }

    @Nonnull
    public DayNightState.Detailed timeOfDayDetails() {
        return this._timeofday;
    }

    public final boolean same(DayNightState.Detailed other) {
        return this._timeofday.equals(other);
    }

    @Nonnull
    public DayOfWeek dayOfWeek() {
        return this._dayofweek;
    }

    @Nonnull
    public WorldSeason season() {
        return this._season.season;
    }

    @Nonnull
    public WorldSeason.Detailed seasonDetails() {
        return this._season;
    }

    public int seasonDay() {
        return this._day;
    }

    public int year() {
        return this._year;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("GYr:").append(this.year()).append(",");
        sb.append("GDy:").append(this.gameDay());
        sb.append(" ||| ");
        sb.append("Alm:").append(this.dayOfWeek().shortName()).append("-");
        sb.append(this.seasonDay()).append("d-");
        sb.append(this.season().commonName());
        sb.append("(").append(this.timeOfDayDetails()).append(")");
        sb.append("}");
        return sb.toString();
    }

    @Nonnull
    static final <T extends AlmanacDate> T assign(@Nonnull T alm, @Nonnull ServerWorld w, @Nullable BlockPos at) {
        if (alm == null) {
            throw new IllegalArgumentException("Almanac date reference is required");
        }
        if (w == null) {
            throw new IllegalArgumentException("World reference is required");
        }
        int day = AlmanacHelper.getCurrentDay((World)w);
        int year = AlmanacHelper.getCurrentYear((World)w);
        DayOfWeek weekday = DayOfWeek.from(day - 1);
        if (at == null) {
            at = AlmanacHelper.safeLocationOrSpawn((World)w);
        }
        WorldSeason.Detailed season = AlmanacHelper.getDetailedSeason((World)w, at);
        alm.assign(day, year, season, AlmanacHelper.getSeasonDay((World)w), weekday, AlmanacHelper.geDetailedDayNightState((World)w, at));
        alm._world_key = w.func_234923_W_().func_240901_a_();
        return alm;
    }

    static final AlmanacDate create(@Nonnull ServerWorld w, @Nullable BlockPos at, boolean weak) {
        AlmanacDate alm = new AlmanacDate((World)(weak ? null : w));
        return AlmanacDate.assign(alm, w, at);
    }

    public static final AlmanacDate create(@Nonnull ServerWorld w, @Nullable BlockPos at) {
        return AlmanacDate.create(w, at, false);
    }
}

