/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.almanac;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.api.DayNightState;
import org.jwaresoftware.mcmods.lib.impl.almanac.AlmanacDate;
import org.jwaresoftware.mcmods.lib.impl.almanac.AlmanacEvent;
import org.jwaresoftware.mcmods.lib.integration.AlmanacHelper;

public final class AlmanacRolloverEventHandler {
    Map<RegistryKey<World>, TrackedData> DATA = Collections.synchronizedMap(new WeakHashMap());

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        if (e.phase == TickEvent.Phase.END && e.side == LogicalSide.SERVER && SharedGlue.isaServerWorld((IWorldReader)e.world)) {
            ServerWorld world = (ServerWorld)e.world;
            RegistryKey world_id = world.func_234923_W_();
            if (!LibConfig.isAlmanacTracked((RegistryKey<World>)world_id)) {
                return;
            }
            boolean changed = false;
            boolean rollover = true;
            TrackedData previous = this.DATA.get(world_id);
            TrackedData current = null;
            if (previous == null || previous._doDaycycle != SharedGlue.isDayNightCycleEnabled((World)world)) {
                current = TrackedData.create_ex(world);
                this.DATA.put((RegistryKey<World>)world_id, current);
                changed = true;
                rollover = false;
            } else {
                int currDay = AlmanacHelper.getCurrentDay((World)world);
                if (currDay != previous.gameDay()) {
                    changed = true;
                } else {
                    DayNightState.Detailed currToD = AlmanacHelper.geDetailedDayNightState((World)world, AlmanacHelper.safeLocation((World)world));
                    if (!previous.same(currToD)) {
                        changed = true;
                    }
                }
                if (changed) {
                    current = TrackedData.create_ex(world);
                    this.DATA.put((RegistryKey<World>)world_id, current);
                }
            }
            if (changed) {
                if (LibConfig.__devEnvironment()) {
                    AlmanacEvent.LOG.debug("{} '{}': {} -> {}", (Object)(rollover ? "rollover" : "resync"), (Object)world_id.func_240901_a_(), (Object)previous, (Object)current);
                }
                if (!rollover && !current._doDaycycle) {
                    AlmanacEvent.LOG.error("{}", (Object)Strings.translate("carrots.msg.daynight.turned.off"));
                }
                MinecraftForge.EVENT_BUS.post((Event)(rollover ? new AlmanacEvent.Rollover(previous, current) : new AlmanacEvent.Resync(previous, current)));
            }
        }
    }

    static class TrackedData
    extends AlmanacDate {
        boolean _doDaycycle;

        TrackedData() {
            super(null);
        }

        static final TrackedData create_ex(ServerWorld w) {
            TrackedData alm = new TrackedData();
            AlmanacDate.assign(alm, w, (BlockPos)(AlmanacHelper.isNetherOrEnd((World)w) ? BlockPos.field_177992_a : null));
            alm._doDaycycle = SharedGlue.isDayNightCycleEnabled((World)w);
            return alm;
        }
    }
}

