/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.almanac;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.api.DayNightState;
import org.jwaresoftware.mcmods.lib.api.TimeFrame;
import org.jwaresoftware.mcmods.lib.integration.AlmanacHelper;

public final class DayNightThresholds
implements DayNightState.Provider {
    private final float _dawn_end;
    private final float _day_end;
    private final float _midday_end;
    private final float _dusk_start;
    private final int _shift;
    public static final DayNightThresholds BY_CONFIGURED_THRESHOLDS = DayNightThresholds.configured();

    private DayNightThresholds(long tpd, float dawn, float day, float mid, float dusk, int shift) {
        this._dawn_end = dawn;
        this._day_end = day;
        this._midday_end = mid;
        this._dusk_start = dusk;
        this._shift = shift;
    }

    public static final float compute(long ticks, long ticksperday) {
        if (ticksperday <= 0L) {
            throw new IllegalArgumentException("Invalid TPD");
        }
        return (float)ticks / (float)ticksperday;
    }

    final DayNightState get(float at) {
        return at < this._dawn_end ? DayNightState.DAWN : (at >= this._day_end ? DayNightState.NIGHT : (at < this._dusk_start ? DayNightState.DAY : DayNightState.DUSK));
    }

    final float compute(World w, BlockPos pos) {
        return DayNightThresholds.compute(AlmanacHelper.getDayElapsedTicks(w, pos, this._shift), AlmanacHelper.ticksPerFullDay(w));
    }

    final float compute(DayNightState fixed) {
        switch (fixed) {
            case DAWN: {
                return 0.9f * this._dawn_end;
            }
            case DAY: {
                return 0.9f * this._dusk_start;
            }
            case DUSK: {
                return 1.1f * this._dusk_start;
            }
            case NIGHT: {
                return 1.1f * this._day_end;
            }
        }
        return 0.0f;
    }

    @Override
    public DayNightState apply(World w, BlockPos pos) {
        DayNightState st = DayNightThresholds.unchanging((IBiomeReader)w, pos);
        return st != null ? st : this.get(this.compute(w, pos));
    }

    @Override
    public DayNightState.Detailed getDetailedTimeOfDay(World w, BlockPos pos) {
        DayNightState st = DayNightThresholds.unchanging((IBiomeReader)w, pos);
        TimeFrame when = TimeFrame.ANY;
        if (st == null) {
            float at = this.compute(w, pos);
            st = this.get(at);
            if (st == DayNightState.DAY) {
                when = at <= this._midday_end ? TimeFrame.EARLY : TimeFrame.LATE;
            }
        } else if (st != DayNightState.UNKNOWN) {
            when = TimeFrame.MID;
        }
        return new DayNightState.Detailed(st, when);
    }

    final boolean matches(float at, DayNightState wanted) {
        if (wanted == DayNightState.MORNING || wanted == DayNightState.AFTERNOON) {
            DayNightState is = this.get(at);
            if (wanted == DayNightState.MORNING) {
                return is == DayNightState.DAWN || at <= this._midday_end;
            }
            return is == DayNightState.DAY && at > this._midday_end;
        }
        return this.matches(this.get(at), wanted);
    }

    @Override
    public boolean matches(World w, BlockPos pos, DayNightState wanted) {
        if (wanted == DayNightState.MORNING || wanted == DayNightState.AFTERNOON) {
            DayNightState st = DayNightThresholds.unchanging((IBiomeReader)w, pos);
            float at = st != null ? this.compute(st) : this.compute(w, pos);
            return this.matches(at, wanted);
        }
        return DayNightState.Provider.super.matches(w, pos, wanted);
    }

    @Nonnull
    public static final DayNightThresholds configured() {
        long fullday_t = LibConfig.__ticksPerFullDay();
        int dawn_t = LibConfig.__ticksInDawn();
        int dusk_t = LibConfig.__ticksInDusk();
        int light_t = LibConfig.__ticksInDaytime() - dawn_t - dusk_t;
        return DayNightThresholds.custom(fullday_t, dawn_t, light_t, dusk_t);
    }

    @Nonnull
    public static final DayNightThresholds custom(long fullday_t, int dawn_t, int light_t, int dusk_t) {
        float dawn = DayNightThresholds.compute(dawn_t, fullday_t);
        float day = DayNightThresholds.compute(dawn_t + light_t + dusk_t, fullday_t);
        float dusk = DayNightThresholds.compute(dawn_t + light_t, fullday_t);
        float mid = DayNightThresholds.compute(dawn_t + light_t / 2 + (light_t % 2 != 0 ? 1 : 0), fullday_t);
        return DayNightThresholds.of(fullday_t, dawn, day, mid, dusk, dawn_t);
    }

    private static final DayNightThresholds of(long tpd, float dawn, float day_end, float afternoon_start, float dusk_start, int shift) {
        if (dawn <= 0.0f || day_end <= 0.0f || dusk_start <= 0.0f || day_end <= dawn || afternoon_start >= day_end || afternoon_start >= dusk_start || dusk_start <= dawn || dusk_start > day_end) {
            throw new IllegalArgumentException("Invalid day/night thresholds definition");
        }
        return new DayNightThresholds(tpd, dawn, day_end, afternoon_start, dusk_start, shift);
    }

    @Nullable
    public static final DayNightState unchanging(IBiomeReader br, BlockPos at) {
        DayNightState locked = DayNightState.getUnchangingState(br, at);
        if (locked != null) {
            return locked;
        }
        World world = (World)br;
        if (!Locations.isOverworld((IWorldReader)world)) {
            return world.func_72935_r() ? DayNightState.DAY : DayNightState.NIGHT;
        }
        return null;
    }
}

