/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.almanac;

import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.jwaresoftware.mcmods.lib.LibInfo;

public enum DayOfWeek implements Predicate<String>
{
    MONDAY,
    TUESDAY,
    WEDNESDAY,
    THURSDAY,
    FRIDAY,
    SATURDAY,
    SUNDAY;

    public static final DayOfWeek FIRST_DAY;
    public static final DayOfWeek LAST_DAY;
    private static final DayOfWeek[] _VALUES;
    private static final List<String> _ALL;
    private static final List<String> _DAY;
    private static final List<String> _END;
    private static final List<String> _ODD;
    private static final List<String> _EVN;
    private final String _lc_name = this.name().toLowerCase(Locale.ROOT);
    private final String _lc_shortname = this._lc_name.substring(0, 3);
    private final String _shortname = java.time.DayOfWeek.of(this.index()).getDisplayName(TextStyle.SHORT, Locale.ROOT);
    private final String _i18n_name = LibInfo.lstring("dayofweek." + this._lc_name);

    public final String id() {
        return this._lc_name;
    }

    public final int index() {
        return this.ordinal() + 1;
    }

    public String toString() {
        return this._lc_name;
    }

    @Nonnull
    public final String getTranslationKey() {
        return this._i18n_name;
    }

    @Nonnull
    public final String getDisplayName(TextStyle style) {
        return java.time.DayOfWeek.of(this.index()).getDisplayName(style, Locale.ROOT);
    }

    public final String shortName() {
        return this._shortname;
    }

    @Override
    public boolean test(String s) {
        return this._lc_shortname.equals(s) || this._lc_name.equals(s);
    }

    public static final Predicate<String> any() {
        return s -> s != null && _ALL.contains(s);
    }

    public static final Predicate<String> weekday() {
        return s -> s != null && _DAY.contains(s);
    }

    public static final Predicate<String> weekend() {
        return s -> s != null && _END.contains(s);
    }

    public static final Predicate<String> even_weekday() {
        return s -> s != null && _EVN.contains(s);
    }

    public static final Predicate<String> odd_weekday() {
        return s -> s != null && _ODD.contains(s);
    }

    public static final int count() {
        return _VALUES.length;
    }

    public static final DayOfWeek from(int i) {
        return _VALUES[i % DayOfWeek.count()];
    }

    static {
        FIRST_DAY = MONDAY;
        LAST_DAY = SUNDAY;
        _VALUES = DayOfWeek.values();
        _ALL = new ArrayList<String>(23);
        _DAY = new ArrayList<String>(23);
        _END = new ArrayList<String>(23);
        _ODD = new ArrayList<String>(11);
        _EVN = new ArrayList<String>(11);
        for (DayOfWeek dow : _VALUES) {
            _ALL.add(dow._lc_name);
            _ALL.add(dow._lc_shortname);
            if (dow != SATURDAY && dow != SUNDAY) {
                _DAY.add(dow._lc_name);
                _DAY.add(dow._lc_shortname);
            } else {
                _END.add(dow._lc_name);
                _END.add(dow._lc_shortname);
            }
            if (dow == TUESDAY || dow == THURSDAY) {
                _EVN.add(dow._lc_name);
                _EVN.add(dow._lc_shortname);
                continue;
            }
            _ODD.add(dow._lc_name);
            _ODD.add(dow._lc_shortname);
        }
    }
}

