/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.block.ItemBlockBase;

public class ButtonBlockBase
extends AbstractButtonBlock
implements IModBlock {
    @Nonnull
    protected final String _oid;
    protected boolean _hidden;
    private String _i18n = "";
    private final boolean _fast;

    public ButtonBlockBase(@Nonnull String oid, boolean fast, @Nullable AbstractBlock.Properties p, boolean hidden) {
        super(!fast, p);
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
        this._hidden = hidden;
        this._fast = fast;
    }

    public ButtonBlockBase(@Nonnull String oid, boolean fast, @Nonnull Block likeBlock, boolean hidden) {
        this(oid, fast, AbstractBlock.Properties.func_200950_a((AbstractBlock)likeBlock), hidden);
    }

    @Override
    @Nonnull
    public final String oid() {
        return this._oid;
    }

    @Override
    public final Random getRNG() {
        return this.RANDOM;
    }

    @Override
    public String getTranslationKey(ItemStack stack) {
        if (this._i18n.isEmpty()) {
            this._i18n = ItemSupport.defaultTranslationKey((Block)this);
        }
        return this._i18n;
    }

    public final String func_149739_a() {
        return this.getTranslationKey(ItemStack.field_190927_a);
    }

    @Override
    public BlockItem makeItemBlock(@Nonnull Block thisblock, @Nullable Item.Properties ip) {
        return new ItemBlockBase(thisblock, ip);
    }

    @Override
    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    @Override
    public void setHiddenByDefault(boolean flag) {
        this._hidden = flag;
    }

    public void func_149666_a(ItemGroup tab, NonNullList<ItemStack> list) {
        if (!this.isHiddenByDefault() || tab == SharedGlue.CreativeTabs_search) {
            super.func_149666_a(tab, list);
        }
    }

    protected SoundEvent func_196369_b(boolean on) {
        return this._fast ? (on ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU) : (on ? SoundEvents.field_187885_gS : SoundEvents.field_187883_gR);
    }
}

