/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.client;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.impl.almanac.DayOfWeek;
import org.jwaresoftware.mcmods.lib.integration.AlmanacHelper;

@OnlyIn(value=Dist.CLIENT)
public final class AlmanacDebugInfo {
    private final boolean _full_diagnostics;

    public AlmanacDebugInfo(boolean full) {
        this._full_diagnostics = full;
    }

    @SubscribeEvent
    public final void onRenderText(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT && SharedGlue.isaPlayer(minecraft.func_175606_aa())) {
            PlayerEntity player = (PlayerEntity)minecraft.func_175606_aa();
            World w = player.func_130014_f_();
            ArrayList info = event.getLeft();
            if (!info.isEmpty()) {
                info.add("");
            }
            BlockPos at = player.func_233580_cy_();
            StringBuilder sb = new StringBuilder(250);
            if (this._full_diagnostics || minecraft.field_71474_y.field_74330_P) {
                sb.append("MGT:").append(w.func_82737_E()).append("t ").append("MDT:").append(w.func_72820_D() / (long)SharedGlue.SECS_TO_TICKS_MULTIPLIER()).append("s");
                info.add(sb.toString());
                sb.setLength(0);
            }
            sb.append("GYr:").append(AlmanacHelper.getCurrentYear(w)).append(" ");
            sb.append("YDy:").append(AlmanacHelper.getYearDay(w)).append(" ");
            sb.append("ToD:").append(AlmanacHelper.geDetailedDayNightState(w, at).getDisplayText().getString());
            info.add(sb.toString());
            sb.setLength(0);
            sb.append("SDy:").append(DayOfWeek.from(AlmanacHelper.getElapsedDays(w)).shortName()).append("-");
            sb.append(AlmanacHelper.getSeasonDay(w)).append("d-");
            sb.append(Strings.translate(AlmanacHelper.getTranslationKey(w, AlmanacHelper.getSeason(w, at))));
            sb.append(" ").append(AlmanacDebugInfo.timeOfDay(SharedGlue.tickingTime(w)));
            info.add(sb.toString());
            sb.setLength(0);
            sb.append("DTm:").append(AlmanacHelper.getDayElapsedTicks(w, at, 0)).append("t");
            info.add(sb.toString());
        }
    }

    private static String timeOfDay(long time) {
        long hr = (time / 1000L + 6L) % 24L;
        long mn = time % 1000L * 60L / 1000L;
        String ampm = "AM";
        if (hr >= 12L) {
            hr -= 12L;
            ampm = "PM";
        }
        if (hr >= 12L) {
            hr -= 12L;
            ampm = "AM";
        }
        if (hr == 0L) {
            hr = 12L;
        }
        String mm = "0" + mn;
        mm = mm.substring(mm.length() - 2);
        return hr + ":" + mm + " " + ampm;
    }
}

