/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.client;

import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jwaresoftware.mcmods.lib.CarrotsLib;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.impl.client.AlmanacDebugInfo;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalFluids;
import org.jwaresoftware.mcmods.lib.integration.FluidsHelper;

@OnlyIn(value=Dist.CLIENT)
public final class CarrotsLibClient {
    static Method _JEI_ColorGetter = null;

    public static final void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CarrotsLibClient::sidedStartUp);
    }

    public static final void initConfigured() {
        if (LibConfig.__devEnvironment()) {
            MinecraftForge.EVENT_BUS.register((Object)new AlmanacDebugInfo(true));
        }
    }

    private static void sidedStartUp(FMLClientSetupEvent event) {
        event.enqueueWork(() -> UniversalFluids.warmableBuckets().forEach(ci -> ci.registerPropertyOverrides()));
        RenderType translucent = RenderType.func_228645_f_();
        UniversalFluids.translucentBlocks().forEach(f -> RenderTypeLookup.setRenderLayer((Fluid)f, (RenderType)translucent));
        CarrotsLibClient.initFluidColorGetter();
    }

    static final ClientWorld getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private static void initFluidColorGetter() {
        if (ModIntegration.JEI.isLoaded()) {
            try {
                Class<?> colorGetter = Class.forName("mezz.jei.color.ColorGetter");
                _JEI_ColorGetter = colorGetter.getMethod("getColors", TextureAtlasSprite.class, Integer.TYPE, Integer.TYPE);
                FluidsHelper.initFinalize(CarrotsLib.ID, new FluidsHelper.SPILink(){

                    @Override
                    public ModIntegration modid() {
                        return CarrotsLib.ID;
                    }

                    @Override
                    public int getColorFrom(FluidStack f) {
                        TextureAtlasSprite[] sprites;
                        if (_JEI_ColorGetter != null && ModIntegration.JEI.isLoaded() && !f.isEmpty() && (sprites = ForgeHooksClient.getFluidSprites((IBlockDisplayReader)CarrotsLibClient.getClientWorld(), (BlockPos)BlockPos.field_177992_a, (FluidState)f.getFluid().func_207188_f())).length > 0) {
                            try {
                                List colors = (List)List.class.cast(_JEI_ColorGetter.invoke(null, sprites[0], 0xFFFFFF, 1));
                                if (!colors.isEmpty()) {
                                    return (Integer)colors.get(0);
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return 0xFFFFFF;
                    }
                });
                FluidsHelper.initFinalize(ModIntegration.FORGE_LIB, CarrotsLib.ID);
                ModIntegration.wabbitsMods().filter(m -> m != ModIntegration.CARROTS_LIB).forEach(m -> FluidsHelper.initFinalize(m, CarrotsLib.ID));
            }
            catch (Throwable igX) {
                LibInfo.LOG.error("Unable to initialize JEI fluids texture color hook! ({})", (Object)ExceptionUtils.getRootCauseMessage((Throwable)igX));
            }
        }
    }
}

