/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.client;

import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;

@OnlyIn(value=Dist.CLIENT)
public class NutritionNotesTooltip {
    public static final void onItemTooltipAlways(ItemTooltipEvent event, boolean debug, NutritionNote.Scope ... shown) {
        if (!LibConfig.getInstance().isFullyStarted()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        long nn = NutritionNote.getFrom(stack);
        LinkedList<IFormattableTextComponent> nn_lines = new LinkedList<IFormattableTextComponent>();
        int nn_found = 0;
        for (NutritionNote.Scope set : shown) {
            IFormattableTextComponent nn_line = NutritionNote.getDisplayLine(nn, set == NutritionNote.Scope.FOOD_GROUPS ? NutritionNote.Scope.FOOD_GROUPS_TOOLTIP : set);
            nn_lines.add(nn_line);
            if (nn_line == null) continue;
            ++nn_found;
        }
        if (nn_found > 0) {
            for (int i = 0; i < nn_lines.size(); ++i) {
                NutritionNote.Scope set;
                TextFormatting strike = null;
                IFormattableTextComponent nn_line = (IFormattableTextComponent)nn_lines.get(i);
                if (nn_line == null) {
                    nn_line = new TranslationTextComponent(LibInfo.lstring("nnprofile.blank.value"));
                }
                if ((set = shown[i]) == NutritionNote.Scope.FOOD_GROUPS && stack.func_77973_b().func_206844_a(NutritionNote.DISABLED_FOODGROUP_TAG)) {
                    if (!debug) {
                        nn_line = null;
                    } else {
                        strike = TextFormatting.STRIKETHROUGH;
                    }
                }
                if (nn_line == null) continue;
                IFormattableTextComponent nnoteLine = set.getDisplayLineFor(nn_line);
                if (strike != null) {
                    nnoteLine.func_240699_a_(strike);
                }
                event.getToolTip().add(nnoteLine);
            }
        }
    }

    public static final void onItemTooltip(ItemTooltipEvent event, boolean debug, NutritionNote.Scope ... shown) {
        if (!LibConfig.getInstance().isFullyStarted()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        long nn = NutritionNote.getFrom(stack);
        for (NutritionNote.Scope set : shown) {
            TextFormatting strike = null;
            IFormattableTextComponent nn_line = NutritionNote.getDisplayLine(nn, set == NutritionNote.Scope.FOOD_GROUPS ? NutritionNote.Scope.FOOD_GROUPS_TOOLTIP : set);
            if (set == NutritionNote.Scope.FOOD_GROUPS && stack.func_77973_b().func_206844_a(NutritionNote.DISABLED_FOODGROUP_TAG)) {
                if (!debug) {
                    nn_line = null;
                } else {
                    strike = TextFormatting.STRIKETHROUGH;
                }
            }
            if (nn_line == null) continue;
            IFormattableTextComponent nnoteLine = set.getDisplayLineFor(nn_line);
            if (strike != null) {
                nnoteLine.func_240699_a_(strike);
            }
            event.getToolTip().add(nnoteLine);
        }
    }
}

