/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.client;

import javax.annotation.Nonnull;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;

@OnlyIn(value=Dist.CLIENT)
public final class TemperatureItemProperty {
    @OnlyIn(value=Dist.CLIENT)
    public static final IItemPropertyGetter forEither = new Impl(ITemperatureChangeable.SupportedEffect.BOTH);
    @OnlyIn(value=Dist.CLIENT)
    public static final IItemPropertyGetter forHeatable = new Impl(ITemperatureChangeable.SupportedEffect.HEATING);
    @OnlyIn(value=Dist.CLIENT)
    public static final IItemPropertyGetter forCoolable = new Impl(ITemperatureChangeable.SupportedEffect.COOLING);

    @OnlyIn(value=Dist.CLIENT)
    public static final void addBoth(@Nonnull Item item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("temperature"), (IItemPropertyGetter)forEither);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addHeatable(@Nonnull Item item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("temperature"), (IItemPropertyGetter)forHeatable);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final void addCoolable(@Nonnull Item item) {
        ItemModelsProperties.func_239418_a_((Item)item, (ResourceLocation)new ResourceLocation("temperature"), (IItemPropertyGetter)forCoolable);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static final class Impl
    implements IItemPropertyGetter {
        private final ITemperatureChangeable.SupportedEffect _whatCheck;

        Impl(@Nonnull ITemperatureChangeable.SupportedEffect support) {
            Validate.notNull((Object)((Object)support));
            this._whatCheck = support;
        }

        public float call(ItemStack stack, ClientWorld world, LivingEntity unused) {
            if (ITemperatureChangeable.SupportedEffect.BOTH == this._whatCheck) {
                return this._applyIfEither(stack);
            }
            ITemperatureChangeable cap = (ITemperatureChangeable)stack.func_77973_b();
            return ITemperatureChangeable.SupportedEffect.HEATING == this._whatCheck ? (cap.isHeated(stack) || cap.shouldBeHeated(stack) ? 1.0f : 0.0f) : (cap.isCooled(stack) || cap.shouldBeCooled(stack) ? 1.0f : 0.0f);
        }

        private final float _applyIfEither(ItemStack stack) {
            float out = 0.0f;
            if (ItemStacks.hasData(stack)) {
                ITemperatureChangeable cap = (ITemperatureChangeable)stack.func_77973_b();
                if (cap.shouldBeHeated(stack)) {
                    out = 1.0f;
                } else if (cap.shouldBeCooled(stack)) {
                    out = 2.0f;
                } else if (cap.isHeated(stack)) {
                    out = 1.0f;
                } else if (cap.isCooled(stack)) {
                    out = 2.0f;
                }
            }
            return out;
        }
    }
}

