/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

public final class EnduranceEffect
extends NourishmentEffect {
    public static final String NAME = "endurance";

    public static final Effect get() {
        return NourishmentEffect.getOrPlacebo(NAME);
    }

    private EnduranceEffect() {
        super(NAME, true, EffectType.BENEFICIAL, 15566844, false);
    }

    static final void install() {
        Validate.isTrue((boolean)NourishmentEffect.install(NAME, new EnduranceEffect()), (String)"Endurance effect installed once", (Object[])new Object[0]);
    }

    @Override
    public boolean func_76397_a(int duration, int amplifier) {
        return this.isReady(amplifier > 0 ? _OFTEN : _LESS_OFTEN, duration, 0);
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship relationship, EffectInstance ei, int amplifier) {
        boolean applied = false;
        if (ei.func_188419_a() == this) {
            amplifier = this.clampedAmplifier(amplifier);
            NourishmentEffect.onAppliedPre(target, amplifier, "muscle_boosted");
            WellnessHelper.rejuvenateIfTired(target, amplifier, -1);
            applied = true;
        }
        return applied;
    }
}

