/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.impl.AttributeSupport;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;

public final class EnergizedEffect
extends NourishmentEffect {
    public static final String NAME = "energized";
    private static WellFedEffect.Profile _PROFILE = new WellFedEffect.Profile(0.1, 0.1, 0.0, 0.05, 0.05, 0.15, 2.5, 0.3);
    private final Map<Attribute, AttributeModifier> LVL2_BUFFS = new HashMap<Attribute, AttributeModifier>();

    public static final Effect get() {
        return NourishmentEffect.getOrPlacebo(NAME);
    }

    private EnergizedEffect() {
        super(NAME, true, EffectType.BENEFICIAL, 0xFFFFFF, false);
    }

    static final void install() {
        Validate.isTrue((boolean)NourishmentEffect.install(NAME, new EnergizedEffect()), (String)"Energized effect installed once", (Object[])new Object[0]);
    }

    @Override
    protected void initAttributeModifiers() {
        WellFedEffect.Profile stats = _PROFILE;
        this.func_220304_a(Attributes.field_233821_d_, "678194e7-82f9-42fb-9584-99dd97411525", stats.MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)AttributeSupport.ENTITY_BLOCKBREAK_SPEED_ATTRIB.get(), "ad3945e4-8e45-4615-9532-5597994c963d", stats.MINING_SPEED, AttributeModifier.Operation.ADDITION);
        this.func_220304_a(Attributes.field_233825_h_, "d7b27c00-a8ac-4910-a205-67d222b961c0", stats.ATTACK_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a((Attribute)ForgeMod.SWIM_SPEED.get(), "5d86196f-e618-4885-94bc-ae23c8fa93be", stats.MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.LVL2_BUFFS.put(Attributes.field_233822_e_, new AttributeModifier(UUID.fromString("087ff20d-aa10-4b36-8721-56a6fc805ea9"), this.func_76393_a(), stats.MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_BASE));
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship relationship, EffectInstance ei, int amplifier) {
        boolean applied = relationship.isSelf();
        if (ei.func_188419_a() == this && amplifier > 0) {
            applied = Potions.addSecondaryPotionEffect(target, Effects.field_76430_j, this, this.clampedAmplifier(amplifier));
        }
        return applied;
    }

    @Override
    public void func_111185_a(LivingEntity target, AttributeModifierManager attrs, int amplifier) {
        if (amplifier > 1) {
            amplifier = this.clampedAmplifier(amplifier);
            for (Map.Entry<Attribute, AttributeModifier> addl : this.LVL2_BUFFS.entrySet()) {
                ModifiableAttributeInstance attr = attrs.func_233779_a_(addl.getKey());
                if (attr == null) continue;
                AttributeModifier am = addl.getValue();
                attr.func_111124_b(am);
                attr.func_233769_c_(new AttributeModifier(am.func_111167_a(), this.func_76393_a() + " " + amplifier, this.func_111183_a(amplifier, am), am.func_220375_c()));
            }
        }
        super.func_111185_a(target, attrs, amplifier);
    }

    @Override
    public void func_111187_a(LivingEntity target, AttributeModifierManager attrs, int amplifier) {
        if (amplifier > 1) {
            for (Map.Entry<Attribute, AttributeModifier> addl : this.LVL2_BUFFS.entrySet()) {
                ModifiableAttributeInstance attr = attrs.func_233779_a_(addl.getKey());
                if (attr == null) continue;
                attr.func_111124_b(addl.getValue());
            }
        }
        super.func_111187_a(target, attrs, amplifier);
    }
}

