/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModPotionEffect;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.impl.AttributeSupport;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;

public class HappinessEffect
extends NourishmentEffect {
    public static final String NAME = "happiness";
    static final String NAME_DONOR = "happiness_donor";

    public static final Effect get() {
        return NourishmentEffect.getOrPlacebo(NAME);
    }

    public static final Effect donor() {
        return NourishmentEffect.getOrPlacebo(NAME_DONOR);
    }

    public HappinessEffect(String name, int particleColor) {
        super(name, true, EffectType.BENEFICIAL, particleColor, true);
    }

    HappinessEffect(String name) {
        this(name, 16773494);
    }

    static final void install() {
        Validate.isTrue((boolean)NourishmentEffect.install(NAME, new Single()), (String)"Happiness effect installed once", (Object[])new Object[0]);
        NourishmentEffect.install(NAME_DONOR, new Shared());
    }

    @Override
    protected void initAttributeModifiers() {
        this.func_220304_a((Attribute)AttributeSupport.ENTITY_CHARM_ATTRIB.get(), AttributeSupport.CHARM_MODIFIER.toString(), 1.0, AttributeModifier.Operation.ADDITION);
        this.func_220304_a((Attribute)AttributeSupport.HAPPENSTANCE_ATTRIB.get(), AttributeSupport.HAPPENSTANCE_MODIFIER.toString(), 1.0, AttributeModifier.Operation.ADDITION);
    }

    @Override
    public int getShareBlockRange(EffectInstance state) {
        return LibConfig.getMaxDistanceEffectRange();
    }

    @Override
    public boolean isShareable(EffectInstance state, LivingEntity from) {
        return SharedGlue.isaRealPlayer((Entity)from) && super.isShareable(state, from);
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship r, EffectInstance ei, int amplifier) {
        boolean applied = false;
        if (source == target) {
            r = Relationship.SELF;
        }
        if (ei.func_188419_a() == this && r.isOverlyGenerous()) {
            if (r == Relationship.SELF || this.getShareLike() != IModPotionEffect.ShareMode.WHOLESALE) {
                NourishmentEffect.onAppliedPre(target, amplifier, "sadness");
                applied = true;
            } else {
                applied = Potions.addSharedPotionEffect(target, ei, HappinessEffect.get(), -1, 0, HappinessEffect.showSharedEffectParticles(target));
            }
        }
        return applied;
    }

    private static final class Single
    extends HappinessEffect {
        Single() {
            super(HappinessEffect.NAME);
        }
    }

    private static final class Shared
    extends HappinessEffect {
        Shared() {
            super(HappinessEffect.NAME_DONOR);
        }

        @Override
        public IModPotionEffect.ShareMode getShareLike() {
            return IModPotionEffect.ShareMode.WHOLESALE;
        }

        @Override
        public IModPotionEffect.ShareTrigger getShareTrigger() {
            return IModPotionEffect.ShareTrigger.EFFECT;
        }
    }
}

