/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

public final class HydrateEffect
extends NourishmentEffect {
    public static final String NAME = "hydration";

    public static final Effect get() {
        return NourishmentEffect.getOrPlacebo(NAME);
    }

    public HydrateEffect(String name, int particleColor) {
        super(name, true, EffectType.BENEFICIAL, particleColor, false);
    }

    private HydrateEffect() {
        this(NAME, 1487251);
    }

    static final void install() {
        Validate.isTrue((boolean)NourishmentEffect.install(NAME, new HydrateEffect()), (String)"Hydration effect installed once", (Object[])new Object[0]);
    }

    @Override
    public boolean func_76397_a(int duration, int amplifier) {
        return this.isReady(amplifier > 0 ? _OFTEN : _LESS_OFTEN, duration, 0);
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship r, EffectInstance ei, int amplifier) {
        boolean applied = false;
        if (ei.func_188419_a() == this && r.isFamily()) {
            ItemStack rep = ItemStack.field_190927_a;
            int n = 1 + this.clampedAmplifier(amplifier);
            NourishmentEffect.onAppliedPre(target, n - 1, "thirst");
            WellnessHelper.quenchThirst(target, LiquidType.WATER_MARBLE.getThirstQuenched(rep) * (float)n, LiquidType.WATER_MARBLE.getHydrationAdded(rep) * (float)n, 0.0f);
            applied = true;
        }
        return applied;
    }
}

