/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.effects.EmptyEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;

public class InstantCurativeEffect
extends EmptyEffect {
    private static final String _MILK_BUCKET = "milk_bucket";
    private static final String _HONEY_BUCKET = "honey_bucket";
    private static final String _BIRCH_BUCKET = "birchsap_bucket";
    @Nonnull
    protected final String _cure_profile;
    private final boolean _bucketful;

    @Nonnull
    public static final Effect honeyBucket() {
        return NourishmentEffect.getOrPlacebo(_HONEY_BUCKET);
    }

    @Nonnull
    public static final Effect milkBucket() {
        return NourishmentEffect.getOrPlacebo(_MILK_BUCKET);
    }

    @Nonnull
    public static final Effect birchsapBucket() {
        return NourishmentEffect.getOrPlacebo(_BIRCH_BUCKET);
    }

    protected InstantCurativeEffect(IModInfo mod, String name, int particleColor) {
        this(mod, name, null, particleColor);
    }

    private InstantCurativeEffect(@Nonnull String cure_profile, int particleColor) {
        this((IModInfo)LibInfo.getInstance(), cure_profile, cure_profile, particleColor);
        IniRegistries.autoregisterPotion(LibInfo.MOD_ID(), this, cure_profile);
    }

    public InstantCurativeEffect(IModInfo mod, String name, String cure_profile, int particleColor) {
        super(mod, name, false, EffectType.BENEFICIAL, particleColor, false);
        this._cure_profile = cure_profile != null ? cure_profile : "NONE";
        this._bucketful = this._cure_profile.endsWith("_bucket");
    }

    static final void install() {
        NourishmentEffect.install(_MILK_BUCKET, new InstantCurativeEffect(_MILK_BUCKET, 0xFFFFFF));
        NourishmentEffect.install(_HONEY_BUCKET, new InstantCurativeEffect(_HONEY_BUCKET, 15644707));
        NourishmentEffect.install(_BIRCH_BUCKET, new InstantCurativeEffect(_BIRCH_BUCKET, 12897706));
    }

    public final boolean func_76403_b() {
        return true;
    }

    public final boolean func_76397_a(int duration, int amplifier) {
        return true;
    }

    @Override
    public void func_180793_a(Entity from, Entity indirectFrom, LivingEntity target, int amplifier, double healby) {
        Potions.CureProfiles.applyAll(target, this._bucketful ? Potions.CureProfiles.BY_BUCKET : Potions.CureProfiles.CURATIVE, this._cure_profile);
    }
}

