/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

public final class MuscleBoostedEffect
extends WellFedEffect {
    private static WellFedEffect.Profile _PROFILE = new WellFedEffect.Profile(0.15, 0.15, 0.03, 0.15, 0.2, 0.35, 2.0, 0.3);

    MuscleBoostedEffect(String name, int tier) {
        super(name, tier, 4471356);
    }

    @Override
    protected final WellFedEffect.Profile stats() {
        return _PROFILE;
    }

    @Override
    protected int absorption(int amplifier) {
        return amplifier + 1;
    }

    @Override
    protected void initAttributeModifiers() {
        super.initAttributeModifiers();
        if (this.tier() < 2) {
            this.addAttackStrengthModifiers(this.stats());
        }
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship r, EffectInstance ei, int amplifier) {
        boolean boosted = super.performEffect(source, target, r, ei, amplifier);
        if (ei.func_188419_a() == this && r.isGenerous()) {
            Potions.addSecondaryPotionEffect(target, Effects.field_76429_m, this, 1 + (amplifier > 2 ? 1 : 0));
            if (WellnessHelper.manageEnergy()) {
                WellnessHelper.rejuvenateIfTired(target, 0, 0);
            }
            boosted = true;
        }
        return boosted;
    }
}

