/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IWellnessEffect;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.EffectBase;
import org.jwaresoftware.mcmods.lib.impl.ShareableEffectBase;
import org.jwaresoftware.mcmods.lib.impl.effects.AttentivenessEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.EnduranceEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.EnergizedEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.HappinessEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.HydrateEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.InstantCurativeEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffectsEventsHandler;
import org.jwaresoftware.mcmods.lib.impl.effects.ResilienceEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

public abstract class NourishmentEffect
extends ShareableEffectBase
implements IWellnessEffect {
    static final String _donor_marker = "_donor";
    static final Map<String, EffectBase> __INSTANCES = new HashMap<String, EffectBase>();

    static final boolean install(String name, EffectBase instance) {
        return __INSTANCES.putIfAbsent(name, instance) == null;
    }

    protected static final <T extends EffectBase> T get(String name) {
        return (T)__INSTANCES.get(name);
    }

    @Nonnull
    public static final Effect getOrNone(String name) {
        Effect e = __INSTANCES.get(name);
        return e == null ? Potions.NO_EFFECT : e;
    }

    @Nonnull
    public static final Effect getOrPlacebo(String name) {
        return __INSTANCES.getOrDefault(name, (EffectBase)NourishmentEffect.get("placebo"));
    }

    protected NourishmentEffect(IModInfo mod, String name, boolean visible, EffectType type, int particleColor, boolean milkCures) {
        super(mod, name, visible, type, particleColor, milkCures);
    }

    NourishmentEffect(String name, boolean visible, EffectType type, int particleColor, boolean milkCures) {
        this((IModInfo)LibInfo.getInstance(), name, visible, type, particleColor, milkCures);
        IniRegistries.autoregisterPotion(LibInfo.MOD_ID(), this, name);
    }

    NourishmentEffect(String name, boolean visible, int particleColor) {
        this(name, visible, EffectType.BENEFICIAL, particleColor, false);
    }

    @Override
    public int clampedAmplifier(int amplifier) {
        return MathHelper.func_76125_a((int)amplifier, (int)0, (int)3);
    }

    protected void initAttributeModifiers() {
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return this.isReady(_MORE_OFTEN, duration, 0);
    }

    public static final boolean anyPresent(@Nonnull LivingEntity source, @Nonnull Class<? extends Effect> klass) {
        for (EffectInstance ei : source.func_70651_bq()) {
            if (ei == null || !klass.isInstance(ei.func_188419_a())) continue;
            return true;
        }
        return false;
    }

    static final int numberUniqueEffects(LivingEntity target) {
        return target.func_193076_bZ().size();
    }

    protected static final void onAppliedPre(LivingEntity target, int amplifier, String profile) {
        int n_before = WellnessHelper.manageNutrition() && SharedGlue.isaPlayer((Entity)target) ? NourishmentEffect.numberUniqueEffects(target) : -1;
        Potions.CureProfiles.applyAll(target, Potions.CureProfiles.CURATIVE, profile);
        if (n_before <= 0 || NourishmentEffect.numberUniqueEffects(target) != n_before) {
            // empty if block
        }
    }

    public static final void initDefaults() {
        InstantCurativeEffect.install();
        HydrateEffect.install();
        EnduranceEffect.install();
        ResilienceEffect.install();
        EnergizedEffect.install();
        WellFedEffect.install();
        AttentivenessEffect.install();
        HappinessEffect.install();
    }

    public static final void initFinalize() {
        __INSTANCES.values().forEach(e -> {
            if (e instanceof NourishmentEffect) {
                ((NourishmentEffect)e).initAttributeModifiers();
            }
        });
        MinecraftForge.EVENT_BUS.register((Object)new NourishmentEffectsEventsHandler());
        if (!LibConfig.allowFightingFoods()) {
            LibInfo.LOG.info("Builtin 'Fighting Food' aka Kung-Food buffs have been nerfed (will be replaced by the umm 'Happiness' touchy-feely buff)");
        }
    }
}

