/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectUtils;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.effects.EnduranceEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.EnergizedEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.HydrateEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.ResilienceEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;

public final class NourishmentEffectsEventsHandler {
    private static final int _SLEEPING_t = 50;
    static final ArrayList<String> _THIRST_EFFECTS = new ArrayList(5);
    static final ArrayList<String> _FATIGUE_EFFECTS = new ArrayList(5);
    static final ArrayList<String> _EXHAUSTION_DAMAGE = new ArrayList(5);
    static final ArrayList<String> _DEHYDRATION_DAMAGE = new ArrayList(5);

    static final boolean isDehydrating(String effect) {
        return _THIRST_EFFECTS.contains(effect);
    }

    static final boolean isFatiguing(String effect) {
        return _FATIGUE_EFFECTS.contains(effect);
    }

    static final boolean isDehydration(DamageSource ds) {
        String s = ds.func_76355_l();
        return _DEHYDRATION_DAMAGE.contains(s) || s.contains("dehydrat") || s.contains("thirst");
    }

    static final boolean isExhaustion(DamageSource ds) {
        String s = ds.func_76355_l();
        return _EXHAUSTION_DAMAGE.contains(s) || s.contains("exhaust");
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMitigatedPotionApplied(PotionEvent.PotionApplicableEvent e) {
        String applying;
        LivingEntity target = e.getEntityLiving();
        if (!SharedGlue.hasPotionsInEffect(target)) {
            return;
        }
        Effect effect = e.getPotionEffect().func_188419_a();
        String string = applying = effect.getRegistryName() != null ? effect.getRegistryName().toString() : effect.func_76393_a();
        if (target.func_70644_a(HydrateEffect.get()) && NourishmentEffectsEventsHandler.isDehydrating(applying)) {
            e.setResult(Event.Result.DENY);
        }
        if ((target.func_70644_a(EnduranceEffect.get()) || target.func_70644_a(EnergizedEffect.get())) && NourishmentEffectsEventsHandler.isFatiguing(applying)) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWellFedPotionApplied(PotionEvent.PotionApplicableEvent e) {
        LivingEntity target = e.getEntityLiving();
        if (!SharedGlue.hasPotionsInEffect(target)) {
            return;
        }
        Effect effect = e.getPotionEffect().func_188419_a();
        EffectInstance other = WellFedEffect.get(target);
        if (effect instanceof WellFedEffect) {
            if (other != null && other.func_188419_a() != effect) {
                WellFedEffect current = (WellFedEffect)other.func_188419_a();
                WellFedEffect applied = (WellFedEffect)effect;
                if (applied.tier() < current.tier()) {
                    e.setResult(Event.Result.DENY);
                    return;
                }
            }
        } else if (other != null && Potions.isIn(effect, Effects.field_76438_s, "hunger")) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onWellFedPotionApplied(PotionEvent.PotionAddedEvent e) {
        LivingEntity target = e.getEntityLiving();
        Effect effect = e.getPotionEffect().func_188419_a();
        if (effect instanceof WellFedEffect) {
            int tier = ((WellFedEffect)effect).tier();
            EffectInstance lesserOther = null;
            for (EffectInstance current : target.func_70651_bq()) {
                if (current.func_188419_a() == effect || !(current.func_188419_a() instanceof WellFedEffect) || ((WellFedEffect)current.func_188419_a()).tier() > tier) continue;
                lesserOther = current;
                break;
            }
            if (lesserOther != null) {
                Potions.removePotionEffectUnconditionally(target, lesserOther.func_188419_a());
            }
        }
    }

    private boolean onTHEDamagingEvent(LivingEvent e, DamageSource ds) {
        boolean cancelled = false;
        LivingEntity target = e.getEntityLiving();
        if (SharedGlue.isaServerWorld((Entity)target) && SharedGlue.hasPotionsInEffect(target)) {
            if (target.func_70644_a(HydrateEffect.get()) && NourishmentEffectsEventsHandler.isDehydration(ds)) {
                e.setCanceled(true);
            }
            if (target.func_70644_a(EnduranceEffect.get()) && NourishmentEffectsEventsHandler.isExhaustion(ds)) {
                e.setCanceled(true);
            }
            cancelled = e.isCanceled();
        }
        return cancelled;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamagedByTHE(LivingAttackEvent e) {
        this.onTHEDamagingEvent((LivingEvent)e, e.getSource());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamagedByTHE(LivingHurtEvent e) {
        if (this.onTHEDamagingEvent((LivingEvent)e, e.getSource())) {
            e.setAmount(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEnergizedCheckSleeping(SleepingLocationCheckEvent e) {
        LivingEntity target = e.getEntityLiving();
        PlayerEntity player = SharedGlue.getRealPlayerOrNull((Entity)target);
        int a = Potions.getLevel(target, EnergizedEffect.get());
        if (a > 0 && (player == null || player.func_71060_bI() > 50)) {
            e.setResult(Event.Result.DENY);
            if (SharedGlue.isaServerWorld((Entity)player)) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("carrots.msg.nosleep.too.energized"), true);
            }
        }
    }

    private float bestGuessedUnnerfedSpeed(PlayerEntity player, BlockState against) {
        float speedf = player.field_71071_by.func_184438_a(against);
        if (speedf > 1.0f) {
            int efficiency = EnchantmentHelper.func_185293_e((LivingEntity)player);
            ItemStack held = player.func_184614_ca();
            if (efficiency > 0 && !held.func_190926_b()) {
                speedf += (float)(efficiency * efficiency + 1);
            }
        }
        if (EffectUtils.func_205135_a((LivingEntity)player)) {
            speedf *= 1.0f + (float)(EffectUtils.func_205134_b((LivingEntity)player) + 1) * 0.2f;
        }
        return speedf;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergizedCheckBlockBreakSpeed(PlayerEvent.BreakSpeed e) {
        Effect energized;
        PlayerEntity target = SharedGlue.getRealPlayerOrNull((Entity)e.getEntityLiving());
        if (target != null && target.func_70644_a(energized = EnergizedEffect.get())) {
            float modifier = target.func_70660_b(energized).func_76458_c() > 0 ? 1.0f : 0.85f;
            float speed_min = this.bestGuessedUnnerfedSpeed(target, e.getState()) * modifier;
            if (e.getNewSpeed() < speed_min) {
                e.setNewSpeed(speed_min);
            }
        }
    }

    @SubscribeEvent
    public void onResilientHealing(LivingHealEvent e) {
        int a;
        LivingEntity target = e.getEntityLiving();
        if (SharedGlue.isaServerWorld((Entity)target) && (a = Potions.getLevel(target, ResilienceEffect.get())) > 0) {
            if (a > 4) {
                a = 4;
            }
            e.setAmount(e.getAmount() * (1.0f + 0.25f * (float)a));
        }
    }

    static {
        _THIRST_EFFECTS.add("survive:thirst");
        _THIRST_EFFECTS.add("toughasnails:thirst");
        _THIRST_EFFECTS.add("charcoal_pit:drunk");
        _FATIGUE_EFFECTS.add("minecraft:slowness");
        _FATIGUE_EFFECTS.add("survive:tiredness");
        _FATIGUE_EFFECTS.add("survivaloverhaul:exhaustion");
        _FATIGUE_EFFECTS.add("pinklysheep:fatigue");
        _DEHYDRATION_DAMAGE.add("dehydrate");
        _EXHAUSTION_DAMAGE.add("overwork");
    }
}

