/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.IModPotionEffect;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.WellFedEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

public abstract class ResilienceEffect
extends NourishmentEffect {
    public static final String NAME = "resilience";
    static final String NAME_DONOR = "resilience_donor";
    static ResilienceEffect DONATED;

    public static final Effect get() {
        return NourishmentEffect.getOrPlacebo(NAME);
    }

    public static final Effect donor() {
        return NourishmentEffect.getOrPlacebo(NAME_DONOR);
    }

    ResilienceEffect(String name) {
        super(name, true, EffectType.BENEFICIAL, 16744608, false);
    }

    static final void install() {
        DONATED = new Single();
        Validate.isTrue((boolean)NourishmentEffect.install(NAME, DONATED), (String)"Resilience effect installed once", (Object[])new Object[0]);
        NourishmentEffect.install(NAME_DONOR, new Shared());
    }

    @Override
    protected void initAttributeModifiers() {
        WellFedEffect.Profile stats = WellFedEffect.Profile.BASE;
        this.func_220304_a(Attributes.field_233826_i_, "fc7bab23-c395-48fc-90b2-d40afa9be21e", stats.ARMOR, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a(Attributes.field_233827_j_, "63088038-3001-4efb-bc97-761d60048435", stats.ARMOR_TOUGHNESS, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    public boolean canShareWith(LivingEntity to, Effect effect, int amplifier) {
        return !NourishmentEffect.anyPresent(to, ResilienceEffect.class);
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship relationship, EffectInstance ei, int amplifier) {
        boolean applied = false;
        if (source == target) {
            relationship = Relationship.SELF;
        }
        if (ei.func_188419_a() == this && relationship.isGenerous()) {
            applied = true;
            if (relationship.isSelf() || this.getShareLike() == IModPotionEffect.ShareMode.SELECTIVE) {
                boolean partial;
                boolean rejuv;
                Potions.addSecondaryPotionEffect(target, Effects.field_76429_m, this, 0);
                if (WellnessHelper.manageEnergy() && (rejuv = (partial = relationship != Relationship.SELF && amplifier < 2) || WellnessHelper.isHardDifficultyScaled(target) ? WellnessHelper.isAtExtremeFatigue(target) : WellnessHelper.isFatigued(target))) {
                    WellnessHelper.rejuvenateIfTired(target, 0, 0);
                }
            } else if (this.canShareWith(target, DONATED, amplifier)) {
                int a = amplifier > 0 ? Math.min(2, amplifier - 1) : 0;
                Potions.addSharedPotionEffect(target, ei, DONATED, -1, a, ResilienceEffect.showSharedEffectParticles(target));
            } else {
                applied = false;
            }
        }
        return applied;
    }

    private static final class Single
    extends ResilienceEffect {
        Single() {
            super(ResilienceEffect.NAME);
        }
    }

    private static final class Shared
    extends ResilienceEffect {
        Shared() {
            super(ResilienceEffect.NAME_DONOR);
        }

        @Override
        public IModPotionEffect.ShareMode getShareLike() {
            return IModPotionEffect.ShareMode.WHOLESALE;
        }

        @Override
        public IModPotionEffect.ShareTrigger getShareTrigger() {
            return IModPotionEffect.ShareTrigger.EFFECT;
        }
    }
}

