/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.effects;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Villagers;
import org.jwaresoftware.mcmods.lib.api.IModPotionEffect;
import org.jwaresoftware.mcmods.lib.api.Relationship;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.AttributeSupport;
import org.jwaresoftware.mcmods.lib.impl.effects.ExquisitelyStuffedEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.HappinessEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.MuscleBoostedEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.PlentySatisfiedEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.SupremelySatisfiedEffect;

public class WellFedEffect
extends NourishmentEffect {
    public static final String TIER_1 = "well_fed";
    public static final String TIER_2 = "plenty_satisfied";
    public static final String TIER_3 = "supremely_satisfied";
    public static final String TIER_4 = "exquisitely_stuffed";
    public static final String TIER_m = "muscle_boosted";
    public static final String NAME = "well_fed";
    static final int PARTICLE_COLOR = 16634444;
    private static final String[] _NAMES = new String[]{"exquisitely_stuffed", "muscle_boosted", "supremely_satisfied", "plenty_satisfied", "well_fed"};
    private static final Effect[] _TIERS = new Effect[]{Potions.NO_EFFECT, Potions.NO_EFFECT, Potions.NO_EFFECT, Potions.NO_EFFECT, Potions.NO_EFFECT};
    private static final List<ResourceLocation> _SIMILAR = (List)Util.func_200696_a(new ArrayList(), l -> {
        l.add(ModIntegration.FARMERS_DELIGHT.resource("nourished"));
        l.add(new ResourceLocation("wellfedmod", "well_fed"));
    });
    static WellFedEffect DONATED;
    protected static final int _FED_OFTEN;
    protected static final int _FED_LESS_OFTEN;
    protected final int _tier;
    protected final boolean _auto_nourishing;

    public static final Effect get() {
        return WellFedEffect.get_tier1();
    }

    public static final Effect get_tier1() {
        return NourishmentEffect.getOrPlacebo("well_fed");
    }

    public static final Effect get_tier2() {
        return NourishmentEffect.getOrPlacebo(TIER_2);
    }

    public static final Effect get_tier3() {
        return NourishmentEffect.getOrPlacebo(TIER_3);
    }

    public static final Effect get_tier4() {
        return NourishmentEffect.getOrPlacebo(TIER_4);
    }

    public static final Effect get_muscleboost() {
        return NourishmentEffect.getOrPlacebo(TIER_m);
    }

    public static final Effect get_consolation() {
        return HappinessEffect.get();
    }

    public static final Effect get_conditional() {
        return LibConfig.allowFightingFoods() ? WellFedEffect.get() : WellFedEffect.get_consolation();
    }

    public static final Effect get(int tier) {
        switch (tier) {
            case 1: {
                return WellFedEffect.get_tier1();
            }
            case 2: {
                return WellFedEffect.get_tier2();
            }
            case 3: {
                return WellFedEffect.get_tier3();
            }
            case 4: {
                return WellFedEffect.get_tier4();
            }
        }
        return WellFedEffect.get_consolation();
    }

    @Nullable
    public static final EffectInstance get(@Nonnull LivingEntity source) {
        Effect e;
        EffectInstance p = null;
        Effect[] effectArray = _TIERS;
        int n = effectArray.length;
        for (int i = 0; i < n && (p = source.func_70660_b(e = effectArray[i])) == null; ++i) {
        }
        return p;
    }

    public static final boolean isSimiliar(@Nonnull Effect other) {
        return _SIMILAR.contains(other.getRegistryName());
    }

    static final boolean hasOtherNourishmentEffect(@Nonnull LivingEntity source) {
        return source.func_70644_a(Effects.field_76443_y) || source.func_70651_bq().stream().anyMatch(ei -> WellFedEffect.isSimiliar(ei.func_188419_a()));
    }

    WellFedEffect(String name, int tier, int particleColor) {
        super(name, true, particleColor);
        this._tier = tier;
        this._auto_nourishing = true;
    }

    private WellFedEffect() {
        this("well_fed", 0, 16634444);
    }

    protected WellFedEffect(IModInfo mod, String name, int tier, boolean feeds, boolean visible, EffectType type, int particleColor, boolean milkCures) {
        super(mod, name, visible, type, particleColor, milkCures);
        this._tier = tier;
        this._auto_nourishing = feeds;
    }

    static final void install() {
        DONATED = new WellFedEffect();
        Validate.isTrue((boolean)NourishmentEffect.install("well_fed", DONATED), (String)"WellFed effects installed once", (Object[])new Object[0]);
        NourishmentEffect.install(TIER_2, new PlentySatisfiedEffect(TIER_2, 1));
        NourishmentEffect.install(TIER_3, new SupremelySatisfiedEffect(TIER_3, 2));
        NourishmentEffect.install(TIER_4, new ExquisitelyStuffedEffect(TIER_4, 3));
        NourishmentEffect.install(TIER_m, new MuscleBoostedEffect(TIER_m, 1));
        Validate.isTrue((_NAMES.length == _TIERS.length ? 1 : 0) != 0);
        for (int i = 0; i < _NAMES.length; ++i) {
            WellFedEffect._TIERS[i] = NourishmentEffect.getOrNone(_NAMES[i]);
        }
    }

    protected final int tier() {
        return Math.max(0, this._tier);
    }

    @Nonnull
    protected Profile stats() {
        return Profile.BASE;
    }

    protected int absorption(int amplifier) {
        return this.stats().ABSORPTION;
    }

    final void addAttackStrengthModifiers(Profile stats) {
        this.func_220304_a((Attribute)AttributeSupport.PRECISION_ATTRIB.get(), "d801e1c7-654b-4875-81cc-8c40ec5e6a11", stats.PRECISION_ATTRIB, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a(Attributes.field_233823_f_, "af42a1fe-da40-45c4-bbcb-50274137da78", stats.ATTACK_DAMAGE, AttributeModifier.Operation.MULTIPLY_TOTAL);
    }

    @Override
    protected void initAttributeModifiers() {
        Profile stats = this.stats();
        this.func_220304_a(Attributes.field_233826_i_, "182b6b0a-565f-4e98-a098-a359dcb24dcd", stats.ARMOR, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a(Attributes.field_233827_j_, "2f6d1147-967a-4f01-96e8-cb5d79fd88b9", stats.ARMOR_TOUGHNESS, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.func_220304_a(Attributes.field_233824_g_, "a115d46a-a7dc-4b48-8f88-3344cbb7ed78", stats.ATTACK_KNOCKBACK, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (this._tier > 0) {
            this.func_220304_a(Attributes.field_233821_d_, "0afa3663-1023-4d81-9a51-58354f58ba0a", stats.MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
            this.func_220304_a(Attributes.field_233825_h_, "c827bb75-0c1e-4f91-b1b4-cfe68ea996fa", stats.ATTACK_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
            this.func_220304_a((Attribute)AttributeSupport.ENTITY_BLOCKBREAK_SPEED_ATTRIB.get(), "304beda3-5e4f-42d6-91bd-9e7065440605", stats.MINING_SPEED, AttributeModifier.Operation.ADDITION);
            this.func_220304_a((Attribute)ForgeMod.SWIM_SPEED.get(), "10173cea-60d0-42c6-9efc-6f6418a55b10", stats.MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
            if (this._tier > 1) {
                this.addAttackStrengthModifiers(stats);
                this.func_220304_a((Attribute)AttributeSupport.HAPPENSTANCE_ATTRIB.get(), "72bd1678-a3af-49e0-af8c-1f180cb1a678", 1.0, AttributeModifier.Operation.ADDITION);
                this.func_220304_a(Attributes.field_233822_e_, "44890500-4eed-477c-a30c-405ae513d806", stats.MOVEMENT_SPEED, AttributeModifier.Operation.MULTIPLY_TOTAL);
            }
        }
    }

    @Override
    public boolean performEffect(LivingEntity source, LivingEntity target, Relationship relationship, EffectInstance ei, int amplifier) {
        boolean applied = false;
        if (ei.func_188419_a() == this && relationship.isOverlyGenerous()) {
            if (relationship.isSelf() || this.getShareLike() == IModPotionEffect.ShareMode.SELECTIVE) {
                int tier;
                applied = true;
                NourishmentEffect.onAppliedPre(target, 0, "hunger");
                amplifier = this.clampedAmplifier(amplifier);
                int duration = ei.func_76459_b();
                int n = tier = relationship.isSelf() ? this.tier() : DONATED.tier();
                if (!this.ensureMinimalAbsorption(target, amplifier, 0.0f) && this.shouldNourish(tier, target, duration, amplifier)) {
                    this.addNourishment(tier, target, amplifier);
                }
            } else if (this.canShareWith(target, DONATED, amplifier)) {
                applied = Potions.addSharedPotionEffect(target, ei, DONATED, -1, 0, WellFedEffect.showSharedEffectParticles(target));
            }
        }
        return applied;
    }

    protected boolean shouldNourish(int tier, LivingEntity target, int duration, int amplifier) {
        if (!this._auto_nourishing || WellFedEffect.hasOtherNourishmentEffect(target)) {
            return false;
        }
        return this.isReady(tier > 2 || tier > 1 && amplifier > 0 ? _FED_OFTEN : _FED_LESS_OFTEN, duration, 0);
    }

    @Override
    public boolean isShareable(EffectInstance state, LivingEntity from) {
        return super.isShareable(state, from) && SharedGlue.isaPlayerOrFriendly((Entity)from);
    }

    @Override
    public boolean canShareWith(LivingEntity to, Effect effect, int amplifier) {
        return effect == DONATED && !WellFedEffect.hasOtherNourishmentEffect(to) && !NourishmentEffect.anyPresent(to, WellFedEffect.class);
    }

    private void checkExhaustion(PlayerEntity player, FoodStats food, int pace_ticks) {
        boolean helpHeal;
        int highFoodLevel = SharedGlue.DEFAULT_MAX_PLAYER_FOOD_LEVEL();
        boolean bl = helpHeal = player.func_70996_bM() && player.func_130014_f_().func_82736_K().func_223586_b(SharedGlue.GAMERULE_NATURAL_REGEN()) && food.func_75116_a() >= highFoodLevel - SharedGlue.PLAYER_ONE_FOOD_LEVEL();
        if (helpHeal) {
            if (food.func_75115_e() > 0.0f && food.func_75116_a() >= highFoodLevel) {
                food.field_75123_d = Math.max(food.field_75123_d, 10 - pace_ticks);
            } else if (food.field_75123_d > 10) {
                food.field_75123_d = Math.max(food.field_75123_d, 80 - pace_ticks);
            }
        } else if (food.field_75126_c > 0.1f) {
            player.func_71020_j(-0.1f);
        }
    }

    protected void addNourishment(int tier, LivingEntity target, int amplifier) {
        int amount = Math.min(4, tier + 1);
        if (SharedGlue.isaPlayer((Entity)target)) {
            int highFoodLevel = SharedGlue.DEFAULT_MAX_PLAYER_FOOD_LEVEL();
            PlayerEntity player = (PlayerEntity)target;
            FoodStats food = player.func_71024_bL();
            if (tier > 1 || tier > 0 && amplifier > 0) {
                this.checkExhaustion(player, food, tier > 2 ? 0 : 3);
            }
            if (food.func_75116_a() < highFoodLevel - SharedGlue.PLAYER_ONE_FOOD_LEVEL() || !player.func_70996_bM() && food.func_75116_a() < highFoodLevel) {
                food.func_75122_a(amount, 20.0f / (2.0f * (float)amount));
            }
        } else if (Villagers.isaFriendly((Entity)target, true)) {
            if (target.func_110143_aJ() < target.func_110138_aP()) {
                target.func_70691_i((float)amount);
            }
            if (target instanceof VillagerEntity) {
                VillagerEntity villager = (VillagerEntity)target;
                if (villager.field_213781_bL <= 24) {
                    villager.field_213781_bL = (byte)(villager.field_213781_bL + 1);
                }
            }
        } else if (SharedGlue.isaAnimal((Entity)target) && target.func_110143_aJ() < target.func_110138_aP()) {
            target.func_70691_i((float)amount);
        }
    }

    protected final boolean ensureMinimalAbsorption(LivingEntity target, int amplifier, float baseAbsorption) {
        boolean buffed = false;
        int absorption = this.absorption(amplifier);
        if (absorption > 0) {
            float min = baseAbsorption + 4.0f * (float)Math.min(5, absorption);
            if (target.func_110139_bj() < min) {
                target.func_110149_m(min);
                buffed = true;
            }
        }
        return buffed;
    }

    @Override
    public void func_111185_a(LivingEntity target, AttributeModifierManager am, int amplifier) {
        amplifier = this.clampedAmplifier(amplifier);
        this.ensureMinimalAbsorption(target, amplifier, target.func_110139_bj());
        super.func_111185_a(target, am, amplifier);
    }

    @Override
    public void func_111187_a(LivingEntity target, AttributeModifierManager am, int amplifier) {
        int absorption = this.absorption(amplifier = this.clampedAmplifier(amplifier));
        if (absorption > 0) {
            target.func_110149_m(target.func_110139_bj() - 4.0f * (float)Math.min(5, absorption));
        }
        super.func_111187_a(target, am, amplifier);
    }

    static {
        _FED_OFTEN = (int)(2.5f * (float)_1SEC_TICKS);
        _FED_LESS_OFTEN = 5 * _1SEC_TICKS;
    }

    public static final class Profile {
        double ARMOR = 0.1;
        double ARMOR_TOUGHNESS = 0.1;
        public int ABSORPTION = 0;
        double ATTACK_KNOCKBACK = 0.15;
        double MOVEMENT_SPEED = 0.2;
        double MINING_SPEED = 1.0;
        double PRECISION_ATTRIB = 0.02;
        double ATTACK_SPEED = 0.05;
        double ATTACK_DAMAGE = 0.05;
        static final Profile BASE = new Profile();

        Profile() {
        }

        public Profile(double ar, double arT, double pr, double atS, double atD, double atK, double ms, double mv) {
            this.ARMOR = ar;
            this.ARMOR_TOUGHNESS = arT;
            this.PRECISION_ATTRIB = pr;
            this.ATTACK_SPEED = atS;
            this.ATTACK_DAMAGE = atD;
            this.ATTACK_KNOCKBACK = atK;
            this.MINING_SPEED = ms;
            this.MOVEMENT_SPEED = mv;
        }

        public Profile copy() {
            Profile p = new Profile(this.ARMOR, this.ARMOR_TOUGHNESS, this.PRECISION_ATTRIB, this.ATTACK_SPEED, this.ATTACK_DAMAGE, this.ATTACK_KNOCKBACK, this.MINING_SPEED, this.MOVEMENT_SPEED);
            p.ABSORPTION = this.ABSORPTION;
            return p;
        }

        public Profile absorbs(int i) {
            this.ABSORPTION = i;
            return this;
        }
    }
}

